/*
 * Decompiled with CFR 0.152.
 */
package com.cupboard.mixin;

import com.cupboard.Cupboard;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={Entity.class})
public abstract class EntityLoadMixin {
    @Shadow
    private float f_19858_;

    @Shadow
    public abstract double m_20185_();

    @Shadow
    public abstract double m_20186_();

    @Shadow
    public abstract double m_20189_();

    @Shadow
    public abstract float m_146908_();

    @Shadow
    public abstract float m_146909_();

    @Shadow
    public abstract void m_20343_(double var1, double var3, double var5);

    @Shadow
    public abstract void m_146926_(float var1);

    @Shadow
    public abstract void m_146922_(float var1);

    @Inject(method={"load"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;setYBodyRot(F)V", shift=At.Shift.AFTER)})
    private void avoidLoadCrash(CompoundTag compoundTag, CallbackInfo ci) {
        if (!(Double.isFinite(this.m_20185_()) && Double.isFinite(this.m_20186_()) && Double.isFinite(this.m_20189_()) || !Cupboard.config.getCommonConfig().skipErrorOnEntityLoad)) {
            Cupboard.LOGGER.warn("Prevented crash for entity loaded with invalid position, defaulting to 0 70 0. Nbt:" + compoundTag.toString());
            this.m_20343_(0.0, 70.0, 0.0);
        }
        if (!Double.isFinite(this.m_146908_()) || !Double.isFinite(this.m_146909_())) {
            Cupboard.LOGGER.warn("Prevented crash for entity loaded with invalid rotations, defaulting to 0 0. Nbt:" + compoundTag.toString());
            this.m_146926_(0.0f);
            this.m_146922_(0.0f);
        }
    }

    @Inject(method={"load"}, at={@At(value="INVOKE", target="Lnet/minecraft/CrashReport;forThrowable(Ljava/lang/Throwable;Ljava/lang/String;)Lnet/minecraft/CrashReport;")}, cancellable=true, locals=LocalCapture.CAPTURE_FAILSOFT)
    private void skipLoadingErroringEntity(CompoundTag compoundTag, CallbackInfo ci, Throwable throwable) {
        if (Cupboard.config.getCommonConfig().skipErrorOnEntityLoad) {
            Cupboard.LOGGER.warn("Prevented crash for entity load. Nbt:" + compoundTag.toString(), throwable);
            ci.cancel();
        }
    }
}

