/*
 * Decompiled with CFR 0.152.
 */
package com.eccarrascon.structurecredits.event;

import com.catastrophe573.dimdungeons.dimension.DungeonData;
import com.catastrophe573.dimdungeons.structure.DungeonRoom;
import com.catastrophe573.dimdungeons.utils.DungeonUtils;
import com.eccarrascon.structurecredits.ConfigData;
import com.eccarrascon.structurecredits.StructureCredits;
import com.eccarrascon.structurecredits.event.ObtainAllStructuresEvent;
import com.eccarrascon.structurecredits.registry.KeyMapRegistry;
import dev.architectury.event.events.common.TickEvent;
import dev.architectury.utils.GameInstance;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;

public class DetectStructure
implements TickEvent.Player {
    private ResourceKey<Structure> actualStructure;
    private String actualDimensionalStructure;
    private boolean justDisplayed = false;
    private Integer tickCounter = 0;
    private Integer tickCounterForDisplay = 0;
    private boolean showAgain = false;
    int namesWordCount = 0;
    private boolean isInDontShowAll = false;

    public static ServerLevel getServerLevel(Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return serverLevel;
        }
        MinecraftServer server = GameInstance.getServer();
        return server == null ? null : server.m_129880_(level.m_46472_());
    }

    public void tick(Player player) {
        boolean isActive = StructureCredits.CONFIG_VALUES.isActive();
        if (player.m_9236_().m_5776_()) {
            while (KeyMapRegistry.DEACTIVATE_MSG_KEYMAPPING.m_90859_()) {
                boolean bl = isActive = !isActive;
                if (!isActive) {
                    player.m_5661_((Component)Component.m_237115_((String)"text.structurecredits.deactivated"), true);
                    StructureCredits.CONFIG_VALUES.setActive(false);
                    ConfigData.save(StructureCredits.CONFIG_VALUES);
                    continue;
                }
                player.m_5661_((Component)Component.m_237115_((String)"text.structurecredits.activated"), true);
                StructureCredits.CONFIG_VALUES.setActive(true);
                ConfigData.save(StructureCredits.CONFIG_VALUES);
            }
            while (KeyMapRegistry.SHOW_AGAIN_MSG_KEYMAPPING.m_90859_()) {
                if (this.actualStructure == null) continue;
                this.showAgain = true;
                this.displayStructureMessage(player, this.actualStructure);
            }
            while (KeyMapRegistry.DONT_SHOW_MSG_KEYMAPPING.m_90859_()) {
                if (this.actualStructure == null) continue;
                if (!StructureCredits.CONFIG_VALUES.getDontShow().contains(this.actualStructure.m_135782_().toString())) {
                    player.m_5661_((Component)Component.m_237115_((String)"text.structurecredits.dont_show"), true);
                    StructureCredits.CONFIG_VALUES.getDontShow().add(this.actualStructure.m_135782_().toString());
                    ConfigData.save(StructureCredits.CONFIG_VALUES);
                    continue;
                }
                player.m_5661_((Component)Component.m_237115_((String)"text.structurecredits.already_dont_show"), true);
            }
            return;
        }
        if (!isActive) {
            return;
        }
        if (StructureCredits.DIMD_COMPAT && DungeonUtils.isDimensionDungeon((Level)player.m_9236_())) {
            DungeonRoom room = DungeonData.get((Level)player.m_9236_()).getRoomAtPos(player.m_146902_());
            if (!(room == null || this.actualDimensionalStructure != null && this.actualDimensionalStructure.matches(room.structure))) {
                this.actualDimensionalStructure = room.structure;
                this.displayDimensionalDungeonMessage(player, this.actualDimensionalStructure);
            }
        } else {
            this.isPlayerInAnyStructure(player, DetectStructure.getServerLevel(player.m_9236_()), player.m_20185_(), player.m_20186_(), player.m_20189_());
        }
    }

    public void isPlayerInAnyStructure(Player player, ServerLevel level, double x, double y, double z) {
        if (this.actualStructure != null && LocationPredicate.m_220589_(this.actualStructure).m_52617_(level, x, y, z)) {
            if (!StructureCredits.CONFIG_VALUES.isChatMessage() && this.justDisplayed) {
                if (this.namesWordCount > 22 && this.tickCounterForDisplay <= 40 || this.namesWordCount > 15 && this.tickCounterForDisplay <= 20) {
                    Integer n = this.tickCounterForDisplay;
                    this.tickCounterForDisplay = this.tickCounterForDisplay + 1;
                } else {
                    this.displayStructureMessage(player, this.actualStructure);
                    this.justDisplayed = false;
                    this.tickCounterForDisplay = 0;
                }
            }
            return;
        }
        if (this.actualStructure != null && !LocationPredicate.m_220589_(this.actualStructure).m_52617_(level, x, y, z)) {
            this.actualStructure = null;
            this.tickCounter = 1;
        }
        if (this.tickCounter >= 1) {
            if (this.tickCounter <= StructureCredits.CONFIG_VALUES.getCooldown() * 20) {
                Integer n = this.tickCounter;
                this.tickCounter = this.tickCounter + 1;
            } else if (this.tickCounter >= StructureCredits.CONFIG_VALUES.getCooldown() * 20) {
                this.tickCounter = 0;
            }
        }
        if (this.tickCounter != 0) {
            return;
        }
        for (ResourceKey resourceKey : ObtainAllStructuresEvent.allStructures) {
            LocationPredicate locationPredicate = LocationPredicate.m_220589_((ResourceKey)resourceKey);
            if (!locationPredicate.m_52617_(level, x, y, z)) continue;
            this.displayStructureMessage(player, (ResourceKey<Structure>)resourceKey);
            this.justDisplayed = true;
        }
    }

    private void displayStructureMessage(Player player, ResourceKey<Structure> structureKey) {
        String fullLocation = structureKey.m_135782_().toString();
        String[] parts = fullLocation.split(":");
        if (parts.length == 2) {
            String modName = parts[0];
            String structureName = parts[1];
            modName = Arrays.stream(modName.split("_")).map(word -> word.substring(0, 1).toUpperCase() + word.substring(1)).collect(Collectors.joining(" "));
            structureName = Arrays.stream(structureName.split("_")).map(word -> word.substring(0, 1).toUpperCase() + word.substring(1)).collect(Collectors.joining(" "));
            this.namesWordCount = modName.replace(" ", "").length() + structureName.replace(" ", "").length();
            this.isInDontShowAllList(fullLocation);
            if (this.showAgain || !this.isInDontShowAll && !StructureCredits.CONFIG_VALUES.getDontShow().contains(fullLocation)) {
                player.m_5661_((Component)Component.m_237110_((String)"text.structurecredits.message", (Object[])new Object[]{structureName, modName}), !StructureCredits.CONFIG_VALUES.isChatMessage());
                if (StructureCredits.CONFIG_VALUES.isOnlyOneTime() && !StructureCredits.CONFIG_VALUES.getDontShow().contains(fullLocation)) {
                    StructureCredits.CONFIG_VALUES.getDontShow().add(fullLocation);
                    ConfigData.save(StructureCredits.CONFIG_VALUES);
                }
                this.showAgain = false;
                if (!StructureCredits.CONFIG_VALUES.isInfoMessageSent()) {
                    player.m_5661_((Component)Component.m_237115_((String)"text.structurecredits.info_message"), false);
                    StructureCredits.CONFIG_VALUES.setInfoMessageSent(true);
                    ConfigData.save(StructureCredits.CONFIG_VALUES);
                }
            }
            this.actualStructure = structureKey;
        }
    }

    private void displayDimensionalDungeonMessage(Player player, String structureKey) {
        String[] parts = structureKey.split(":");
        if (parts.length == 2) {
            String modName = parts[0];
            String structureName = parts[1];
            modName = Arrays.stream(modName.split("_")).map(word -> word.substring(0, 1).toUpperCase() + word.substring(1)).collect(Collectors.joining(" "));
            structureName = Arrays.stream(structureName.split("_")).map(word -> word.substring(0, 1).toUpperCase() + word.substring(1)).collect(Collectors.joining(" "));
            this.isInDontShowAllList(structureKey);
            if (!this.isInDontShowAll && !StructureCredits.CONFIG_VALUES.getDontShow().contains(structureKey)) {
                player.m_5661_((Component)Component.m_237110_((String)"text.structurecredits.message_dimensional_dungeon", (Object[])new Object[]{structureName, modName}), !StructureCredits.CONFIG_VALUES.isChatMessage());
                if (StructureCredits.CONFIG_VALUES.isOnlyOneTime()) {
                    StructureCredits.CONFIG_VALUES.getDontShow().add(structureKey);
                    ConfigData.save(StructureCredits.CONFIG_VALUES);
                }
            }
        }
    }

    private void isInDontShowAllList(String structureKey) {
        this.isInDontShowAll = false;
        for (String prefix : StructureCredits.CONFIG_VALUES.getDontShowAll()) {
            if (!structureKey.startsWith(prefix)) continue;
            this.isInDontShowAll = true;
            break;
        }
    }
}

