/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery;

import de.cristelknight.doapi.DoApiEP;
import dev.architectury.event.events.common.EntityEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.hooks.item.tool.AxeItemHooks;
import dev.architectury.hooks.item.tool.ShovelItemHooks;
import dev.architectury.registry.fuel.FuelRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.satisfy.vinery.config.VineryConfig;
import net.satisfy.vinery.event.EntityDamageEvent;
import net.satisfy.vinery.event.ParticleSpawnEvent;
import net.satisfy.vinery.registry.BlockEntityTypeRegistry;
import net.satisfy.vinery.registry.BoatAndSignRegistry;
import net.satisfy.vinery.registry.DataFixerRegistry;
import net.satisfy.vinery.registry.EntityRegistry;
import net.satisfy.vinery.registry.FlammableBlockRegistry;
import net.satisfy.vinery.registry.GrapeTypeRegistry;
import net.satisfy.vinery.registry.MobEffectRegistry;
import net.satisfy.vinery.registry.ObjectRegistry;
import net.satisfy.vinery.registry.RecipeTypesRegistry;
import net.satisfy.vinery.registry.ScreenhandlerTypeRegistry;
import net.satisfy.vinery.registry.SoundEventRegistry;
import net.satisfy.vinery.registry.TabRegistry;
import net.satisfy.vinery.util.VineryIdentifier;
import net.satisfy.vinery.world.VineryFeatures;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Vinery {
    public static final String MOD_ID = "vinery";
    public static final Logger LOGGER = LogManager.getLogger((String)"vinery");

    public static void init() {
        DataFixerRegistry.init();
        VineryConfig config = Vinery.loadConfig();
        VineryConfig validatedConfig = config.validate();
        validatedConfig.setInstance(validatedConfig);
        ObjectRegistry.init();
        ObjectRegistry.initItemsWithConfig();
        TabRegistry.init();
        BoatAndSignRegistry.init();
        BlockEntityTypeRegistry.init();
        MobEffectRegistry.init();
        ScreenhandlerTypeRegistry.init();
        RecipeTypesRegistry.init();
        EntityRegistry.init();
        VineryFeatures.init();
        SoundEventRegistry.init();
        ParticleSpawnEvent particleSpawnEvent = new ParticleSpawnEvent();
        PlayerEvent.ATTACK_ENTITY.register((Object)particleSpawnEvent);
        EntityDamageEvent entityDamageEvent = new EntityDamageEvent();
        EntityEvent.LIVING_HURT.register((Object)entityDamageEvent);
        DoApiEP.registerBuiltInPack((String)MOD_ID, (ResourceLocation)new VineryIdentifier("bushy_leaves"), (boolean)false);
    }

    public static void commonSetup() {
        FlammableBlockRegistry.init();
        GrapeTypeRegistry.addGrapeAttributes();
        FuelRegistry.register((int)300, (ItemLike[])new ItemLike[]{(ItemLike)ObjectRegistry.DARK_CHERRY_FENCE.get(), (ItemLike)ObjectRegistry.DARK_CHERRY_FENCE_GATE.get(), (ItemLike)ObjectRegistry.STACKABLE_LOG.get(), (ItemLike)ObjectRegistry.FERMENTATION_BARREL.get()});
        AxeItemHooks.addStrippable((Block)((Block)ObjectRegistry.DARK_CHERRY_LOG.get()), (Block)((Block)ObjectRegistry.STRIPPED_DARK_CHERRY_LOG.get()));
        AxeItemHooks.addStrippable((Block)((Block)ObjectRegistry.DARK_CHERRY_WOOD.get()), (Block)((Block)ObjectRegistry.STRIPPED_DARK_CHERRY_WOOD.get()));
        AxeItemHooks.addStrippable((Block)((Block)ObjectRegistry.APPLE_LOG.get()), (Block)Blocks.f_50010_);
        AxeItemHooks.addStrippable((Block)((Block)ObjectRegistry.APPLE_WOOD.get()), (Block)Blocks.f_50044_);
        ShovelItemHooks.addFlattenable((Block)((Block)ObjectRegistry.GRASS_SLAB.get()), (BlockState)Blocks.f_152481_.m_49966_());
    }

    private static VineryConfig loadConfig() {
        VineryConfig config = (VineryConfig)VineryConfig.DEFAULT.getConfig();
        return config.validate();
    }
}

