/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.client.gui.handler;

import de.cristelknight.doapi.client.recipebook.IRecipeBookGroup;
import de.cristelknight.doapi.client.recipebook.handler.AbstractRecipeBookGUIScreenHandler;
import java.util.List;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.satisfy.vinery.client.gui.handler.slot.ExtendedSlot;
import net.satisfy.vinery.client.gui.handler.slot.StoveOutputSlot;
import net.satisfy.vinery.client.recipebook.group.FermentationBarrelRecipeBookGroup;
import net.satisfy.vinery.recipe.FermentationBarrelRecipe;
import net.satisfy.vinery.registry.ObjectRegistry;
import net.satisfy.vinery.registry.RecipeTypesRegistry;
import net.satisfy.vinery.registry.ScreenhandlerTypeRegistry;

public class FermentationBarrelGuiHandler
extends AbstractRecipeBookGUIScreenHandler {
    public FermentationBarrelGuiHandler(int syncId, Inventory playerInventory) {
        this(syncId, playerInventory, (Container)new SimpleContainer(6), (ContainerData)new SimpleContainerData(2));
    }

    public FermentationBarrelGuiHandler(int syncId, Inventory playerInventory, Container inventory, ContainerData propertyDelegate) {
        super((MenuType)ScreenhandlerTypeRegistry.FERMENTATION_BARREL_GUI_HANDLER.get(), syncId, 5, playerInventory, inventory, propertyDelegate);
        this.buildBlockEntityContainer(playerInventory, inventory);
        this.buildPlayerContainer(playerInventory);
    }

    private void buildBlockEntityContainer(Inventory playerInventory, Container inventory) {
        this.m_38897_(new ExtendedSlot(inventory, 0, 79, 51, stack -> stack.m_150930_((Item)ObjectRegistry.WINE_BOTTLE.get())));
        this.m_38897_(new ExtendedSlot(inventory, 1, 33, 26, this::isIngredient));
        this.m_38897_(new ExtendedSlot(inventory, 2, 51, 26, this::isIngredient));
        this.m_38897_(new ExtendedSlot(inventory, 3, 33, 44, this::isIngredient));
        this.m_38897_(new ExtendedSlot(inventory, 4, 51, 44, this::isIngredient));
        this.m_38897_(new StoveOutputSlot(playerInventory.f_35978_, inventory, 5, 128, 35));
    }

    private void buildPlayerContainer(Inventory playerInventory) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    private boolean isIngredient(ItemStack stack) {
        return this.world.m_7465_().m_44013_((RecipeType)RecipeTypesRegistry.FERMENTATION_BARREL_RECIPE_TYPE.get()).stream().anyMatch(recipe -> recipe.m_7527_().stream().anyMatch(x -> x.test(stack)));
    }

    public int getScaledProgress(int arrowWidth) {
        int progress = this.propertyDelegate.m_6413_(0);
        int totalProgress = this.propertyDelegate.m_6413_(1);
        if (progress == 0) {
            return 0;
        }
        return progress * arrowWidth / totalProgress + 1;
    }

    public List<IRecipeBookGroup> getGroups() {
        return FermentationBarrelRecipeBookGroup.FERMENTATION_GROUPS;
    }

    public boolean hasIngredient(Recipe<?> recipe) {
        if (recipe instanceof FermentationBarrelRecipe) {
            FermentationBarrelRecipe fermentationBarrelRecipe = (FermentationBarrelRecipe)recipe;
            for (Ingredient ingredient : fermentationBarrelRecipe.m_7527_()) {
                boolean found = false;
                for (Slot slot : this.f_38839_) {
                    if (!ingredient.test(slot.m_7993_())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
            for (Slot slot : this.f_38839_) {
                if (slot.m_7993_().m_41720_() != ((Item)ObjectRegistry.WINE_BOTTLE.get()).m_5456_()) continue;
                return true;
            }
        }
        return false;
    }

    public int getCraftingSlotCount() {
        return 5;
    }
}

