/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.compat.jei.category;

import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import net.satisfy.vinery.client.gui.FermentationBarrelGui;
import net.satisfy.vinery.compat.jei.VineryJEIPlugin;
import net.satisfy.vinery.recipe.FermentationBarrelRecipe;
import net.satisfy.vinery.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;

public class FermentationBarrelCategory
implements IRecipeCategory<FermentationBarrelRecipe> {
    public static final RecipeType<FermentationBarrelRecipe> FERMENTATION_BARREL = RecipeType.create((String)"vinery", (String)"wine_fermentation", FermentationBarrelRecipe.class);
    public static final int WIDTH = 124;
    public static final int HEIGHT = 60;
    public static final int WIDTH_OF = 26;
    public static final int HEIGHT_OF = 13;
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableAnimated arrow;
    private final Component localizedName;

    public FermentationBarrelCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(FermentationBarrelGui.BACKGROUND, 26, 13, 124, 60);
        this.arrow = helper.drawableBuilder(FermentationBarrelGui.BACKGROUND, 177, 17, 23, 10).buildAnimated(50, IDrawableAnimated.StartDirection.LEFT, false);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)((Block)ObjectRegistry.FERMENTATION_BARREL.get()).m_5456_().m_7968_());
        this.localizedName = Component.m_237115_((String)"rei.vinery.fermentation_barrel_category");
    }

    public void setRecipe(IRecipeLayoutBuilder builder, FermentationBarrelRecipe recipe, IFocusGroup focuses) {
        NonNullList<Ingredient> ingredients = recipe.m_7527_();
        int s = ingredients.size();
        builder.addSlot(RecipeIngredientRole.INPUT, 53, 38).addItemStack(((Item)ObjectRegistry.WINE_BOTTLE.get()).m_7968_());
        if (s > 0) {
            VineryJEIPlugin.addSlot(builder, 7, 13, (Ingredient)ingredients.get(0));
        }
        if (s > 1) {
            VineryJEIPlugin.addSlot(builder, 25, 13, (Ingredient)ingredients.get(1));
        }
        if (s > 2) {
            VineryJEIPlugin.addSlot(builder, 7, 31, (Ingredient)ingredients.get(2));
        }
        if (s > 3) {
            VineryJEIPlugin.addSlot(builder, 25, 31, (Ingredient)ingredients.get(3));
        }
        assert (Minecraft.m_91087_().f_91073_ != null);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 102, 22).addItemStack(recipe.m_8043_(Minecraft.m_91087_().f_91073_.m_9598_()));
    }

    public void draw(FermentationBarrelRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.arrow.draw(guiGraphics, 68, 24);
    }

    @NotNull
    public RecipeType<FermentationBarrelRecipe> getRecipeType() {
        return FERMENTATION_BARREL;
    }

    @NotNull
    public Component getTitle() {
        return this.localizedName;
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }
}

