/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.mixin;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.satisfy.vinery.registry.MobEffectRegistry;
import net.satisfy.vinery.util.FoodComponent;
import net.satisfy.vinery.util.WineYears;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    @Shadow
    @Final
    private Map<MobEffect, MobEffectInstance> f_20945_;

    protected LivingEntityMixin(EntityType<?> type, Level world) {
        super(type, world);
    }

    @Unique
    private boolean hasStatusEffect(MobEffect effect) {
        return this.f_20945_.containsKey(effect);
    }

    @Inject(method={"addEatEffect"}, at={@At(value="HEAD")}, cancellable=true)
    private void applyFoodEffects(ItemStack stack, Level world, LivingEntity targetEntity, CallbackInfo ci) {
        if (stack.m_41614_() && stack.m_41720_().m_41473_() instanceof FoodComponent) {
            ci.cancel();
            Item item = stack.m_41720_();
            if (item.m_41472_()) {
                List list = item.m_41473_().m_38749_();
                for (Pair pair : list) {
                    if (world.f_46443_ || pair.getFirst() == null || !(world.f_46441_.m_188501_() < ((Float)pair.getSecond()).floatValue())) continue;
                    MobEffectInstance statusEffectInstance = new MobEffectInstance((MobEffectInstance)pair.getFirst());
                    statusEffectInstance.f_19504_ = WineYears.getEffectLevel(stack, world);
                    if (statusEffectInstance.m_19544_().equals(MobEffects.f_19601_) || statusEffectInstance.m_19544_().equals(MobEffects.f_19602_)) {
                        statusEffectInstance.f_19503_ = 1;
                    }
                    targetEntity.m_7292_(statusEffectInstance);
                }
            }
        }
    }

    @Redirect(method={"calculateFallDamage"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getEffect(Lnet/minecraft/world/effect/MobEffect;)Lnet/minecraft/world/effect/MobEffectInstance;"))
    public MobEffectInstance improvedJumpBoostFall(LivingEntity livingEntity, MobEffect effect) {
        return livingEntity.m_21023_((MobEffect)MobEffectRegistry.IMPROVED_JUMP_BOOST.get()) ? livingEntity.m_21124_((MobEffect)MobEffectRegistry.IMPROVED_JUMP_BOOST.get()) : livingEntity.m_21124_(MobEffects.f_19603_);
    }

    @Inject(method={"getJumpBoostPower"}, at={@At(value="HEAD")}, cancellable=true)
    private void improvedJumpBoost(CallbackInfoReturnable<Float> cir) {
        if (this.hasStatusEffect((MobEffect)MobEffectRegistry.IMPROVED_JUMP_BOOST.get())) {
            cir.setReturnValue((Object)Float.valueOf(0.1f * (float)(this.f_20945_.get(MobEffectRegistry.IMPROVED_JUMP_BOOST.get()).m_19564_() + 1)));
        }
    }
}

