/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.illuminations.client.config;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;
import java.util.function.Consumer;
import ladysnake.illuminations.client.config.DefaultConfig;
import ladysnake.illuminations.client.enums.EyesInTheDarkSpawnRate;
import ladysnake.illuminations.client.enums.FireflySpawnRate;
import ladysnake.illuminations.client.enums.GlowwormSpawnRate;
import ladysnake.illuminations.client.enums.HalloweenFeatures;
import ladysnake.illuminations.client.enums.PlanktonSpawnRate;
import ladysnake.illuminations.client.enums.WillOWispsSpawnRate;
import net.minecraftforge.fml.loading.FMLPaths;

public class Config {
    public static final Path PROPERTIES_PATH = FMLPaths.CONFIGDIR.get().resolve("illuminations.properties");
    private static final Properties config = new Properties();
    private static HalloweenFeatures halloweenFeatures;
    private static EyesInTheDarkSpawnRate eyesInTheDarkSpawnRate;
    private static WillOWispsSpawnRate willOWispsSpawnRate;
    private static FireflySpawnRate fireflySpawnRate;
    private static GlowwormSpawnRate glowwormSpawnRate;
    private static PlanktonSpawnRate planktonSpawnRate;
    private static int chorusPetalsSpawnMultiplier;
    private static int density;
    private static boolean fireflySpawnAlways;
    private static boolean fireflySpawnUnderground;
    private static int fireflyWhiteAlpha;
    private static boolean fireflyRainbow;
    private static boolean viewAurasFP;
    private static boolean debugMode;
    private static boolean displayCosmetics;

    public static void load() {
        if (Files.isRegularFile(PROPERTIES_PATH, new LinkOption[0])) {
            try {
                config.load(Files.newBufferedReader(PROPERTIES_PATH));
            }
            catch (IOException var1) {
                var1.printStackTrace();
            }
            Config.parseProperty("halloween-features", Config::setHalloweenFeatures, DefaultConfig.HALLOWEEN_FEATURES);
            Config.parseProperty("eyes-in-the-dark-spawn-rate", Config::setEyesInTheDarkSpawnRate, DefaultConfig.EYES_IN_THE_DARK_SPAWN_RATE);
            Config.parseProperty("will-o-wisps-spawn-rate", Config::setWillOWispsSpawnRate, DefaultConfig.WILL_O_WISPS_SPAWN_RATE);
            Config.parseProperty("fireflies-spawn-rate", Config::setFireflySpawnRate, DefaultConfig.FIREFLY_SPAWN_RATE);
            Config.parseProperty("glowworm-spawn-rate", Config::setGlowwormSpawnRate, DefaultConfig.GLOWWORM_SPAWN_RATE);
            Config.parseProperty("plankton-spawn-rate", Config::setPlanktonSpawnRate, DefaultConfig.PLANKTON_SPAWN_RATE);
            Config.parseProperty("chorus-petal-spawn-multiplier", Config::setChorusPetalsSpawnMultiplier, 1);
            Config.parseProperty("density", Config::setDensity, 100);
            Config.parseProperty("firefly-spawn-always", Config::setFireflySpawnAlways, false);
            Config.parseProperty("firefly-spawn-underground", Config::setFireflySpawnUnderground, false);
            Config.parseProperty("firefly-white-alpha", Config::setFireflyWhiteAlpha, 100);
            Config.parseProperty("firefly-rainbow", Config::setFireflyRainbow, false);
            Config.parseProperty("display-cosmetics", Config::setDisplayCosmetics, true);
            Config.parseProperty("debug-mode", Config::setDebugMode, false);
            Config.parseProperty("view-auras-fp", Config::setViewAurasFP, false);
            Config.save();
        } else {
            Config.setHalloweenFeatures(DefaultConfig.HALLOWEEN_FEATURES);
            Config.setEyesInTheDarkSpawnRate(DefaultConfig.EYES_IN_THE_DARK_SPAWN_RATE);
            Config.setWillOWispsSpawnRate(DefaultConfig.WILL_O_WISPS_SPAWN_RATE);
            Config.setFireflySpawnRate(DefaultConfig.FIREFLY_SPAWN_RATE);
            Config.setGlowwormSpawnRate(DefaultConfig.GLOWWORM_SPAWN_RATE);
            Config.setPlanktonSpawnRate(DefaultConfig.PLANKTON_SPAWN_RATE);
            Config.setChorusPetalsSpawnMultiplier(1);
            Config.setDensity(100);
            Config.setFireflySpawnAlways(false);
            Config.setFireflySpawnUnderground(false);
            Config.setFireflyWhiteAlpha(100);
            Config.setDisplayCosmetics(true);
            Config.setViewAurasFP(false);
            Config.save();
        }
    }

    private static <T extends Enum<T>> void parseProperty(String property, Consumer<T> setter, T defaultValue) {
        try {
            setter.accept(Enum.valueOf(defaultValue.getDeclaringClass(), config.getProperty(property)));
        }
        catch (Exception var4) {
            setter.accept(defaultValue);
        }
    }

    private static void parseProperty(String property, Consumer<Boolean> setter, Boolean defaultValue) {
        try {
            setter.accept(Boolean.parseBoolean(config.getProperty(property)));
        }
        catch (Exception var4) {
            setter.accept(defaultValue);
        }
    }

    private static void parseProperty(String property, Consumer<Integer> setter, Integer defaultValue) {
        try {
            setter.accept(Integer.parseInt(config.getProperty(property)));
        }
        catch (Exception var4) {
            setter.accept(defaultValue);
        }
    }

    public static void save() {
        try {
            config.store(Files.newBufferedWriter(PROPERTIES_PATH, new OpenOption[0]), null);
        }
        catch (IOException var1) {
            var1.printStackTrace();
        }
    }

    public static HalloweenFeatures getHalloweenFeatures() {
        return halloweenFeatures;
    }

    public static void setHalloweenFeatures(HalloweenFeatures value) {
        halloweenFeatures = value;
        config.setProperty("halloween-features", value.toString());
    }

    public static EyesInTheDarkSpawnRate getEyesInTheDarkSpawnRate() {
        return eyesInTheDarkSpawnRate;
    }

    public static void setEyesInTheDarkSpawnRate(EyesInTheDarkSpawnRate value) {
        eyesInTheDarkSpawnRate = value;
        config.setProperty("eyes-in-the-dark-spawn-rate", value.name());
    }

    public static WillOWispsSpawnRate getWillOWispsSpawnRate() {
        return willOWispsSpawnRate;
    }

    public static void setWillOWispsSpawnRate(WillOWispsSpawnRate value) {
        willOWispsSpawnRate = value;
        config.setProperty("will-o-wisps-spawn-rate", value.name());
    }

    public static FireflySpawnRate getFireflySpawnRate() {
        return fireflySpawnRate;
    }

    public static void setFireflySpawnRate(FireflySpawnRate value) {
        fireflySpawnRate = value;
        config.setProperty("fireflies-spawn-rate", value.name());
    }

    public static GlowwormSpawnRate getGlowwormSpawnRate() {
        return glowwormSpawnRate;
    }

    public static void setGlowwormSpawnRate(GlowwormSpawnRate value) {
        glowwormSpawnRate = value;
        config.setProperty("glowworms-spawn-rate", value.name());
    }

    public static PlanktonSpawnRate getPlanktonSpawnRate() {
        return planktonSpawnRate;
    }

    public static void setPlanktonSpawnRate(PlanktonSpawnRate value) {
        planktonSpawnRate = value;
        config.setProperty("planktons-spawn-rate", value.name());
    }

    public static int getChorusPetalsSpawnMultiplier() {
        return chorusPetalsSpawnMultiplier;
    }

    public static void setChorusPetalsSpawnMultiplier(int value) {
        chorusPetalsSpawnMultiplier = value;
        config.setProperty("chorus-petal-spawn-multiplier", Integer.toString(value));
    }

    public static int getDensity() {
        return density;
    }

    public static void setDensity(int value) {
        density = value;
        config.setProperty("density", Integer.toString(value));
    }

    public static boolean doesFireflySpawnAlways() {
        return fireflySpawnAlways;
    }

    public static void setFireflySpawnAlways(boolean value) {
        fireflySpawnAlways = value;
        config.setProperty("firefly-spawn-always", Boolean.toString(value));
    }

    public static boolean doesFireflySpawnUnderground() {
        return fireflySpawnUnderground;
    }

    public static void setFireflySpawnUnderground(boolean value) {
        fireflySpawnUnderground = value;
        config.setProperty("firefly-spawn-underground", Boolean.toString(value));
    }

    public static int getFireflyWhiteAlpha() {
        return fireflyWhiteAlpha;
    }

    public static void setFireflyWhiteAlpha(int value) {
        fireflyWhiteAlpha = value;
        config.setProperty("firefly-white-alpha", Integer.toString(value));
    }

    public static boolean getFireflyRainbow() {
        return fireflyRainbow;
    }

    public static void setFireflyRainbow(boolean value) {
        fireflyRainbow = value;
        config.setProperty("firefly-rainbow", Boolean.toString(value));
    }

    public static boolean getViewAurasFP() {
        return viewAurasFP;
    }

    public static void setViewAurasFP(boolean value) {
        viewAurasFP = value;
        config.setProperty("view-auras-fp", Boolean.toString(value));
    }

    public static boolean shouldDisplayCosmetics() {
        return displayCosmetics;
    }

    public static void setDisplayCosmetics(boolean value) {
        displayCosmetics = value;
        config.setProperty("display-cosmetics", Boolean.toString(value));
    }

    public static boolean isDebugMode() {
        return debugMode;
    }

    public static void setDebugMode(boolean value) {
        debugMode = value;
        config.setProperty("debug-mode", Boolean.toString(value));
    }
}

