/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.illuminations.client.config;

import com.google.common.collect.ImmutableMap;
import ladysnake.illuminations.client.data.AuraSettings;
import ladysnake.illuminations.client.enums.EyesInTheDarkSpawnRate;
import ladysnake.illuminations.client.enums.FireflySpawnRate;
import ladysnake.illuminations.client.enums.GlowwormSpawnRate;
import ladysnake.illuminations.client.enums.HalloweenFeatures;
import ladysnake.illuminations.client.enums.PlanktonSpawnRate;
import ladysnake.illuminations.client.enums.WillOWispsSpawnRate;

public final class DefaultConfig {
    public static HalloweenFeatures HALLOWEEN_FEATURES;
    public static EyesInTheDarkSpawnRate EYES_IN_THE_DARK_SPAWN_RATE;
    public static WillOWispsSpawnRate WILL_O_WISPS_SPAWN_RATE;
    public static FireflySpawnRate FIREFLY_SPAWN_RATE;
    public static GlowwormSpawnRate GLOWWORM_SPAWN_RATE;
    public static PlanktonSpawnRate PLANKTON_SPAWN_RATE;
    public static final int CHORUS_PETALS_SPAWN_MULTIPLIER = 1;
    public static final int DENSITY = 100;
    public static final boolean FIREFLY_SPAWN_ALWAYS = false;
    public static final boolean FIREFLY_SPAWN_UNDERGROUND = false;
    public static final int FIREFLY_WHITE_ALPHA = 100;
    public static final boolean FIREFLY_RAINBOW = false;
    public static final boolean DISPLAY_COSMETICS = true;
    public static final boolean DEBUG_MODE = false;
    public static final boolean VIEW_AURAS_FP = false;
    public static ImmutableMap<String, AuraSettings> AURA_SETTINGS;

    private DefaultConfig() {
        throw new UnsupportedOperationException();
    }

    public static AuraSettings getAuraSettings(String aura) {
        return (AuraSettings)AURA_SETTINGS.get((Object)aura);
    }

    static {
        AURA_SETTINGS = null;
        HALLOWEEN_FEATURES = HalloweenFeatures.ENABLE;
        EYES_IN_THE_DARK_SPAWN_RATE = EyesInTheDarkSpawnRate.MEDIUM;
        WILL_O_WISPS_SPAWN_RATE = WillOWispsSpawnRate.MEDIUM;
        FIREFLY_SPAWN_RATE = FireflySpawnRate.HIGH;
        GLOWWORM_SPAWN_RATE = GlowwormSpawnRate.HIGH;
        PLANKTON_SPAWN_RATE = PlanktonSpawnRate.MEDIUM;
        AURA_SETTINGS = ImmutableMap.builder().put((Object)"twilight", (Object)new AuraSettings(0.1f, 1)).put((Object)"ghostly", (Object)new AuraSettings(0.1f, 1)).put((Object)"chorus", (Object)new AuraSettings(0.1f, 1)).put((Object)"autumn_leaves", (Object)new AuraSettings(0.3f, 1)).put((Object)"sculk_tendrils", (Object)new AuraSettings(0.1f, 1)).put((Object)"shadowbringer_soul", (Object)new AuraSettings(0.1f, 1)).put((Object)"goldenrod", (Object)new AuraSettings(0.4f, 1)).put((Object)"confetti", (Object)new AuraSettings(0.1f, 1)).put((Object)"prismatic_confetti", (Object)new AuraSettings(0.1f, 1)).put((Object)"prismarine", (Object)new AuraSettings(0.1f, 1)).build();
    }
}

