/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.illuminations.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import ladysnake.illuminations.client.Illuminations;
import ladysnake.illuminations.client.config.Config;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class FireflyParticle
extends TextureSheetParticle {
    protected static final float BLINK_STEP = 0.05f;
    private final SpriteSet spriteProvider;
    private final boolean isAttractedByLight = true;
    protected float nextAlphaGoal = 0.0f;
    protected double xTarget;
    protected double yTarget;
    protected double zTarget;
    protected int targetChangeCooldown = 0;
    protected int maxHeight;
    private BlockPos lightTarget;

    public FireflyParticle(ClientLevel world, double x, double y, double z, double velocityX, double velocityY, double velocityZ, SpriteSet spriteProvider) {
        super(world, x, y, z, velocityX, velocityY, velocityZ);
        Color c;
        this.spriteProvider = spriteProvider;
        this.f_107663_ *= 0.25f + this.f_107223_.m_188501_() * 0.5f;
        this.f_107225_ = ThreadLocalRandom.current().nextInt(400, 1201);
        this.maxHeight = 4;
        this.f_107219_ = true;
        this.m_108339_(spriteProvider);
        this.f_107230_ = 0.0f;
        if (Config.getFireflyRainbow()) {
            c = Color.getHSBColor(this.f_107223_.m_188501_(), 1.0f, 1.0f);
        } else {
            Holder b = world.m_204166_(new BlockPos((int)x, (int)y, (int)z));
            ResourceLocation biome = world.m_9598_().m_175515_(ForgeRegistries.BIOMES.getRegistryKey()).m_7981_((Object)((Biome)b.m_203334_()));
            int rgb = 16636429;
            float[] hsb = Color.RGBtoHSB(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF, null);
            hsb[0] = hsb[0] + (this.f_107223_.m_188501_() - 0.5f) * 30.0f / 360.0f;
            c = Color.getHSBColor(hsb[0], hsb[1], hsb[2]);
        }
        this.f_107227_ = (float)c.getRed() / 255.0f;
        this.f_107228_ = (float)c.getGreen() / 255.0f;
        this.f_107229_ = (float)c.getBlue() / 255.0f;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public void m_5744_(VertexConsumer vertexConsumer, Camera camera, float tickDelta) {
        Quaternionf quaternion2;
        Vec3 vec3d = camera.m_90583_();
        float f = (float)(Mth.m_14139_((double)tickDelta, (double)this.f_107209_, (double)this.f_107212_) - vec3d.m_7096_());
        float g = (float)(Mth.m_14139_((double)tickDelta, (double)this.f_107210_, (double)this.f_107213_) - vec3d.m_7098_());
        float h = (float)(Mth.m_14139_((double)tickDelta, (double)this.f_107211_, (double)this.f_107214_) - vec3d.m_7094_());
        if (this.f_107231_ == 0.0f) {
            quaternion2 = camera.m_253121_();
        } else {
            quaternion2 = new Quaternionf((Quaternionfc)camera.m_253121_());
            float i = Mth.m_14179_((float)tickDelta, (float)this.f_107204_, (float)this.f_107231_);
            quaternion2.mul((Quaternionfc)Axis.f_252403_.m_252961_(i));
        }
        Vector3f Vec3f = new Vector3f(-1.0f, -1.0f, 0.0f);
        Vec3f.rotate((Quaternionfc)quaternion2);
        Vector3f[] Vec3fs = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float j = this.m_5902_(tickDelta);
        for (int k = 0; k < 4; ++k) {
            Vector3f Vec3f2 = Vec3fs[k];
            Vec3f2.rotate((Quaternionfc)quaternion2);
            Vec3f2.mul(j);
            Vec3f2.add(f, g, h);
        }
        float minU = this.m_5970_();
        float maxU = this.m_5952_();
        float minV = this.m_5951_();
        float maxV = this.m_5950_();
        int l = 0xF000F0;
        float a = Math.min(1.0f, Math.max(0.0f, this.f_107230_));
        vertexConsumer.m_5483_((double)Vec3fs[0].x(), (double)Vec3fs[0].y(), (double)Vec3fs[0].z()).m_7421_(maxU, minV + (maxV - minV) / 2.0f).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, a).m_85969_(l).m_5752_();
        vertexConsumer.m_5483_((double)Vec3fs[1].x(), (double)Vec3fs[1].y(), (double)Vec3fs[1].z()).m_7421_(maxU, minV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, a).m_85969_(l).m_5752_();
        vertexConsumer.m_5483_((double)Vec3fs[2].x(), (double)Vec3fs[2].y(), (double)Vec3fs[2].z()).m_7421_(minU, minV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, a).m_85969_(l).m_5752_();
        vertexConsumer.m_5483_((double)Vec3fs[3].x(), (double)Vec3fs[3].y(), (double)Vec3fs[3].z()).m_7421_(minU, minV + (maxV - minV) / 2.0f).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, a).m_85969_(l).m_5752_();
        vertexConsumer.m_5483_((double)Vec3fs[0].x(), (double)Vec3fs[0].y(), (double)Vec3fs[0].z()).m_7421_(maxU, maxV).m_85950_(1.0f, 1.0f, 1.0f, a * (float)Config.getFireflyWhiteAlpha() / 100.0f).m_85969_(l).m_5752_();
        vertexConsumer.m_5483_((double)Vec3fs[1].x(), (double)Vec3fs[1].y(), (double)Vec3fs[1].z()).m_7421_(maxU, minV + (maxV - minV) / 2.0f).m_85950_(1.0f, 1.0f, 1.0f, a * (float)Config.getFireflyWhiteAlpha() / 100.0f).m_85969_(l).m_5752_();
        vertexConsumer.m_5483_((double)Vec3fs[2].x(), (double)Vec3fs[2].y(), (double)Vec3fs[2].z()).m_7421_(minU, minV + (maxV - minV) / 2.0f).m_85950_(1.0f, 1.0f, 1.0f, a * (float)Config.getFireflyWhiteAlpha() / 100.0f).m_85969_(l).m_5752_();
        vertexConsumer.m_5483_((double)Vec3fs[3].x(), (double)Vec3fs[3].y(), (double)Vec3fs[3].z()).m_7421_(minU, maxV).m_85950_(1.0f, 1.0f, 1.0f, a * (float)Config.getFireflyWhiteAlpha() / 100.0f).m_85969_(l).m_5752_();
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (!Config.doesFireflySpawnAlways() && !this.f_107208_.m_6042_().m_63967_() && !Illuminations.isNightTime((Level)this.f_107208_) || this.f_107224_++ >= this.f_107225_) {
            this.nextAlphaGoal = 0.0f;
            if (this.f_107230_ <= 0.01f) {
                this.m_107274_();
            }
        }
        if (this.f_107230_ > this.nextAlphaGoal - 0.05f && this.f_107230_ < this.nextAlphaGoal + 0.05f) {
            this.nextAlphaGoal = this.f_107223_.m_188501_();
        } else if (this.nextAlphaGoal > this.f_107230_) {
            this.f_107230_ = Math.min(this.f_107230_ + 0.05f, 1.0f);
        } else if (this.nextAlphaGoal < this.f_107230_) {
            this.f_107230_ = Math.max(this.f_107230_ - 0.05f, 0.0f);
        }
        this.targetChangeCooldown -= new Vec3(this.f_107212_, this.f_107213_, this.f_107214_).m_82531_(this.f_107209_, this.f_107210_, this.f_107211_) < 0.0125 ? 10 : 1;
        if (this.f_107208_.m_46467_() % 20L == 0L && (this.xTarget == 0.0 && this.yTarget == 0.0 && this.zTarget == 0.0 || new Vec3(this.f_107212_, this.f_107213_, this.f_107214_).m_82531_(this.xTarget, this.yTarget, this.zTarget) < 9.0 || this.targetChangeCooldown <= 0)) {
            this.selectBlockTarget();
        }
        Vec3 targetVector = new Vec3(this.xTarget - this.f_107212_, this.yTarget - this.f_107213_, this.zTarget - this.f_107214_);
        double length = targetVector.m_82553_();
        targetVector = targetVector.m_82490_(0.1 / length);
        if (!this.f_107208_.m_8055_(new BlockPos((int)this.f_107212_, (int)(this.f_107213_ - 0.1), (int)this.f_107214_)).m_60734_().m_48673_(this.f_107208_.m_8055_(new BlockPos((int)this.f_107212_, (int)(this.f_107213_ - 0.1), (int)this.f_107214_)))) {
            this.f_107215_ = 0.9 * this.f_107215_ + 0.1 * targetVector.f_82479_;
            this.f_107216_ = 0.05;
            this.f_107217_ = 0.9 * this.f_107217_ + 0.1 * targetVector.f_82481_;
        } else {
            this.f_107215_ = 0.9 * this.f_107215_ + 0.1 * targetVector.f_82479_;
            this.f_107216_ = 0.9 * this.f_107216_ + 0.1 * targetVector.f_82480_;
            this.f_107217_ = 0.9 * this.f_107217_ + 0.1 * targetVector.f_82481_;
        }
        if (!new BlockPos((int)this.f_107212_, (int)this.f_107213_, (int)this.f_107214_).equals((Object)this.getTargetPosition())) {
            this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
        }
    }

    private void selectBlockTarget() {
        if (this.lightTarget == null) {
            double groundLevel = 0.0;
            for (int i = 0; i < 20; ++i) {
                BlockState checkedBlock = this.f_107208_.m_8055_(new BlockPos((int)this.f_107212_, (int)(this.f_107213_ - (double)i), (int)this.f_107214_));
                if (!checkedBlock.m_60734_().m_48673_(checkedBlock)) {
                    groundLevel = this.f_107213_ - (double)i;
                }
                if (groundLevel != 0.0) break;
            }
            this.xTarget = this.f_107212_ + this.f_107223_.m_188583_() * 10.0;
            this.yTarget = Math.min(Math.max(this.f_107213_ + this.f_107223_.m_188583_() * 2.0, groundLevel), groundLevel + (double)this.maxHeight);
            this.zTarget = this.f_107214_ + this.f_107223_.m_188583_() * 10.0;
            BlockPos targetPos = new BlockPos((int)this.xTarget, (int)this.yTarget, (int)this.zTarget);
            if (this.f_107208_.m_8055_(targetPos).m_60838_((BlockGetter)this.f_107208_, targetPos) && this.f_107208_.m_8055_(targetPos).m_60796_((BlockGetter)this.f_107208_, targetPos)) {
                this.yTarget += 1.0;
            }
            Objects.requireNonNull(this);
            this.lightTarget = this.getMostLitBlockAround();
        } else {
            this.xTarget = (double)this.lightTarget.m_123341_() + this.f_107223_.m_188583_();
            this.yTarget = (double)this.lightTarget.m_123342_() + this.f_107223_.m_188583_();
            this.zTarget = (double)this.lightTarget.m_123343_() + this.f_107223_.m_188583_();
            this.f_107212_ = this.lightTarget.m_123341_();
            this.f_107213_ = this.lightTarget.m_123342_() + 1;
            this.f_107214_ = this.lightTarget.m_123343_();
            this.lightTarget = this.f_107208_.m_45517_(LightLayer.BLOCK, new BlockPos((int)this.f_107212_, (int)this.f_107213_, (int)this.f_107214_)) > 0 && !this.f_107208_.m_46461_() ? this.getMostLitBlockAround() : null;
        }
        this.targetChangeCooldown = this.f_107223_.m_188502_() % 100;
    }

    public BlockPos getTargetPosition() {
        return new BlockPos((int)this.xTarget, (int)(this.yTarget + 0.5), (int)this.zTarget);
    }

    private BlockPos getMostLitBlockAround() {
        int x;
        HashMap<BlockPos, Integer> randBlocks = new HashMap<BlockPos, Integer>();
        for (x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos bp = new BlockPos((int)(this.f_107212_ + (double)x), (int)(this.f_107213_ + (double)y), (int)(this.f_107214_ + (double)z));
                    randBlocks.put(bp, this.f_107208_.m_45517_(LightLayer.BLOCK, bp));
                }
            }
        }
        for (x = 0; x < 15; ++x) {
            BlockPos randBP = new BlockPos((int)(this.f_107212_ + this.f_107223_.m_188583_() * 10.0), (int)(this.f_107213_ + this.f_107223_.m_188583_() * 10.0), (int)(this.f_107214_ + this.f_107223_.m_188583_() * 10.0));
            randBlocks.put(randBP, this.f_107208_.m_45517_(LightLayer.BLOCK, randBP));
        }
        return (BlockPos)((Map.Entry)randBlocks.entrySet().stream().max((entry1, entry2) -> (Integer)entry1.getValue() > (Integer)entry2.getValue() ? 1 : -1).get()).getKey();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class DefaultFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;

        public DefaultFactory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(SimpleParticleType defaultParticleType, ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            return new FireflyParticle(clientWorld, d, e, f, g, h, i, this.spriteProvider);
        }
    }
}

