/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.illuminations.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class PrismarineCrystalParticle
extends TextureSheetParticle {
    private static final Random RANDOM = new Random();
    protected final float rotationFactor;
    private final int variant = RANDOM.nextInt(3);
    private final SpriteSet spriteProvider;
    private final float groundOffset;

    public PrismarineCrystalParticle(ClientLevel world, double x, double y, double z, double velocityX, double velocityY, double velocityZ, SpriteSet spriteProvider) {
        super(world, x, y, z, velocityX, velocityY, velocityZ);
        this.spriteProvider = spriteProvider;
        this.f_107663_ *= 1.0f + RANDOM.nextFloat();
        this.f_107225_ = ThreadLocalRandom.current().nextInt(400, 1201);
        this.f_107219_ = true;
        this.m_108337_(spriteProvider.m_5819_(this.variant, 2));
        if (velocityY == 0.0 && velocityX == 0.0 && velocityZ == 0.0) {
            this.f_107230_ = 0.0f;
        }
        this.f_107215_ = (double)this.f_107223_.m_188501_() * 0.01;
        this.f_107216_ = (double)(-this.f_107223_.m_188501_()) * 0.01;
        this.f_107217_ = (double)this.f_107223_.m_188501_() * 0.01;
        this.groundOffset = RANDOM.nextFloat() / 100.0f + 0.001f;
        this.rotationFactor = ((float)Math.random() - 0.5f) * 0.01f;
        this.f_107231_ = this.f_107223_.m_188501_() * 360.0f;
    }

    public void m_5744_(VertexConsumer vertexConsumer, Camera camera, float tickDelta) {
        Quaternionf quaternion2;
        Vec3 vec3d = camera.m_90583_();
        float f = (float)(Mth.m_14139_((double)tickDelta, (double)this.f_107209_, (double)this.f_107212_) - vec3d.m_7096_());
        float g = (float)(Mth.m_14139_((double)tickDelta, (double)this.f_107210_, (double)this.f_107213_) - vec3d.m_7098_());
        float h = (float)(Mth.m_14139_((double)tickDelta, (double)this.f_107211_, (double)this.f_107214_) - vec3d.m_7094_());
        if (this.f_107231_ == 0.0f) {
            quaternion2 = camera.m_253121_();
        } else {
            quaternion2 = new Quaternionf((Quaternionfc)camera.m_253121_());
            float i = Mth.m_14179_((float)tickDelta, (float)this.f_107204_, (float)this.f_107231_);
            quaternion2.mul((Quaternionfc)Axis.f_252403_.m_252977_(i));
        }
        Vector3f Vec3f = new Vector3f(-1.0f, -1.0f, 0.0f);
        Vec3f.rotate((Quaternionfc)quaternion2);
        Vector3f[] Vec3fs = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float j = this.m_5902_(tickDelta);
        for (int k = 0; k < 4; ++k) {
            Vector3f Vec3f2 = Vec3fs[k];
            if (this.f_107218_) {
                Vec3f2.rotate((Quaternionfc)new Quaternionf(90.0f, 0.0f, quaternion2.z(), quaternion2.w));
            } else {
                Vec3f2.rotate((Quaternionfc)quaternion2);
            }
            Vec3f2.mul(j);
            Vec3f2.add(f, g + this.groundOffset, h);
        }
        float minU = this.m_5970_();
        float maxU = this.m_5952_();
        float minV = this.m_5951_();
        float maxV = this.m_5950_();
        int l = 0xF000F0;
        vertexConsumer.m_5483_((double)Vec3fs[0].x(), (double)Vec3fs[0].y(), (double)Vec3fs[0].z()).m_7421_(maxU, maxV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(l).m_5752_();
        vertexConsumer.m_5483_((double)Vec3fs[1].x(), (double)Vec3fs[1].y(), (double)Vec3fs[1].z()).m_7421_(maxU, minV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(l).m_5752_();
        vertexConsumer.m_5483_((double)Vec3fs[2].x(), (double)Vec3fs[2].y(), (double)Vec3fs[2].z()).m_7421_(minU, minV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(l).m_5752_();
        vertexConsumer.m_5483_((double)Vec3fs[3].x(), (double)Vec3fs[3].y(), (double)Vec3fs[3].z()).m_7421_(minU, maxV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(l).m_5752_();
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public void m_5989_() {
        if (this.f_107224_++ < this.f_107225_) {
            this.f_107230_ = Math.min(1.0f, this.f_107230_ + 0.01f);
        }
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.f_107208_.m_6425_(new BlockPos((int)this.f_107212_, (int)this.f_107213_, (int)this.f_107214_)).m_205070_(FluidTags.f_13131_)) {
            this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
        } else {
            this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
            this.f_107215_ *= 0.9;
            this.f_107216_ = -0.9;
            this.f_107217_ *= 0.9;
        }
        if (this.f_107224_ >= this.f_107225_) {
            this.f_107230_ = Math.max(0.0f, this.f_107230_ - 0.01f);
            if (this.f_107230_ <= 0.0f) {
                this.m_107274_();
            }
        }
        this.f_107227_ = 0.8f + (float)Math.sin((float)this.f_107224_ / 100.0f) * 0.2f;
        this.f_107204_ = this.f_107231_;
        if (this.f_107218_) {
            this.f_107215_ = 0.0;
            this.f_107216_ = 0.0;
            this.f_107217_ = 0.0;
        }
        if (this.f_107216_ != 0.0) {
            this.f_107231_ = (float)((double)this.f_107231_ + Math.PI * Math.sin(this.rotationFactor * (float)this.f_107224_) / 2.0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class DefaultFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;

        public DefaultFactory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(SimpleParticleType defaultParticleType, ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            return new PrismarineCrystalParticle(clientWorld, d, e, f, g, h, i, this.spriteProvider);
        }
    }
}

