/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.illuminations.client.particle;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import ladysnake.illuminations.client.particle.WispTrailParticleEffect;
import ladysnake.illuminations.client.render.GlowyRenderLayer;
import ladysnake.illuminations.client.render.entity.model.pet.WillOWispModel;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class WillOWispParticle
extends Particle {
    public final ResourceLocation texture;
    protected final float redEvolution;
    protected final float greenEvolution;
    protected final float blueEvolution;
    final Model model;
    final RenderType layer;
    public float yaw;
    public float pitch;
    public float prevYaw;
    public float prevPitch;
    public float speedModifier;
    protected double xTarget;
    protected double yTarget;
    protected double zTarget;
    protected int targetChangeCooldown = 0;
    protected int timeInSolid = -1;

    protected WillOWispParticle(ClientLevel world, double x, double y, double z, ResourceLocation texture, float red, float green, float blue, float redEvolution, float greenEvolution, float blueEvolution) {
        super(world, x, y, z);
        this.texture = texture;
        this.model = new WillOWispModel(Minecraft.m_91087_().m_167973_().m_171103_(WillOWispModel.MODEL_LAYER));
        this.layer = RenderType.m_110473_((ResourceLocation)texture);
        this.f_107226_ = 0.0f;
        this.f_107225_ = 600 + this.f_107223_.m_188503_(600);
        this.speedModifier = 0.1f + Math.max(0.0f, this.f_107223_.m_188501_() - 0.1f);
        this.f_107227_ = red;
        this.f_107228_ = green;
        this.f_107229_ = blue;
        this.redEvolution = redEvolution;
        this.blueEvolution = blueEvolution;
        this.greenEvolution = greenEvolution;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107433_;
    }

    public void m_5744_(VertexConsumer vertexConsumer, Camera camera, float tickDelta) {
        Vec3 vec3d = camera.m_90583_();
        float f = (float)(Mth.m_14139_((double)tickDelta, (double)this.f_107209_, (double)this.f_107212_) - vec3d.m_7096_());
        float g = (float)(Mth.m_14139_((double)tickDelta, (double)this.f_107210_, (double)this.f_107213_) - vec3d.m_7098_());
        float h = (float)(Mth.m_14139_((double)tickDelta, (double)this.f_107211_, (double)this.f_107214_) - vec3d.m_7094_());
        PoseStack matrixStack = new PoseStack();
        matrixStack.m_85837_((double)f, (double)g, (double)h);
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(Mth.m_14179_((float)g, (float)this.prevYaw, (float)this.yaw) - 180.0f));
        matrixStack.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14179_((float)g, (float)this.prevPitch, (float)this.pitch)));
        matrixStack.m_85841_(0.5f, -0.5f, 0.5f);
        matrixStack.m_85837_(0.0, -1.0, 0.0);
        MultiBufferSource.BufferSource immediate = Minecraft.m_91087_().m_91269_().m_110104_();
        VertexConsumer vertexConsumer2 = immediate.m_6299_(GlowyRenderLayer.get(this.texture));
        if (this.f_107230_ > 0.0f) {
            this.model.m_7695_(matrixStack, vertexConsumer2, 0xF000F0, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        immediate.m_109911_();
    }

    public void m_5989_() {
        BlockPos pos;
        if (this.f_107209_ == this.f_107212_ && this.f_107210_ == this.f_107213_ && this.f_107211_ == this.f_107214_) {
            this.selectBlockTarget();
        }
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.f_107224_++ >= this.f_107225_) {
            for (int i = 0; i < 25; ++i) {
                this.f_107208_.m_7106_((ParticleOptions)new WispTrailParticleEffect(this.f_107227_, this.f_107228_, this.f_107229_, this.redEvolution, this.greenEvolution, this.blueEvolution), this.f_107212_ + this.f_107223_.m_188583_() / 15.0, this.f_107213_ + this.f_107223_.m_188583_() / 15.0, this.f_107214_ + this.f_107223_.m_188583_() / 15.0, 0.0, 0.0, 0.0);
                this.f_107208_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50135_.m_49966_()), this.f_107212_ + this.f_107223_.m_188583_() / 10.0, this.f_107213_ + this.f_107223_.m_188583_() / 10.0, this.f_107214_ + this.f_107223_.m_188583_() / 10.0, this.f_107223_.m_188583_() / 20.0, this.f_107223_.m_188583_() / 20.0, this.f_107223_.m_188583_() / 20.0);
            }
            this.f_107208_.m_245747_(new BlockPos((int)this.f_107212_, (int)this.f_107213_, (int)this.f_107214_), SoundEvents.f_12404_, SoundSource.AMBIENT, 1.0f, 1.5f, true);
            this.f_107208_.m_245747_(new BlockPos((int)this.f_107212_, (int)this.f_107213_, (int)this.f_107214_), SoundEvents.f_12394_, SoundSource.AMBIENT, 1.0f, 1.0f, true);
            this.m_107274_();
        }
        this.targetChangeCooldown -= new Vec3(this.f_107212_, this.f_107213_, this.f_107214_).m_82531_(this.f_107209_, this.f_107210_, this.f_107211_) < 0.0125 ? 10 : 1;
        if (this.f_107208_.m_46467_() % 20L == 0L && (this.xTarget == 0.0 && this.yTarget == 0.0 && this.zTarget == 0.0 || new Vec3(this.f_107212_, this.f_107213_, this.f_107214_).m_82531_(this.xTarget, this.yTarget, this.zTarget) < 9.0 || this.targetChangeCooldown <= 0)) {
            this.selectBlockTarget();
        }
        Vec3 targetVector = new Vec3(this.xTarget - this.f_107212_, this.yTarget - this.f_107213_, this.zTarget - this.f_107214_);
        double length = targetVector.m_82553_();
        targetVector = targetVector.m_82490_((double)this.speedModifier / length);
        this.f_107215_ = 0.9 * this.f_107215_ + 0.1 * targetVector.f_82479_;
        this.f_107216_ = 0.9 * this.f_107216_ + 0.1 * targetVector.f_82480_;
        this.f_107217_ = 0.9 * this.f_107217_ + 0.1 * targetVector.f_82481_;
        this.prevYaw = this.yaw;
        this.prevPitch = this.pitch;
        Vec3 vec3d = new Vec3(this.f_107215_, this.f_107216_, this.f_107217_);
        float f = (float)Math.sqrt(vec3d.f_82479_ * vec3d.f_82479_ + vec3d.f_82481_ * vec3d.f_82481_);
        this.yaw = (float)(Mth.m_14136_((double)vec3d.f_82479_, (double)vec3d.f_82481_) * 57.2957763671875);
        this.pitch = (float)(Mth.m_14136_((double)vec3d.f_82480_, (double)f) * 57.2957763671875);
        int i = 0;
        while ((float)i < 10.0f * this.speedModifier) {
            if (this.f_107208_.m_8055_(new BlockPos((int)this.f_107212_, (int)this.f_107213_, (int)this.f_107214_)).m_204336_(BlockTags.f_13085_)) {
                this.f_107208_.m_7106_((ParticleOptions)ParticleTypes.f_123746_, this.f_107212_ + this.f_107223_.m_188583_() / 10.0, this.f_107213_ + this.f_107223_.m_188583_() / 10.0, this.f_107214_ + this.f_107223_.m_188583_() / 10.0, this.f_107223_.m_188583_() / 20.0, this.f_107223_.m_188583_() / 20.0, this.f_107223_.m_188583_() / 20.0);
            } else {
                this.f_107208_.m_7106_((ParticleOptions)new WispTrailParticleEffect(this.f_107227_, this.f_107228_, this.f_107229_, this.redEvolution, this.greenEvolution, this.blueEvolution), this.f_107212_ + this.f_107223_.m_188583_() / 15.0, this.f_107213_ + this.f_107223_.m_188583_() / 15.0, this.f_107214_ + this.f_107223_.m_188583_() / 15.0, 0.0, 0.0, 0.0);
            }
            ++i;
        }
        if (!new BlockPos((int)this.f_107212_, (int)this.f_107213_, (int)this.f_107214_).equals((Object)this.getTargetPosition())) {
            this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
        }
        if (this.f_107223_.m_188503_(20) == 0) {
            this.f_107208_.m_245747_(new BlockPos((int)this.f_107212_, (int)this.f_107213_, (int)this.f_107214_), SoundEvents.f_12404_, SoundSource.AMBIENT, 1.0f, 1.5f, true);
        }
        if (!this.f_107208_.m_8055_(pos = new BlockPos((int)this.f_107212_, (int)this.f_107213_, (int)this.f_107214_)).m_60795_()) {
            if (this.timeInSolid > -1) {
                ++this.timeInSolid;
            }
        } else {
            this.timeInSolid = 0;
        }
        if (this.timeInSolid > 25) {
            this.m_107274_();
        }
    }

    public void m_6257_(double dx, double dy, double dz) {
        double d = dx;
        double e = dy;
        if (this.f_107219_ && !this.f_107208_.m_8055_(new BlockPos((int)(this.f_107212_ + dx), (int)(this.f_107213_ + dy), (int)(this.f_107214_ + dz))).m_204336_(BlockTags.f_13085_) && (dx != 0.0 || dy != 0.0 || dz != 0.0)) {
            Vec3 vec3d = Entity.m_198894_((Entity)null, (Vec3)new Vec3(dx, dy, dz), (AABB)this.m_107277_(), (Level)this.f_107208_, List.of());
            dx = vec3d.f_82479_;
            dy = vec3d.f_82480_;
            dz = vec3d.f_82481_;
        }
        if (dx != 0.0 || dy != 0.0 || dz != 0.0) {
            this.m_107259_(this.m_107277_().m_82386_(dx, dy, dz));
            this.m_107275_();
        }
        boolean bl = this.f_107218_ = dy != dy && e < 0.0 && !this.f_107208_.m_8055_(new BlockPos((int)this.f_107212_, (int)this.f_107213_, (int)this.f_107214_)).m_204336_(BlockTags.f_13085_);
        if (d != dx) {
            this.f_107215_ = 0.0;
        }
        if (dz != dz) {
            this.f_107217_ = 0.0;
        }
    }

    public BlockPos getTargetPosition() {
        return new BlockPos((int)this.xTarget, (int)(this.yTarget + 0.5), (int)this.zTarget);
    }

    private void selectBlockTarget() {
        this.xTarget = this.f_107212_ + this.f_107223_.m_188583_() * 10.0;
        this.yTarget = this.f_107213_ + this.f_107223_.m_188583_() * 10.0;
        this.zTarget = this.f_107214_ + this.f_107223_.m_188583_() * 10.0;
        BlockPos targetPos = new BlockPos((int)this.xTarget, (int)this.yTarget, (int)this.zTarget);
        if (this.f_107208_.m_8055_(targetPos).m_60838_((BlockGetter)this.f_107208_, targetPos) && !this.f_107208_.m_8055_(targetPos).m_204336_(BlockTags.f_13085_)) {
            this.targetChangeCooldown = 0;
        } else {
            this.speedModifier = 0.1f + Math.max(0.0f, this.f_107223_.m_188501_() - 0.1f);
            this.targetChangeCooldown = this.f_107223_.m_188502_() % (int)(100.0f / this.speedModifier);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class DefaultFactory
    implements ParticleProvider<SimpleParticleType> {
        private final ResourceLocation texture;
        private final float red;
        private final float green;
        private final float blue;
        private final float redEvolution;
        private final float greenEvolution;
        private final float blueEvolution;

        public DefaultFactory(Object spriteProvider, ResourceLocation texture, float red, float green, float blue, float redEvolution, float greenEvolution, float blueEvolution) {
            this.texture = texture;
            this.red = red;
            this.green = green;
            this.blue = blue;
            this.redEvolution = redEvolution;
            this.greenEvolution = greenEvolution;
            this.blueEvolution = blueEvolution;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType parameters, ClientLevel world, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            return new WillOWispParticle(world, x, y, z, this.texture, this.red, this.green, this.blue, this.redEvolution, this.greenEvolution, this.blueEvolution);
        }
    }
}

