/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.illuminations.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Random;
import ladysnake.illuminations.client.particle.WispTrailParticleEffect;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class WispTrailParticle
extends TextureSheetParticle {
    private final SpriteSet spriteProvider;
    private final float redEvolution;
    private final float greenEvolution;
    private final float blueEvolution;

    private WispTrailParticle(ClientLevel world, double x, double y, double z, double velocityX, double velocityY, double velocityZ, WispTrailParticleEffect wispTrailParticleEffect, SpriteSet spriteProvider) {
        super(world, x, y, z, velocityX, velocityY, velocityZ);
        this.spriteProvider = spriteProvider;
        this.f_107227_ = wispTrailParticleEffect.getRed();
        this.f_107228_ = wispTrailParticleEffect.getGreen();
        this.f_107229_ = wispTrailParticleEffect.getBlue();
        this.redEvolution = wispTrailParticleEffect.getRedEvolution();
        this.greenEvolution = wispTrailParticleEffect.getGreenEvolution();
        this.blueEvolution = wispTrailParticleEffect.getBlueEvolution();
        this.f_107225_ = 10 + this.f_107223_.m_188503_(10);
        this.f_107663_ *= 0.25f + new Random().nextFloat() * 0.5f;
        this.m_108339_(spriteProvider);
        this.f_107216_ = 0.1;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.f_107224_++ >= this.f_107225_) {
            this.f_107230_ -= 0.05f;
        }
        if (this.f_107230_ < 0.0f || this.f_107663_ <= 0.0f) {
            this.m_107274_();
        }
        this.f_107227_ = Mth.m_14036_((float)(this.f_107227_ + this.redEvolution), (float)0.0f, (float)1.0f);
        this.f_107228_ = Mth.m_14036_((float)(this.f_107228_ + this.greenEvolution), (float)0.0f, (float)1.0f);
        this.f_107229_ = Mth.m_14036_((float)(this.f_107229_ + this.blueEvolution), (float)0.0f, (float)1.0f);
        this.f_107216_ -= 0.001;
        this.f_107215_ = 0.0;
        this.f_107217_ = 0.0;
        this.f_107663_ = Math.max(0.0f, this.f_107663_ - 0.005f);
        this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
    }

    public void m_5744_(VertexConsumer vertexConsumer, Camera camera, float tickDelta) {
        Quaternionf quaternion2;
        Vec3 vec3d = camera.m_90583_();
        float f = (float)(Mth.m_14139_((double)tickDelta, (double)this.f_107209_, (double)this.f_107212_) - vec3d.m_7096_());
        float g = (float)(Mth.m_14139_((double)tickDelta, (double)this.f_107210_, (double)this.f_107213_) - vec3d.m_7098_());
        float h = (float)(Mth.m_14139_((double)tickDelta, (double)this.f_107211_, (double)this.f_107214_) - vec3d.m_7094_());
        if (this.f_107231_ == 0.0f) {
            quaternion2 = camera.m_253121_();
        } else {
            quaternion2 = new Quaternionf((Quaternionfc)camera.m_253121_());
            float i = Mth.m_14179_((float)tickDelta, (float)this.f_107204_, (float)this.f_107231_);
            quaternion2.mul((Quaternionfc)Axis.f_252403_.m_252961_(i));
        }
        Vector3f Vec3f = new Vector3f(-1.0f, -1.0f, 0.0f);
        Vec3f.rotate((Quaternionfc)quaternion2);
        Vector3f[] Vec3fs = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float j = this.m_5902_(tickDelta);
        for (int k = 0; k < 4; ++k) {
            Vector3f Vec3f2 = Vec3fs[k];
            Vec3f2.rotate((Quaternionfc)quaternion2);
            Vec3f2.mul(j);
            Vec3f2.add(f, g, h);
        }
        float minU = this.m_5970_();
        float maxU = this.m_5952_();
        float minV = this.m_5951_();
        float maxV = this.m_5950_();
        int l = 0xF000F0;
        vertexConsumer.m_5483_((double)Vec3fs[0].x(), (double)Vec3fs[0].y(), (double)Vec3fs[0].z()).m_7421_(maxU, maxV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(l).m_5752_();
        vertexConsumer.m_5483_((double)Vec3fs[1].x(), (double)Vec3fs[1].y(), (double)Vec3fs[1].z()).m_7421_(maxU, minV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(l).m_5752_();
        vertexConsumer.m_5483_((double)Vec3fs[2].x(), (double)Vec3fs[2].y(), (double)Vec3fs[2].z()).m_7421_(minU, minV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(l).m_5752_();
        vertexConsumer.m_5483_((double)Vec3fs[3].x(), (double)Vec3fs[3].y(), (double)Vec3fs[3].z()).m_7421_(minU, maxV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(l).m_5752_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<WispTrailParticleEffect> {
        private final SpriteSet spriteProvider;

        public Factory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(WispTrailParticleEffect wispTrailParticleEffect, ClientLevel clientWorld, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            return new WispTrailParticle(clientWorld, x, y, z, velocityX, velocityY, velocityZ, wispTrailParticleEffect, this.spriteProvider);
        }
    }
}

