/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.illuminations.client.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import ladysnake.illuminations.client.Illuminations;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class WispTrailParticleEffect
implements ParticleOptions {
    public static final Codec<WispTrailParticleEffect> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("r").forGetter(wispTrailParticleEffect -> Float.valueOf(wispTrailParticleEffect.red)), (App)Codec.FLOAT.fieldOf("g").forGetter(wispTrailParticleEffect -> Float.valueOf(wispTrailParticleEffect.green)), (App)Codec.FLOAT.fieldOf("b").forGetter(wispTrailParticleEffect -> Float.valueOf(wispTrailParticleEffect.blue)), (App)Codec.FLOAT.fieldOf("re").forGetter(wispTrailParticleEffect -> Float.valueOf(wispTrailParticleEffect.redEvolution)), (App)Codec.FLOAT.fieldOf("ge").forGetter(wispTrailParticleEffect -> Float.valueOf(wispTrailParticleEffect.greenEvolution)), (App)Codec.FLOAT.fieldOf("be").forGetter(wispTrailParticleEffect -> Float.valueOf(wispTrailParticleEffect.blueEvolution))).apply((Applicative)instance, WispTrailParticleEffect::new));
    public static final ParticleOptions.Deserializer<WispTrailParticleEffect> PARAMETERS_FACTORY = new ParticleOptions.Deserializer<WispTrailParticleEffect>(){

        public WispTrailParticleEffect fromCommand(ParticleType<WispTrailParticleEffect> particleType, StringReader stringReader) throws CommandSyntaxException {
            stringReader.expect(' ');
            float r = (float)stringReader.readDouble();
            stringReader.expect(' ');
            float g = (float)stringReader.readDouble();
            stringReader.expect(' ');
            float b = (float)stringReader.readDouble();
            stringReader.expect(' ');
            float re = (float)stringReader.readDouble();
            stringReader.expect(' ');
            float ge = (float)stringReader.readDouble();
            stringReader.expect(' ');
            float be = (float)stringReader.readDouble();
            return new WispTrailParticleEffect(r, g, b, re, ge, be);
        }

        public WispTrailParticleEffect fromNetwork(ParticleType<WispTrailParticleEffect> particleType, FriendlyByteBuf packetByteBuf) {
            return new WispTrailParticleEffect(packetByteBuf.readFloat(), packetByteBuf.readFloat(), packetByteBuf.readFloat(), packetByteBuf.readFloat(), packetByteBuf.readFloat(), packetByteBuf.readFloat());
        }
    };
    private final float red;
    private final float green;
    private final float blue;
    private final float redEvolution;
    private final float greenEvolution;
    private final float blueEvolution;

    public WispTrailParticleEffect(float red, float green, float blue, float redEvolution, float greenEvolution, float blueEvolution) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.redEvolution = redEvolution;
        this.greenEvolution = greenEvolution;
        this.blueEvolution = blueEvolution;
    }

    public void m_7711_(FriendlyByteBuf buf) {
        buf.writeFloat(this.red);
        buf.writeFloat(this.green);
        buf.writeFloat(this.blue);
        buf.writeFloat(this.redEvolution);
        buf.writeFloat(this.greenEvolution);
        buf.writeFloat(this.blueEvolution);
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %.2f %.2f %.2f %.2f %.2f %.2f", ForgeRegistries.PARTICLE_TYPES.getKey(this.m_6012_()), Float.valueOf(this.red), Float.valueOf(this.green), Float.valueOf(this.blue), Float.valueOf(this.redEvolution), Float.valueOf(this.greenEvolution), Float.valueOf(this.blueEvolution));
    }

    public ParticleType<WispTrailParticleEffect> m_6012_() {
        return (ParticleType)Illuminations.WISP_TRAIL.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getRed() {
        return this.red;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getGreen() {
        return this.green;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getBlue() {
        return this.blue;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getRedEvolution() {
        return this.redEvolution;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getGreenEvolution() {
        return this.greenEvolution;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getBlueEvolution() {
        return this.blueEvolution;
    }
}

