/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.illuminations.client.particle.aura;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import ladysnake.illuminations.client.particle.aura.TwilightFireflyParticle;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class ConfettiParticle
extends TextureSheetParticle {
    private static final Random RANDOM = new Random();
    private final double rotationXmod;
    private final double rotationYmod;
    private final double rotationZmod;
    private final float groundOffset;
    private float rotationX;
    private float rotationY;
    private float rotationZ;

    public ConfettiParticle(ClientLevel world, double x, double y, double z, double velocityX, double velocityY, double velocityZ, SpriteSet spriteProvider) {
        super(world, x, y, z, velocityX, velocityY, velocityZ);
        this.f_107663_ *= 0.1f + new Random().nextFloat() * 0.5f;
        this.f_107219_ = true;
        this.m_108339_(spriteProvider);
        this.f_107230_ = 1.0f;
        this.f_107225_ = ThreadLocalRandom.current().nextInt(400, 420);
        this.f_107227_ = RANDOM.nextFloat();
        this.f_107229_ = RANDOM.nextFloat();
        this.f_107228_ = RANDOM.nextFloat();
        this.f_107226_ = 0.1f;
        this.f_107215_ = velocityX * 10.0;
        this.f_107216_ = velocityY * 10.0;
        this.f_107217_ = velocityZ * 10.0;
        this.f_172258_ = 0.5f;
        this.rotationX = RANDOM.nextFloat() * 360.0f;
        this.rotationY = RANDOM.nextFloat() * 360.0f;
        this.rotationZ = RANDOM.nextFloat() * 360.0f;
        this.rotationXmod = RANDOM.nextFloat() * 10.0f * (float)(this.f_107223_.m_188499_() ? -1 : 1);
        this.rotationYmod = RANDOM.nextFloat() * 10.0f * (float)(this.f_107223_.m_188499_() ? -1 : 1);
        this.rotationZmod = RANDOM.nextFloat() * 10.0f * (float)(this.f_107223_.m_188499_() ? -1 : 1);
        this.groundOffset = RANDOM.nextFloat() / 100.0f + 0.001f;
        this.m_107264_(this.f_107212_ + TwilightFireflyParticle.getWanderingDistance(this.f_107223_), this.f_107213_ + (double)this.f_107223_.m_188501_() * 2.0, this.f_107214_ + TwilightFireflyParticle.getWanderingDistance(this.f_107223_));
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public void m_5744_(VertexConsumer vertexConsumer, Camera camera, float tickDelta) {
        Vec3 vec3d = camera.m_90583_();
        float f = (float)(Mth.m_14139_((double)tickDelta, (double)this.f_107209_, (double)this.f_107212_) - vec3d.m_7096_());
        float g = (float)(Mth.m_14139_((double)tickDelta, (double)this.f_107210_, (double)this.f_107213_) - vec3d.m_7098_());
        float h = (float)(Mth.m_14139_((double)tickDelta, (double)this.f_107211_, (double)this.f_107214_) - vec3d.m_7094_());
        Vector3f[] Vec3fs = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float j = this.m_5902_(tickDelta);
        if (!this.f_107218_) {
            this.rotationX = (float)((double)this.rotationX + this.rotationXmod);
            this.rotationY = (float)((double)this.rotationY + this.rotationYmod);
            this.rotationZ = (float)((double)this.rotationZ + this.rotationZmod);
            for (int k = 0; k < 4; ++k) {
                Vector3f Vec3f2 = Vec3fs[k];
                Vec3f2.rotate((Quaternionfc)new Quaternionf(this.rotationX, this.rotationY, this.rotationZ, 0.0f));
                Vec3f2.mul(j);
                Vec3f2.add(f, g, h);
            }
        } else {
            this.rotationX = 90.0f;
            this.rotationY = 0.0f;
            for (int k = 0; k < 4; ++k) {
                Vector3f Vec3f2 = Vec3fs[k];
                Vec3f2.rotate((Quaternionfc)new Quaternionf(this.rotationX, this.rotationY, this.rotationZ, 0.0f));
                Vec3f2.mul(j);
                Vec3f2.add(f, g + this.groundOffset, h);
            }
        }
        float minU = this.m_5970_();
        float maxU = this.m_5952_();
        float minV = this.m_5951_();
        float maxV = this.m_5950_();
        int l = 0xF000F0;
        vertexConsumer.m_5483_((double)Vec3fs[0].x(), (double)Vec3fs[0].y(), (double)Vec3fs[0].z()).m_7421_(maxU, maxV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(l).m_5752_();
        vertexConsumer.m_5483_((double)Vec3fs[1].x(), (double)Vec3fs[1].y(), (double)Vec3fs[1].z()).m_7421_(maxU, minV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(l).m_5752_();
        vertexConsumer.m_5483_((double)Vec3fs[2].x(), (double)Vec3fs[2].y(), (double)Vec3fs[2].z()).m_7421_(minU, minV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(l).m_5752_();
        vertexConsumer.m_5483_((double)Vec3fs[3].x(), (double)Vec3fs[3].y(), (double)Vec3fs[3].z()).m_7421_(minU, maxV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(l).m_5752_();
        vertexConsumer.m_5483_((double)Vec3fs[0].x(), (double)Vec3fs[0].y(), (double)Vec3fs[0].z()).m_7421_(maxU, maxV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(l).m_5752_();
        vertexConsumer.m_5483_((double)Vec3fs[3].x(), (double)Vec3fs[3].y(), (double)Vec3fs[3].z()).m_7421_(maxU, minV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(l).m_5752_();
        vertexConsumer.m_5483_((double)Vec3fs[2].x(), (double)Vec3fs[2].y(), (double)Vec3fs[2].z()).m_7421_(minU, minV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(l).m_5752_();
        vertexConsumer.m_5483_((double)Vec3fs[1].x(), (double)Vec3fs[1].y(), (double)Vec3fs[1].z()).m_7421_(minU, maxV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(l).m_5752_();
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        } else if (this.f_107208_.m_6425_(new BlockPos((int)this.f_107212_, (int)(this.f_107213_ + 0.2), (int)this.f_107214_)).m_76178_()) {
            if (this.f_107208_.m_6425_(new BlockPos((int)this.f_107212_, (int)(this.f_107213_ - 0.01), (int)this.f_107214_)).m_205070_(FluidTags.f_13131_)) {
                this.f_107218_ = true;
                this.f_107216_ = 0.0;
            } else {
                this.f_107216_ -= 0.04 * (double)this.f_107226_;
                this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
                if (this.f_172259_ && this.f_107213_ == this.f_107210_) {
                    this.f_107215_ *= 1.1;
                    this.f_107217_ *= 1.1;
                }
                this.f_107215_ *= (double)this.f_172258_;
                this.f_107216_ *= (double)this.f_172258_;
                this.f_107217_ *= (double)this.f_172258_;
                this.f_172258_ = Math.min(0.98f, this.f_172258_ * 1.15f);
                if (this.f_107218_) {
                    this.f_107215_ *= (double)0.7f;
                    this.f_107217_ *= (double)0.7f;
                }
            }
        } else {
            this.m_107274_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class DefaultFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;

        public DefaultFactory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(SimpleParticleType defaultParticleType, ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            return new ConfettiParticle(clientWorld, d, e, f, g, h, i, this.spriteProvider);
        }
    }
}

