/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.illuminations.mixin;

import com.google.common.collect.ImmutableSet;
import java.util.function.Supplier;
import ladysnake.illuminations.client.Illuminations;
import ladysnake.illuminations.client.config.Config;
import ladysnake.illuminations.client.data.IlluminationData;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.storage.WritableLevelData;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Coerce;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientLevel.class})
public abstract class ClientWorldMixin
extends Level {
    @Shadow
    public abstract void m_7106_(ParticleOptions var1, double var2, double var4, double var6, double var8, double var10, double var12);

    protected ClientWorldMixin(WritableLevelData properties, ResourceKey<Level> resourceKeyLevel, RegistryAccess registryRef, Holder<DimensionType> dimension, Supplier<ProfilerFiller> profiler, boolean isClient, boolean debugWorld, long seed, int maxChainedNeighborUpdates) {
        super(properties, resourceKeyLevel, registryRef, dimension, profiler, isClient, debugWorld, seed, maxChainedNeighborUpdates);
    }

    @Inject(method={"doAnimateTick"}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/world/level/biome/Biome;getAmbientParticle()Ljava/util/Optional;"))}, at={@At(value="INVOKE", target="Ljava/util/Optional;ifPresent(Ljava/util/function/Consumer;)V", ordinal=0, shift=At.Shift.AFTER)})
    private void randomBlockDisplayTick(int centerX, int centerY, int centerZ, int radius, RandomSource random, @Coerce Object blockParticle, BlockPos.MutableBlockPos blockPos, CallbackInfo ci) {
        BlockPos.MutableBlockPos pos = blockPos.m_7918_((int)(this.f_46441_.m_188583_() * 50.0), (int)(this.f_46441_.m_188583_() * 25.0), (int)(this.f_46441_.m_188583_() * 50.0)).m_122032_();
        Holder b = this.m_204166_((BlockPos)pos);
        ResourceLocation biome = this.m_9598_().m_175515_(ForgeRegistries.BIOMES.getRegistryKey()).m_7981_((Object)((Biome)b.m_203334_()));
        this.spawnParticles(pos, (ImmutableSet<IlluminationData>)((ImmutableSet)Illuminations.ILLUMINATIONS_BIOME_CATEGORIES.get(biome)));
        if (Illuminations.ILLUMINATIONS_BIOMES.containsKey(biome)) {
            ImmutableSet illuminationDataSet = (ImmutableSet)Illuminations.ILLUMINATIONS_BIOMES.get(biome);
            this.spawnParticles(pos, (ImmutableSet<IlluminationData>)illuminationDataSet);
        }
        if (Illuminations.FIREFLY_LOCATION_PREDICATE.test(this, (BlockPos)pos) && random.m_188501_() <= Config.getFireflySpawnRate().spawnRate && Illuminations.FIREFLY.isPresent()) {
            this.m_7106_((ParticleOptions)Illuminations.FIREFLY.get(), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 0.0, 0.0, 0.0);
        }
        if (Illuminations.GLOWWORM_LOCATION_PREDICATE.test(this, (BlockPos)pos) && random.m_188501_() <= Config.getGlowwormSpawnRate().spawnRate && Illuminations.GLOWWORM.isPresent()) {
            this.m_7106_((ParticleOptions)Illuminations.GLOWWORM.get(), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 0.0, 0.0, 0.0);
        }
        if (Illuminations.PLANKTON_LOCATION_PREDICATE.test(this, (BlockPos)pos) && random.m_188501_() <= Config.getPlanktonSpawnRate().spawnRate && Illuminations.PLANKTON.isPresent()) {
            this.m_7106_((ParticleOptions)Illuminations.PLANKTON.get(), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 0.0, 0.0, 0.0);
        }
        if (Illuminations.EYES_LOCATION_PREDICATE.test(this, (BlockPos)pos) && random.m_188501_() <= Config.getEyesInTheDarkSpawnRate().spawnRate && Illuminations.EYES.isPresent()) {
            this.m_7106_((ParticleOptions)Illuminations.EYES.get(), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 0.0, 0.0, 0.0);
        }
        if (this.m_8055_((BlockPos)pos).m_60734_() == Blocks.f_50682_ && this.m_8055_(pos.m_7918_(0, -1, 0)).m_204336_(BlockTags.f_13085_) && random.m_188503_(50) == 0 && Illuminations.WILL_O_WISP.isPresent()) {
            this.m_6493_((ParticleOptions)Illuminations.WILL_O_WISP.get(), true, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 0.0, 0.0, 0.0);
        }
    }

    private void spawnParticles(BlockPos.MutableBlockPos pos, ImmutableSet<IlluminationData> illuminationDataSet) {
        if (illuminationDataSet != null) {
            for (IlluminationData illuminationData : illuminationDataSet) {
                if (!illuminationData.locationSpawnPredicate().test(this, (BlockPos)pos) || !illuminationData.shouldAddParticle(this.f_46441_)) continue;
                this.m_7106_((ParticleOptions)illuminationData.illuminationType(), pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), 0.0, 0.0, 0.0);
            }
        }
    }

    @Inject(method={"addPlayer"}, at={@At(value="RETURN")})
    public void addPlayer(int id, AbstractClientPlayer player, CallbackInfo ci) {
        Illuminations.loadPlayerCosmetics();
    }
}

