/*
 * Decompiled with CFR 0.152.
 */
package com.structureessentials.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceOrTagArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.structure.Structure;

public class Command {
    public LiteralArgumentBuilder<CommandSourceStack> build(CommandBuildContext buildContext) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"structureessentials").then(Commands.m_82127_((String)"getBiomeTags").then(Commands.m_82129_((String)"biome", (ArgumentType)ResourceOrTagArgument.m_247455_((CommandBuildContext)buildContext, (ResourceKey)Registries.f_256952_)).executes(context -> {
            ResourceKey biome = ((Holder.Reference)ResourceOrTagArgument.m_245464_((CommandContext)context, (String)"biome", (ResourceKey)Registries.f_256952_).m_245347_().left().get()).m_205785_();
            List biomeTags = ((Holder.Reference)((Registry)((CommandSourceStack)context.getSource()).m_5894_().m_6632_(Registries.f_256952_).get()).m_203636_(biome).get()).m_203616_().collect(Collectors.toList());
            ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)("Biome tags for: " + biome.m_135782_())).m_130940_(ChatFormatting.GOLD));
            for (TagKey biomeTag : biomeTags) {
                ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)("#" + biomeTag.f_203868_())));
            }
            return 1;
        })))).then(Commands.m_82127_((String)"getBiomesForTag").then(Commands.m_82129_((String)"biome", (ArgumentType)ResourceOrTagArgument.m_247455_((CommandBuildContext)buildContext, (ResourceKey)Registries.f_256952_)).executes(context -> {
            TagKey biomeTag = ((HolderSet.Named)ResourceOrTagArgument.m_245464_((CommandContext)context, (String)"biome", (ResourceKey)Registries.f_256952_).m_245347_().right().get()).m_205839_();
            ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)("Biomes for tag: " + biomeTag.f_203868_())).m_130940_(ChatFormatting.GOLD));
            for (Holder biomeHolder : ((Registry)((CommandSourceStack)context.getSource()).m_5894_().m_6632_(Registries.f_256952_).get()).m_206115_()) {
                if (!biomeHolder.m_203656_(biomeTag)) continue;
                ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)("Biome: " + ((ResourceKey)biomeHolder.m_203543_().get()).m_135782_())));
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"getStructuresNearby").requires(stack -> stack.m_6761_(2))).executes(context -> {
            ServerLevel world = ((CommandSourceStack)context.getSource()).m_81372_();
            HashMap<Structure, LongSet> structures = new HashMap<Structure, LongSet>();
            ChunkPos start = new ChunkPos(BlockPos.m_274446_((Position)((CommandSourceStack)context.getSource()).m_81371_()));
            for (int x = -5; x < 5; ++x) {
                for (int z = -5; z < 5; ++z) {
                    for (Map.Entry entry : world.m_215010_().m_220522_(new BlockPos(start.f_45578_ + x << 4, 0, start.f_45579_ + z << 4)).entrySet()) {
                        structures.computeIfAbsent((Structure)entry.getKey(), k -> new LongOpenHashSet((LongCollection)entry.getValue())).addAll((LongCollection)entry.getValue());
                    }
                }
            }
            ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)"Structures nearby: ").m_130940_(ChatFormatting.GOLD));
            HashMap structurePositions = new HashMap();
            for (Map.Entry structureEntry : structures.entrySet()) {
                world.m_215010_().m_220480_((Structure)structureEntry.getKey(), (LongSet)structureEntry.getValue(), structureStart -> structurePositions.put(structureStart.m_73601_().m_162394_(), ((Registry)((CommandSourceStack)context.getSource()).m_5894_().m_6632_(Registries.f_256944_).get()).m_7981_((Object)((Structure)structureEntry.getKey())).toString()));
            }
            ArrayList sortedStructures = new ArrayList(structurePositions.entrySet());
            sortedStructures.sort(Comparator.comparingDouble(p -> ((BlockPos)p.getKey()).m_123331_((Vec3i)BlockPos.m_274446_((Position)((CommandSourceStack)context.getSource()).m_81371_()))));
            for (Map.Entry structureEntry : sortedStructures) {
                ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)((String)structureEntry.getValue())).m_7220_((Component)Component.m_237113_((String)(" " + structureEntry.getKey())).m_130940_(ChatFormatting.YELLOW).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tp " + ((BlockPos)structureEntry.getKey()).m_123341_() + " " + ((BlockPos)structureEntry.getKey()).m_123342_() + " " + ((BlockPos)structureEntry.getKey()).m_123343_())))));
            }
            return 1;
        }))).then(Commands.m_82127_((String)"getSimilarForBiome").then(Commands.m_82129_((String)"biome", (ArgumentType)ResourceOrTagArgument.m_247455_((CommandBuildContext)buildContext, (ResourceKey)Registries.f_256952_)).executes(context -> {
            int i;
            ResourceKey biome = ((Holder.Reference)ResourceOrTagArgument.m_245464_((CommandContext)context, (String)"biome", (ResourceKey)Registries.f_256952_).m_245347_().left().get()).m_205785_();
            List biomeTags = ((Holder.Reference)((Registry)((CommandSourceStack)context.getSource()).m_5894_().m_6632_(Registries.f_256952_).get()).m_203636_(biome).get()).m_203616_().collect(Collectors.toList());
            ArrayList<Object> similarBiomes = new ArrayList<Object>();
            for (Object currentBiome : ((Registry)((CommandSourceStack)context.getSource()).m_5894_().m_6632_(Registries.f_256952_).get()).m_206115_()) {
                for (Object tag : biomeTags) {
                    if (!currentBiome.m_203656_((TagKey)tag)) continue;
                    similarBiomes.add(currentBiome);
                }
            }
            HashMap<Holder, Integer> countMap = new HashMap<Holder, Integer>();
            for (Holder holder : similarBiomes) {
                for (TagKey similarBiomeTagKey : holder.m_203616_().toList()) {
                    if (biomeTags.contains(similarBiomeTagKey)) {
                        countMap.put(holder, countMap.getOrDefault(holder, 0) + 2);
                        continue;
                    }
                    countMap.put(holder, countMap.getOrDefault(holder, 0) - 1);
                }
            }
            ArrayList sortedBiomeHolders = new ArrayList(countMap.entrySet());
            sortedBiomeHolders.sort(Comparator.comparingInt(e -> (Integer)((Map.Entry)e).getValue()).reversed());
            HashMap<TagKey, Double> hashMap = new HashMap<TagKey, Double>();
            for (i = 0; i < sortedBiomeHolders.size(); ++i) {
                double weight = ((double)sortedBiomeHolders.size() / 6.0 - (double)i) / ((double)sortedBiomeHolders.size() / 6.0);
                if ((double)i > (double)sortedBiomeHolders.size() / 6.0) {
                    weight = -((double)i - (double)sortedBiomeHolders.size() * 0.16666666666666666) / ((double)sortedBiomeHolders.size() * 0.8333333333333334);
                }
                Map.Entry biomeHolderEntry = (Map.Entry)sortedBiomeHolders.get(i);
                for (TagKey biomeHolderEntryTag : ((Holder)biomeHolderEntry.getKey()).m_203616_().toList()) {
                    if (!biomeTags.contains(biomeHolderEntryTag)) continue;
                    hashMap.put(biomeHolderEntryTag, hashMap.getOrDefault(biomeHolderEntryTag, 0.0) + 1.0 * weight);
                }
            }
            ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)("Similar biomes for: " + biome.m_135782_())).m_130940_(ChatFormatting.GOLD));
            for (i = 0; i < sortedBiomeHolders.size() && i < 10; ++i) {
                ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)("Weight:" + ((Map.Entry)sortedBiomeHolders.get(i)).getValue() + " Biome: " + ((ResourceKey)((Holder)((Map.Entry)sortedBiomeHolders.get(i)).getKey()).m_203439_().left().get()).m_135782_())));
            }
            ArrayList sortedBiomeTagKeys = new ArrayList(hashMap.entrySet());
            sortedBiomeTagKeys.sort(Comparator.comparingDouble(e -> (Double)((Map.Entry)e).getValue()).reversed());
            ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)("Similar biome tags for: " + biome.m_135782_())).m_130940_(ChatFormatting.GOLD));
            for (Map.Entry entry : sortedBiomeTagKeys) {
                ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)("Weight:" + Math.round((Double)entry.getValue()) + " Tag: #" + ((TagKey)entry.getKey()).f_203868_())));
            }
            return 1;
        })));
    }
}

