/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.wares.client.gui.agreement;

import io.github.mortuusars.mpfui.component.Rectangle;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class AgreementLayout {
    private List<Pair<Element, Rectangle>> elements = new ArrayList<Pair<Element, Rectangle>>();

    @Nullable
    public Rectangle getElement(Element type) {
        for (Pair<Element, Rectangle> element : this.elements) {
            if (element.left() != type) continue;
            return (Rectangle)element.right();
        }
        return null;
    }

    public AgreementLayout append(Element type, int xPos, int width, int height, int spacing) {
        if (this.getElement(type) != null) {
            throw new IllegalStateException("Attempted to add same type of element twice.");
        }
        int lastX = this.elements.size() > 0 ? ((Rectangle)this.elements.get(this.elements.size() - 1).right()).bottom() : 0;
        this.elements.add((Pair<Element, Rectangle>)Pair.of((Object)((Object)type), (Object)new Rectangle(xPos, lastX + spacing, width, height)));
        return this;
    }

    public AgreementLayout clear() {
        this.elements.clear();
        return this;
    }

    public int getHeight() {
        if (this.elements.size() == 0) {
            return 0;
        }
        int yMin = Integer.MAX_VALUE;
        int yMax = Integer.MIN_VALUE;
        for (Pair<Element, Rectangle> element : this.elements) {
            yMin = Math.min(yMin, ((Rectangle)element.right()).top());
            yMax = Math.max(yMax, ((Rectangle)element.right()).bottom());
        }
        return yMax - yMin;
    }

    public AgreementLayout offset(int x, int y) {
        ArrayList<Pair<Element, Rectangle>> modifiedElements = new ArrayList<Pair<Element, Rectangle>>();
        for (Pair<Element, Rectangle> element : this.elements) {
            modifiedElements.add((Pair<Element, Rectangle>)Pair.of((Object)((Object)((Element)((Object)element.left()))), (Object)((Rectangle)element.right()).shift(x, y)));
        }
        AgreementLayout layout = new AgreementLayout();
        layout.elements = modifiedElements;
        return layout;
    }

    public static enum Element {
        TITLE,
        MESSAGE,
        SLOTS,
        ORDERED,
        EXPIRY;

    }
}

