/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.wares.client.gui.agreement;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import io.github.mortuusars.wares.Wares;
import io.github.mortuusars.wares.client.gui.agreement.element.Seal;
import io.github.mortuusars.wares.config.Config;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;

public class SealedAgreementScreen
extends Screen {
    private static final ResourceLocation TEXTURE = new ResourceLocation("wares", "textures/gui/sealed_agreement.png");
    private static final int IMAGE_WIDTH = 196;
    private static final int IMAGE_HEIGHT = 120;
    private static final float SCALE = 1.25f;
    private static final int MAX_ROTATION_HORIZONTAL = 200;
    private static final int MAX_ROTATION_VERTICAL = 45;
    private static final int BACKSIDE_HORIZONTAL_MARGIN = 16;
    private static final int BACKSIDE_VERTICAL_MARGIN = 16;
    private static final int FONT_COLOR = -7838649;
    private final Seal seal;
    private final Component sealTooltip;
    private final Component backsideMessage;
    private final Component showRemainingTextMessage;
    private Screen parentScreen;
    private List<FormattedCharSequence> backsideMessageVisibleLines = Collections.emptyList();
    private List<FormattedCharSequence> backsideMessageLeftoverLines = Collections.emptyList();
    private boolean isFlipped = false;
    private int messagePosY;
    private long flippedAt = 0L;
    private boolean shouldDrawShowRemainingTextMessage = true;
    private int showRemainingTextMessageOpacity = 19;
    private long prevGameTime = 0L;

    public SealedAgreementScreen(String seal, Component sealTooltip, Component backsideMessage) {
        super((Component)Component.m_237119_());
        this.seal = new Seal(seal);
        this.sealTooltip = sealTooltip;
        this.backsideMessage = backsideMessage;
        this.showRemainingTextMessage = Component.m_237115_((String)"gui.wares.sealed_agreement.show_remaining_text_message");
        this.f_96541_ = Minecraft.m_91087_();
    }

    public boolean isOpen() {
        return this.f_96541_ != null && this.f_96541_.f_91080_ == this;
    }

    public boolean m_7043_() {
        return false;
    }

    public void showAsOverlay() {
        if (this.f_96541_ != null) {
            if (!this.isOpen()) {
                this.parentScreen = this.f_96541_.f_91080_;
            }
            this.f_96541_.m_91152_((Screen)this);
            assert (this.f_96541_.f_91074_ != null);
            this.f_96541_.f_91074_.m_5496_((SoundEvent)Wares.SoundEvents.PAPER_CRACKLE.get(), 1.0f, this.f_96541_.f_91074_.m_9236_().m_213780_().m_188501_() * 0.1f + 0.9f);
        }
    }

    public void m_7379_() {
        if (this.isOpen() && this.f_96541_ != null) {
            this.f_96541_.m_91152_(this.parentScreen);
            this.parentScreen = null;
            assert (this.f_96541_.f_91074_ != null);
            this.f_96541_.f_91074_.m_5496_((SoundEvent)Wares.SoundEvents.PAPER_CRACKLE.get(), 1.0f, this.f_96541_.f_91074_.m_9236_().m_213780_().m_188501_() * 0.1f + 1.2f);
            return;
        }
        super.m_7379_();
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (((Boolean)Config.AGREEMENT_CLOSE_WITH_RMB.get()).booleanValue() && pButton == 1) {
            this.m_7379_();
            return true;
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (pKeyCode == 69) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    protected void m_7856_() {
        super.m_7856_();
        if (!this.backsideMessage.equals(Component.m_237119_())) {
            ArrayList messageLines = new ArrayList(this.f_96547_.m_92923_((FormattedText)this.backsideMessage, 164));
            int n = messageLines.size();
            Objects.requireNonNull(this.f_96547_);
            this.backsideMessageVisibleLines = messageLines.subList(0, Math.min(n, 88 / 9));
            int n2 = this.backsideMessageVisibleLines.size();
            Objects.requireNonNull(this.f_96547_);
            this.messagePosY = (120 - n2 * 9) / 2;
            if (messageLines.size() > this.backsideMessageVisibleLines.size()) {
                int lastLineIndex = this.backsideMessageVisibleLines.size() - 1;
                FormattedCharSequence lastLine = this.backsideMessageVisibleLines.get(lastLineIndex);
                lastLine = FormattedCharSequence.m_13696_((FormattedCharSequence)lastLine, (FormattedCharSequence)FormattedCharSequence.m_13714_((String)"...", (Style)this.backsideMessage.m_7383_()));
                this.backsideMessageVisibleLines.set(lastLineIndex, lastLine);
                this.backsideMessageLeftoverLines = messageLines.subList(this.backsideMessageVisibleLines.size(), messageLines.size());
                this.backsideMessageLeftoverLines.set(0, FormattedCharSequence.m_13696_((FormattedCharSequence)FormattedCharSequence.m_13714_((String)"...", (Style)this.backsideMessage.m_7383_()), (FormattedCharSequence)this.backsideMessageLeftoverLines.get(0)));
            }
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 0.0f, 200.0f);
        poseStack.m_252880_((float)this.f_96543_ / 2.0f, (float)this.f_96544_ / 2.0f, 0.0f);
        float fromCenterX = (float)mouseX - (float)this.f_96543_ / 2.0f;
        float fromCenterY = (float)mouseY - (float)this.f_96544_ / 2.0f;
        float rotX = (fromCenterX + (float)this.f_96543_ / 2.0f) / ((float)this.f_96543_ / 2.0f) * 200.0f;
        float rotY = (fromCenterY + (float)this.f_96544_ / 2.0f) / ((float)this.f_96544_ / 2.0f) * 45.0f;
        float yBright = (-(rotY -= 45.0f) + 45.0f) / 90.0f * -0.3f;
        float brightness = 1.0f - (0.15f + yBright);
        float xRotatedBy = ((rotX -= 200.0f) + 90.0f) % 360.0f;
        boolean flipped = xRotatedBy > 180.0f || xRotatedBy < 0.0f;
        this.flip(flipped);
        if (flipped) {
            rotX -= 180.0f;
            rotX *= -1.0f;
        }
        poseStack.m_252781_(Axis.f_252436_.m_252977_(rotX * -1.0f));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(rotY));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(rotX * rotY * 0.001f));
        poseStack.m_85841_(1.25f, 1.25f, 1.25f);
        poseStack.m_252880_(-98.0f, -60.0f, 0.0f);
        RenderSystem.setShaderColor((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
        graphics.m_280218_(TEXTURE, 0, 0, 0, this.isFlipped ? 121 : 0, 196, 120);
        if (!this.isFlipped) {
            this.renderSeal(graphics, rotX, rotY, brightness);
        } else if (!this.backsideMessageVisibleLines.isEmpty()) {
            for (int i = 0; i < this.backsideMessageVisibleLines.size(); ++i) {
                FormattedCharSequence line = this.backsideMessageVisibleLines.get(i);
                int mX = 98 - this.f_96547_.m_92724_(line) / 2;
                Objects.requireNonNull(this.f_96547_);
                graphics.m_280648_(this.f_96547_, line, mX, this.messagePosY + 9 * i, -7838649);
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
        if (Math.abs(fromCenterX) < 20.0f && Math.abs(fromCenterY) < 20.0f && !this.isFlipped && !this.sealTooltip.equals(Component.m_237119_())) {
            graphics.m_280557_(this.f_96547_, this.sealTooltip, mouseX, mouseY);
        }
        if (this.isFlipped && Screen.m_96638_() && !this.backsideMessage.equals(Component.m_237119_()) && !this.backsideMessageLeftoverLines.isEmpty()) {
            graphics.m_280245_(this.f_96547_, this.backsideMessageLeftoverLines, mouseX, mouseY);
        }
        if (Screen.m_96638_()) {
            this.shouldDrawShowRemainingTextMessage = false;
        }
        if (!this.backsideMessageLeftoverLines.isEmpty()) {
            this.drawShowRemainingTextMessage(graphics);
        }
        assert (Minecraft.m_91087_().f_91073_ != null);
        this.prevGameTime = Minecraft.m_91087_().f_91073_.m_46467_();
    }

    private void drawShowRemainingTextMessage(GuiGraphics graphics) {
        assert (Minecraft.m_91087_().f_91073_ != null);
        long gameTime = Minecraft.m_91087_().f_91073_.m_46467_();
        float fadeIn = 60.0f;
        if (this.shouldDrawShowRemainingTextMessage && this.isFlipped && gameTime - this.flippedAt > 20L) {
            assert (this.f_96541_ != null);
            double time = (float)gameTime + this.f_96541_.m_91296_() - (float)this.flippedAt - 20.0f;
            double range = Mth.m_14008_((double)(time / (double)fadeIn), (double)0.001f, (double)1.0);
            double rangeEaseInOut = range < 0.5 ? 4.0 * range * range * range : 1.0 - Math.pow(-2.0 * range + 2.0, 3.0) / 2.0;
            this.showRemainingTextMessageOpacity = Math.max((int)Math.floor(rangeEaseInOut * 255.0), 20);
        } else if (this.showRemainingTextMessageOpacity > 20 && gameTime != this.prevGameTime) {
            this.showRemainingTextMessageOpacity -= 16;
        }
        if (this.showRemainingTextMessageOpacity > 19) {
            graphics.m_280430_(this.f_96547_, this.showRemainingTextMessage, (int)((float)this.f_96543_ / 2.0f - (float)this.f_96547_.m_92852_((FormattedText)this.showRemainingTextMessage) / 2.0f), this.f_96544_ - 50, 0x555555 | this.showRemainingTextMessageOpacity << 24);
        }
    }

    private void flip(boolean value) {
        if (this.isFlipped != value) {
            this.isFlipped = value;
            assert (Minecraft.m_91087_().f_91073_ != null);
            this.flippedAt = Minecraft.m_91087_().f_91073_.m_46467_();
            this.shouldDrawShowRemainingTextMessage = true;
            assert (Minecraft.m_91087_().f_91073_ != null);
            assert (Minecraft.m_91087_().f_91074_ != null);
            RandomSource random = Minecraft.m_91087_().f_91073_.f_46441_;
            float pitch = random.m_188501_() * 0.2f + (this.isFlipped ? 1.1f : 1.5f);
            Minecraft.m_91087_().f_91074_.m_5496_((SoundEvent)Wares.SoundEvents.PAPER_CRACKLE.get(), 0.65f, pitch);
        }
    }

    private void renderSeal(GuiGraphics graphics, float rotX, float rotY, float brightness) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.seal.getTexturePath());
        int sealX = 74;
        int sealY = 36;
        float x = rotX * 0.2f;
        float y = rotY * 0.2f;
        RenderSystem.disableDepthTest();
        float shadowAlpha = Mth.m_184637_((float)Math.max(rotY * -1.0f, 0.0f), (float)-10.0f, (float)45.0f, (float)0.1f, (float)0.65f) + 0.1f;
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)brightness, (float)brightness, (float)brightness, (float)shadowAlpha);
        this.renderSealElementWithParallax(graphics, 74, 36, 0.0f, shadowAlpha * 3.0f, 0.0f, Seal.Element.SHADOW);
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
        this.renderSealElementWithParallax(graphics, 74, 36, x * 0.45f, y * 0.45f, -0.05f, Seal.Element.STRING);
        this.renderSealElementWithParallax(graphics, 74, 36, x * 0.5f, y * 0.5f, -0.1f, Seal.Element.STRING);
        this.renderSealElementWithParallax(graphics, 74, 36, x * 0.55f, y * 0.55f, -0.15f, Seal.Element.STRING);
        this.renderSealElementWithParallax(graphics, 74, 36, x * 0.6f, y * 0.6f, -0.2f, Seal.Element.STRING);
        this.renderSealElementWithParallax(graphics, 74, 36, x * 0.15f, y * 0.15f, -0.1f, Seal.Element.BASE);
        this.renderSealElementWithParallax(graphics, 74, 36, x * 0.2f, y * 0.2f, -0.2f, Seal.Element.BASE);
        this.renderSealElementWithParallax(graphics, 74, 36, x * 0.25f, y * 0.25f, -0.3f, Seal.Element.BASE);
        this.renderSealElementWithParallax(graphics, 74, 36, x * 0.3f, y * 0.3f, -0.4f, Seal.Element.BASE);
        this.renderSealElementWithParallax(graphics, 74, 36, x * 0.35f, y * 0.35f, -0.5f, Seal.Element.BASE);
        this.renderSealElementWithParallax(graphics, 74, 36, x * 0.1f, y * 0.1f, -0.05f, Seal.Element.LOGO);
        this.renderSealElementWithParallax(graphics, 74, 36, x * 0.15f, y * 0.15f, -0.1f, Seal.Element.LOGO);
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
    }

    private void renderSealElementWithParallax(GuiGraphics graphics, int x, int y, float pX, float pY, float pZ, Seal.Element element) {
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_252880_(pX, pY, pZ);
        graphics.m_280218_(this.seal.getTexturePath(), x, y, 0, element.getVOffset(), 48, 48);
        poseStack.m_252880_(-pX, -pY, -pZ);
    }
}

