/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.wares.client.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.mortuusars.wares.Wares;
import io.github.mortuusars.wares.config.Config;
import io.github.mortuusars.wares.menu.DeliveryTableMenu;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;

public class DeliveryTableScreen
extends AbstractContainerScreen<DeliveryTableMenu> {
    public static final ResourceLocation TEXTURE = Wares.resource("textures/gui/delivery_table.png");
    private final Component manualDeliveryButtonTitle = Component.m_237115_((String)"gui.wares.delivery_table.manual_delivery");
    private final MutableComponent manualDeliveryButtonTooltip = Component.m_237115_((String)"gui.wares.delivery_table.manual_delivery.tooltip");
    private ImageButton manualDeliveryButton;

    public DeliveryTableScreen(DeliveryTableMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        double manualDeliveryTimeModifier = (Double)Config.MANUAL_DELIVERY_TIME_MODIFIER.get();
        if (manualDeliveryTimeModifier > 1.0) {
            String formattedModifier = manualDeliveryTimeModifier % 1.0 == 0.0 ? String.format("%.0f", manualDeliveryTimeModifier) : String.format("%.1f", manualDeliveryTimeModifier);
            this.manualDeliveryButtonTooltip.m_130946_("\n").m_7220_((Component)Component.m_237110_((String)"gui.wares.delivery_table.manual_delivery.tooltip_extra_info", (Object[])new Object[]{formattedModifier}).m_130940_(ChatFormatting.GRAY));
        }
        playerInventory.f_35978_.m_5496_((SoundEvent)Wares.SoundEvents.DELIVERY_TABLE_OPEN.get(), 0.8f, playerInventory.f_35978_.m_9236_().m_213780_().m_188501_() * 0.2f + 0.9f);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_97726_ = 176;
        this.f_97727_ = 172;
        this.f_97731_ = 79;
        this.manualDeliveryButton = new ImageButton(this.getGuiLeft() + 74, this.getGuiTop() + 36, 28, 20, 176, 70, 20, TEXTURE, 256, 256, this::manualDeliveryButtonPressed, this.manualDeliveryButtonTitle);
        this.manualDeliveryButton.m_257544_(Tooltip.m_257550_((Component)this.manualDeliveryButtonTooltip));
        this.m_142416_((GuiEventListener)this.manualDeliveryButton);
    }

    private void manualDeliveryButtonPressed(Button button) {
        assert (this.f_96541_ != null);
        assert (this.f_96541_.f_91072_ != null);
        this.f_96541_.f_91072_.m_105208_(((DeliveryTableMenu)this.f_97732_).f_38840_, 0);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.manualDeliveryButton.f_93624_ = ((DeliveryTableMenu)this.f_97732_).canDeliverManually();
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        this.m_280072_(graphics, mouseX, mouseY);
        if (((DeliveryTableMenu)this.f_97732_).m_142621_().m_41619_()) {
            Slot boxSlot;
            Slot agreementSlot = (Slot)((DeliveryTableMenu)this.f_97732_).f_38839_.get(0);
            if (!agreementSlot.m_6657_() && this.m_6774_(agreementSlot.f_40220_, agreementSlot.f_40221_, 18, 18, mouseX, mouseY)) {
                graphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"gui.wares.delivery_table.no_agreement.tooltip"), mouseX, mouseY);
            }
            if (((Boolean)Config.DELIVERIES_REQUIRE_BOXES.get()).booleanValue() && !(boxSlot = (Slot)((DeliveryTableMenu)this.f_97732_).f_38839_.get(1)).m_6657_() && this.m_6774_(boxSlot.f_40220_, boxSlot.f_40221_, 18, 18, mouseX, mouseY)) {
                graphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"gui.wares.delivery_table.no_packages.tooltip"), mouseX, mouseY);
            }
        }
    }

    protected void m_7286_(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.m_280218_(TEXTURE, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        if (!((DeliveryTableMenu)this.f_97732_).blockEntity.isAgreementLocked()) {
            graphics.m_280218_(TEXTURE, this.f_97735_ + 79, this.f_97736_ + 15, 176, 16, 18, 18);
        }
        if (!((Slot)((DeliveryTableMenu)this.f_97732_).f_38839_.get(0)).m_6657_()) {
            graphics.m_280218_(TEXTURE, this.f_97735_ + 79, this.f_97736_ + 15, 176, 34, 18, 18);
        }
        if (((Boolean)Config.DELIVERIES_REQUIRE_BOXES.get()).booleanValue()) {
            Slot packagesSlot = (Slot)((DeliveryTableMenu)this.f_97732_).f_38839_.get(1);
            graphics.m_280218_(TEXTURE, this.f_97735_ + packagesSlot.f_40220_ - 1, this.f_97736_ + packagesSlot.f_40221_ - 1, 176, 16, 18, 18);
            if (!packagesSlot.m_6657_()) {
                graphics.m_280218_(TEXTURE, this.f_97735_ + packagesSlot.f_40220_ - 1, this.f_97736_ + packagesSlot.f_40221_ - 1, 176, 52, 18, 18);
            }
        }
        float progress = ((DeliveryTableMenu)this.f_97732_).getDeliveryProgress();
        int arrowWidth = 22;
        int arrowHeight = 16;
        int progressInPixels = Mth.m_14045_((int)((int)((float)(arrowWidth + 1) * progress)), (int)0, (int)arrowWidth);
        graphics.m_280218_(TEXTURE, this.f_97735_ + 77, this.f_97736_ + 37, 176, 0, progressInPixels, arrowHeight);
    }

    public void m_7379_() {
        super.m_7379_();
        if (Minecraft.m_91087_().f_91074_ != null) {
            Minecraft.m_91087_().f_91074_.m_5496_((SoundEvent)Wares.SoundEvents.DELIVERY_TABLE_CLOSE.get(), 0.8f, Minecraft.m_91087_().f_91074_.m_9236_().m_213780_().m_188501_() * 0.2f + 0.9f);
        }
    }
}

