/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.wares.data.agreement.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.mortuusars.wares.data.agreement.component.CompoundTagCompareBehavior;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.AirItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class RequestedItem {
    public static final Codec<RequestedItem> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.either((Codec)TagKey.m_203886_((ResourceKey)Registries.f_256913_), (Codec)ForgeRegistries.ITEMS.getCodec()).fieldOf("id").forGetter(RequestedItem::getTagOrItem), (App)ExtraCodecs.f_144629_.optionalFieldOf("Count", (Object)1).forGetter(RequestedItem::getCount), (App)CompoundTag.f_128325_.optionalFieldOf("tag").forGetter(ri -> Optional.ofNullable(ri.getTag())), (App)StringRepresentable.m_216439_(CompoundTagCompareBehavior::values).optionalFieldOf("TagMatching", (Object)CompoundTagCompareBehavior.WEAK).forGetter(RequestedItem::getTagCompareBehavior)).apply((Applicative)instance, RequestedItem::new));
    public static final RequestedItem EMPTY = new RequestedItem((Either<TagKey<Item>, Item>)Either.right((Object)Items.f_41852_), 1, (CompoundTag)null, CompoundTagCompareBehavior.WEAK);
    private final Either<TagKey<Item>, Item> tagOrItem;
    private final int count;
    @Nullable
    private final CompoundTag tag;
    private final CompoundTagCompareBehavior tagCompareBehavior;

    public RequestedItem(Either<TagKey<Item>, Item> tagOrItem, int count, @Nullable CompoundTag tag, CompoundTagCompareBehavior tagCompareBehavior) {
        this.tagOrItem = tagOrItem;
        this.count = count;
        this.tag = tag;
        this.tagCompareBehavior = tagCompareBehavior;
    }

    public RequestedItem(Either<TagKey<Item>, Item> tagOrItem, int count, @Nullable CompoundTag tag) {
        this(tagOrItem, count, tag, CompoundTagCompareBehavior.WEAK);
    }

    public RequestedItem(TagKey<Item> tag, int count) {
        this((Either<TagKey<Item>, Item>)Either.left(tag), count, null);
    }

    public RequestedItem(Item item, int count) {
        this((Either<TagKey<Item>, Item>)Either.right((Object)item), count, null);
    }

    public RequestedItem(ItemStack stack) {
        this((Either<TagKey<Item>, Item>)Either.right((Object)stack.m_41720_()), stack.m_41613_(), stack.m_41783_());
    }

    private RequestedItem(Either<TagKey<Item>, Item> tagOrItem, int count, Optional<CompoundTag> tag, CompoundTagCompareBehavior tagCompareBehavior) {
        this(tagOrItem, count, (CompoundTag)tag.orElse(null), tagCompareBehavior);
    }

    public Either<TagKey<Item>, Item> getTagOrItem() {
        return this.tagOrItem;
    }

    public int getCount() {
        return this.count;
    }

    @Nullable
    public CompoundTag getTag() {
        return this.tag;
    }

    public CompoundTagCompareBehavior getTagCompareBehavior() {
        return this.tagCompareBehavior;
    }

    public List<ItemStack> getStacks() {
        return (List)this.tagOrItem.map(tag -> Objects.requireNonNull(ForgeRegistries.ITEMS.tags()).getTag(tag).stream().map(item -> {
            ItemStack stack = new ItemStack((ItemLike)item, this.getCount());
            stack.m_41751_(this.getTag());
            return stack;
        }).toList(), item -> {
            ItemStack stack = new ItemStack((ItemLike)item, this.getCount());
            stack.m_41751_(this.getTag());
            return List.of(stack);
        });
    }

    public boolean matches(ItemStack stack) {
        return (Boolean)this.getTagOrItem().map(item -> stack.m_204117_(item), tag -> stack.m_150930_(tag)) != false && this.tagMatches(stack);
    }

    public boolean matchesWithCount(ItemStack stack) {
        return this.matches(stack) && stack.m_41613_() >= this.getCount();
    }

    public boolean tagMatches(ItemStack stack) {
        switch (this.tagCompareBehavior) {
            case IGNORE: {
                return true;
            }
            case WEAK: {
                return NbtUtils.m_129235_((Tag)this.getTag(), (Tag)stack.m_41783_(), (boolean)true);
            }
            case STRONG: {
                CompoundTag tag = this.getTag();
                CompoundTag stackTag = stack.m_41783_();
                if (tag == null || tag.m_128456_()) {
                    return stackTag == null || stackTag.m_128456_();
                }
                return tag.equals((Object)stackTag);
            }
        }
        return false;
    }

    public boolean isEmpty() {
        return this.equals(EMPTY) || (Boolean)this.getTagOrItem().map(tag -> false, item -> item instanceof AirItem) != false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestedItem that = (RequestedItem)o;
        return this.count == that.count && Objects.equals(this.tagOrItem, that.tagOrItem) && Objects.equals(this.tag, that.tag);
    }

    public int hashCode() {
        return Objects.hash(this.tagOrItem, this.count, this.tag);
    }

    public String toString() {
        return "RequestedItem{tagOrItem=" + (String)this.tagOrItem.map(tag -> "#" + tag.f_203868_(), item -> Objects.requireNonNull(ForgeRegistries.ITEMS.getKey(item)).toString()) + ", count=" + this.count + (String)(this.tag != null ? ", tag=" + this.tag : "") + ",TagMatching:" + this.tagCompareBehavior.m_7912_() + "}";
    }
}

