/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.polymorph.server.wrapper;

import com.illusivesoulworks.polymorph.server.wrapper.IngredientWrapper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;

public class RecipeWrapper {
    private final Recipe<?> recipe;
    private final List<IngredientWrapper> ingredients;

    public RecipeWrapper(Recipe<?> pRecipe) {
        this.recipe = pRecipe;
        this.ingredients = new ArrayList<IngredientWrapper>();
        for (Ingredient ingredient : this.recipe.m_7527_()) {
            IngredientWrapper wrapped = new IngredientWrapper(ingredient);
            this.ingredients.add(wrapped);
        }
    }

    public Recipe<?> getRecipe() {
        return this.recipe;
    }

    public ResourceLocation getId() {
        return this.recipe.m_6423_();
    }

    public List<IngredientWrapper> getIngredients() {
        return this.ingredients;
    }

    public boolean conflicts(RecipeWrapper pOther) {
        if (pOther == null) {
            return false;
        }
        if (this.getId().equals((Object)pOther.getId())) {
            return true;
        }
        if (this.ingredients.size() != pOther.getIngredients().size()) {
            return false;
        }
        List<IngredientWrapper> otherIngredients = pOther.getIngredients();
        for (int i = 0; i < otherIngredients.size(); ++i) {
            if (otherIngredients.get(i).matches(this.getIngredients().get(i))) continue;
            return false;
        }
        return true;
    }
}

