/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.handcrafted.client.renderer.fancypainting;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.teamresourceful.resourcefullib.client.CloseablePoseStack;
import com.teamresourceful.resourcefullib.common.registry.RegistryEntry;
import earth.terrarium.handcrafted.client.renderer.fancypainting.FancyPaintingModel;
import earth.terrarium.handcrafted.common.entities.FancyPainting;
import earth.terrarium.handcrafted.common.registry.ModPaintingVariants;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.decoration.PaintingVariant;
import org.jetbrains.annotations.NotNull;

public class FancyPaintingRenderer
extends EntityRenderer<FancyPainting> {
    private static final ResourceLocation FRAME_SMALL_TEXTURE = new ResourceLocation("handcrafted", "textures/painting/small_painting_frame.png");
    private static final ResourceLocation FRAME_MEDIUM_TEXTURE = new ResourceLocation("handcrafted", "textures/painting/medium_painting_frame.png");
    private static final ResourceLocation FRAME_LARGE_TEXTURE = new ResourceLocation("handcrafted", "textures/painting/large_painting_frame.png");
    private static final ResourceLocation FRAME_TALL_TEXTURE = new ResourceLocation("handcrafted", "textures/painting/tall_painting_frame.png");
    private static final ResourceLocation FRAME_WIDE_TEXTURE = new ResourceLocation("handcrafted", "textures/painting/wide_painting_frame.png");
    private static final Map<PaintingVariant, ResourceLocation> PAINTING_TEXTURES_BY_VARIANT = ModPaintingVariants.PAINTING_VARIANTS.stream().collect(Collectors.toUnmodifiableMap(RegistryEntry::get, v -> new ResourceLocation("handcrafted", "textures/painting/" + v.getId().m_135815_() + ".png")));
    private static final Map<PaintingVariant, ResourceLocation> FRAME_TEXTURES_BY_VARIANT = ModPaintingVariants.PAINTING_VARIANTS.stream().map(RegistryEntry::get).collect(Collectors.toUnmodifiableMap(v -> v, v -> {
        int width = v.m_218908_();
        int height = v.m_218909_();
        if (width == 16 && height == 16) {
            return FRAME_SMALL_TEXTURE;
        }
        if (width == 32 && height == 32) {
            return FRAME_MEDIUM_TEXTURE;
        }
        if (width == 48 && height == 32) {
            return FRAME_LARGE_TEXTURE;
        }
        if (width == 16 && height == 32) {
            return FRAME_TALL_TEXTURE;
        }
        if (width == 32 && height == 16) {
            return FRAME_WIDE_TEXTURE;
        }
        throw new IllegalStateException("Unknown painting variant: " + v);
    }));
    private final Map<PaintingVariant, ModelPart> modelByVariant;

    public FancyPaintingRenderer(EntityRendererProvider.Context context) {
        super(context);
        ModelPart small = context.m_174023_(FancyPaintingModel.LAYER_LOCATION_SMALL).m_171324_("main");
        ModelPart medium = context.m_174023_(FancyPaintingModel.LAYER_LOCATION_MEDIUM).m_171324_("main");
        ModelPart large = context.m_174023_(FancyPaintingModel.LAYER_LOCATION_LARGE).m_171324_("main");
        ModelPart tall = context.m_174023_(FancyPaintingModel.LAYER_LOCATION_TALL).m_171324_("main");
        ModelPart wide = context.m_174023_(FancyPaintingModel.LAYER_LOCATION_WIDE).m_171324_("main");
        this.modelByVariant = ModPaintingVariants.PAINTING_VARIANTS.stream().map(RegistryEntry::get).collect(Collectors.toUnmodifiableMap(v -> v, v -> {
            int width = v.m_218908_();
            int height = v.m_218909_();
            if (width == 16 && height == 16) {
                return small;
            }
            if (width == 32 && height == 32) {
                return medium;
            }
            if (width == 48 && height == 32) {
                return large;
            }
            if (width == 16 && height == 32) {
                return tall;
            }
            if (width == 32 && height == 16) {
                return wide;
            }
            throw new IllegalStateException("Unknown painting variant: " + v);
        }));
    }

    public void render(FancyPainting entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        PaintingVariant variant = (PaintingVariant)entity.m_28554_().m_203334_();
        Direction direction = entity.m_6350_();
        VertexConsumer frameVertex = buffer.m_6299_(RenderType.m_110446_((ResourceLocation)FRAME_TEXTURES_BY_VARIANT.get(variant)));
        int width = variant.m_218908_();
        int height = variant.m_218909_();
        try (CloseablePoseStack ignored = new CloseablePoseStack(poseStack);){
            poseStack.m_85841_(0.8f, 0.8f, 0.8f);
            poseStack.m_252781_(Axis.f_252392_.m_252977_(direction.m_122435_()));
            poseStack.m_252880_(0.0f, 0.875f, 0.46125f);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
            this.modelByVariant.get(variant).m_104301_(poseStack, frameVertex, packedLight, OverlayTexture.f_118083_);
            VertexConsumer paintingVertex = buffer.m_6299_(RenderType.m_110446_((ResourceLocation)this.getTextureLocation(entity)));
            poseStack.m_85837_((double)((float)width / 2.0f / -16.0f), -0.125 + 0.5 * (double)((float)(32 - height) / 16.0f), 0.46125);
            poseStack.m_85841_((float)width / 16.0f, (float)height / 16.0f, 1.0f);
            FancyPaintingRenderer.renderPainting(poseStack, paintingVertex, direction, packedLight);
        }
    }

    private static void renderPainting(PoseStack poseStack, VertexConsumer consumer, Direction dir, int light) {
        Vec3i normal = dir.m_122436_();
        consumer.m_252986_(poseStack.m_85850_().m_252922_(), 0.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(poseStack.m_85850_().m_252943_(), (float)normal.m_123341_(), (float)normal.m_123342_(), (float)normal.m_123343_()).m_5752_();
        consumer.m_252986_(poseStack.m_85850_().m_252922_(), 0.0f, 1.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(poseStack.m_85850_().m_252943_(), (float)normal.m_123341_(), (float)normal.m_123342_(), (float)normal.m_123343_()).m_5752_();
        consumer.m_252986_(poseStack.m_85850_().m_252922_(), 1.0f, 1.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(poseStack.m_85850_().m_252943_(), (float)normal.m_123341_(), (float)normal.m_123342_(), (float)normal.m_123343_()).m_5752_();
        consumer.m_252986_(poseStack.m_85850_().m_252922_(), 1.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(poseStack.m_85850_().m_252943_(), (float)normal.m_123341_(), (float)normal.m_123342_(), (float)normal.m_123343_()).m_5752_();
    }

    @NotNull
    public ResourceLocation getTextureLocation(FancyPainting entity) {
        return PAINTING_TEXTURES_BY_VARIANT.get(entity.m_28554_().m_203334_());
    }
}

