/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.handcrafted.common.blocks.trims;

import earth.terrarium.handcrafted.common.blocks.base.Hammerable;
import earth.terrarium.handcrafted.common.blocks.base.properties.TrimProperty;
import earth.terrarium.handcrafted.common.constants.ConstantComponents;
import earth.terrarium.handcrafted.common.registry.ModSoundEvents;
import earth.terrarium.handcrafted.common.utils.TooltipUtils;
import java.util.List;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
public class PillarTrimBlock
extends FaceAttachedHorizontalDirectionalBlock
implements Hammerable,
SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final IntegerProperty TYPE = IntegerProperty.m_61631_((String)"type", (int)1, (int)2);
    public static final EnumProperty<TrimProperty> SHAPE = EnumProperty.m_61587_((String)"trim", TrimProperty.class);
    public static final VoxelShape NORMAL_NORTH_SHAPE = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)4.0, (double)0.0, (double)8.0, (double)12.0, (double)16.0, (double)12.0), (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0), (BooleanOp)BooleanOp.f_82695_);
    public static final VoxelShape NORMAL_EAST_SHAPE = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)8.0, (double)16.0, (double)12.0), (BooleanOp)BooleanOp.f_82695_);
    public static final VoxelShape NORMAL_SOUTH_SHAPE = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0), (VoxelShape)Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)8.0), (BooleanOp)BooleanOp.f_82695_);
    public static final VoxelShape NORMAL_WEST_SHAPE = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)8.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0), (BooleanOp)BooleanOp.f_82695_);
    public static final VoxelShape NORMAL_UP_X_AXIS_SHAPE = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)0.0, (double)8.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0), (BooleanOp)BooleanOp.f_82695_);
    public static final VoxelShape NORMAL_UP_Z_AXIS_SHAPE = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)4.0, (double)8.0, (double)0.0, (double)12.0, (double)12.0, (double)16.0), (BooleanOp)BooleanOp.f_82695_);
    public static final VoxelShape NORMAL_DOWN_X_AXIS_SHAPE = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), (VoxelShape)Block.m_49796_((double)0.0, (double)4.0, (double)4.0, (double)16.0, (double)8.0, (double)12.0), (BooleanOp)BooleanOp.f_82695_);
    public static final VoxelShape NORMAL_DOWN_Z_AXIS_SHAPE = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), (VoxelShape)Block.m_49796_((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)8.0, (double)16.0), (BooleanOp)BooleanOp.f_82695_);
    public static final VoxelShape THICC_NORTH_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape THICC_EAST_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0);
    public static final VoxelShape THICC_SOUTH_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    public static final VoxelShape THICC_WEST_SHAPE = Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape THICC_UP_SHAPE = Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape THICC_DOWN_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    public static final VoxelShape THIN_NORTH_SHAPE = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)16.0, (double)12.0), (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0), (BooleanOp)BooleanOp.f_82695_);
    public static final VoxelShape THIN_EAST_SHAPE = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)4.0, (double)0.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0), (BooleanOp)BooleanOp.f_82695_);
    public static final VoxelShape THIN_SOUTH_SHAPE = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0), (VoxelShape)Block.m_49796_((double)6.0, (double)0.0, (double)4.0, (double)10.0, (double)16.0, (double)6.0), (BooleanOp)BooleanOp.f_82695_);
    public static final VoxelShape THIN_WEST_SHAPE = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)10.0, (double)0.0, (double)6.0, (double)12.0, (double)16.0, (double)10.0), (BooleanOp)BooleanOp.f_82695_);
    public static final VoxelShape THIN_UP_X_AXIS_SHAPE = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)0.0, (double)10.0, (double)6.0, (double)16.0, (double)12.0, (double)10.0), (BooleanOp)BooleanOp.f_82695_);
    public static final VoxelShape THIN_UP_Z_AXIS_SHAPE = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)6.0, (double)10.0, (double)0.0, (double)10.0, (double)12.0, (double)16.0), (BooleanOp)BooleanOp.f_82695_);
    public static final VoxelShape THIN_DOWN_X_AXIS_SHAPE = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), (VoxelShape)Block.m_49796_((double)0.0, (double)4.0, (double)6.0, (double)16.0, (double)6.0, (double)10.0), (BooleanOp)BooleanOp.f_82695_);
    public static final VoxelShape THIN_DOWN_Z_AXIS_SHAPE = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), (VoxelShape)Block.m_49796_((double)6.0, (double)4.0, (double)0.0, (double)10.0, (double)6.0, (double)16.0), (BooleanOp)BooleanOp.f_82695_);
    private final boolean wood;

    public PillarTrimBlock(BlockBehaviour.Properties properties, boolean wood) {
        super(properties);
        this.wood = wood;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)TYPE, (Comparable)Integer.valueOf(1))).m_61124_(SHAPE, (Comparable)((Object)TrimProperty.NORMAL))).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)f_53179_, (Comparable)AttachFace.WALL)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, f_53179_, TYPE, SHAPE, WATERLOGGED});
    }

    public VoxelShape m_5940_(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return switch ((TrimProperty)((Object)state.m_61143_(SHAPE))) {
            default -> throw new IncompatibleClassChangeError();
            case TrimProperty.NORMAL -> {
                switch ((AttachFace)state.m_61143_((Property)f_53179_)) {
                    case FLOOR: {
                        if (((Direction)state.m_61143_((Property)f_54117_)).m_122434_() == Direction.Axis.X) {
                            yield NORMAL_DOWN_X_AXIS_SHAPE;
                        }
                        yield NORMAL_DOWN_Z_AXIS_SHAPE;
                    }
                    case CEILING: {
                        if (((Direction)state.m_61143_((Property)f_54117_)).m_122434_() == Direction.Axis.X) {
                            yield NORMAL_UP_X_AXIS_SHAPE;
                        }
                        yield NORMAL_UP_Z_AXIS_SHAPE;
                    }
                }
                switch ((Direction)state.m_61143_((Property)f_54117_)) {
                    case EAST: {
                        yield NORMAL_EAST_SHAPE;
                    }
                    case SOUTH: {
                        yield NORMAL_SOUTH_SHAPE;
                    }
                    case WEST: {
                        yield NORMAL_WEST_SHAPE;
                    }
                }
                yield NORMAL_NORTH_SHAPE;
            }
            case TrimProperty.THICC -> {
                switch ((AttachFace)state.m_61143_((Property)f_53179_)) {
                    case FLOOR: {
                        yield THICC_DOWN_SHAPE;
                    }
                    case CEILING: {
                        yield THICC_UP_SHAPE;
                    }
                }
                switch ((Direction)state.m_61143_((Property)f_54117_)) {
                    case EAST: {
                        yield THICC_EAST_SHAPE;
                    }
                    case SOUTH: {
                        yield THICC_SOUTH_SHAPE;
                    }
                    case WEST: {
                        yield THICC_WEST_SHAPE;
                    }
                }
                yield THICC_NORTH_SHAPE;
            }
            case TrimProperty.THIN -> {
                switch ((AttachFace)state.m_61143_((Property)f_53179_)) {
                    case FLOOR: {
                        if (((Direction)state.m_61143_((Property)f_54117_)).m_122434_() == Direction.Axis.X) {
                            yield THIN_DOWN_X_AXIS_SHAPE;
                        }
                        yield THIN_DOWN_Z_AXIS_SHAPE;
                    }
                    case CEILING: {
                        if (((Direction)state.m_61143_((Property)f_54117_)).m_122434_() == Direction.Axis.X) {
                            yield THIN_UP_X_AXIS_SHAPE;
                        }
                        yield THIN_UP_Z_AXIS_SHAPE;
                    }
                }
                switch ((Direction)state.m_61143_((Property)f_54117_)) {
                    case EAST: {
                        yield THIN_EAST_SHAPE;
                    }
                    case SOUTH: {
                        yield THIN_SOUTH_SHAPE;
                    }
                    case WEST: {
                        yield THIN_WEST_SHAPE;
                    }
                }
                yield THIN_NORTH_SHAPE;
            }
        };
    }

    @Override
    public void onHammer(Level level, BlockPos pos, BlockState state, Direction side, Player user, Vec3 hitPos) {
        if (user.m_6144_()) {
            level.m_46597_(pos, (BlockState)state.m_61122_((Property)TYPE));
        } else {
            level.m_46597_(pos, (BlockState)state.m_61122_(SHAPE));
        }
        level.m_5594_(null, pos, this.wood ? (SoundEvent)ModSoundEvents.HAMMER_WOOD.get() : (SoundEvent)ModSoundEvents.HAMMER_STONE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public boolean isWood() {
        return this.wood;
    }

    @NotNull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @NotNull
    public BlockState m_7417_(BlockState state, @NotNull Direction direction, @NotNull BlockState neighborState, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        FluidState fluidState = ctx.m_43725_().m_6425_(ctx.m_8083_());
        BlockState placementState = super.m_5573_(ctx);
        if (placementState == null) {
            return null;
        }
        return (BlockState)placementState.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_().equals(Fluids.f_76193_)));
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        TooltipUtils.addDescriptionComponent(tooltip, ConstantComponents.HAMMER_USE_SHAPE, ConstantComponents.HAMMER_USE_LOOK_SHIFT);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return true;
    }
}

