/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.world;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yungnickyoung.minecraft.bettermineshafts.BetterMineshaftsCommon;
import com.yungnickyoung.minecraft.bettermineshafts.module.StructureTypeModule;
import com.yungnickyoung.minecraft.bettermineshafts.world.config.BetterMineshaftConfiguration;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.BetterMineshaftPiece;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.VerticalEntrance;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;

public class BetterMineshaftStructure
extends Structure {
    public static final Codec<BetterMineshaftStructure> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)BetterMineshaftStructure.m_226567_((RecordCodecBuilder.Instance)builder), (App)BetterMineshaftConfiguration.CODEC.fieldOf("config").forGetter(structure -> structure.config)).apply((Applicative)builder, BetterMineshaftStructure::new));
    private final BetterMineshaftConfiguration config;

    public BetterMineshaftStructure(Structure.StructureSettings settings, BetterMineshaftConfiguration config) {
        super(settings);
        this.config = config;
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        context.f_226626_().m_188500_();
        ChunkPos chunkPos = context.f_226628_();
        int y = context.f_226626_().m_188503_(BetterMineshaftsCommon.CONFIG.maxY - BetterMineshaftsCommon.CONFIG.minY + 1) + BetterMineshaftsCommon.CONFIG.minY;
        BlockPos.MutableBlockPos startingPos = new BlockPos.MutableBlockPos(chunkPos.m_151382_(3), y, chunkPos.m_151391_(3));
        StructurePiecesBuilder structurePiecesBuilder = new StructurePiecesBuilder();
        this.generatePieces(structurePiecesBuilder, context);
        return Optional.of(new Structure.GenerationStub((BlockPos)startingPos, Either.right((Object)structurePiecesBuilder)));
    }

    public StructureType<?> m_213658_() {
        return StructureTypeModule.BETTER_MINESHAFT;
    }

    private void generatePieces(StructurePiecesBuilder structurePiecesBuilder, Structure.GenerationContext context) {
        WorldgenRandom rand = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        rand.m_190068_(context.f_226627_(), context.f_226628_().f_45578_, context.f_226628_().f_45579_);
        Direction direction = Direction.Plane.HORIZONTAL.m_235690_((RandomSource)rand);
        int y = context.f_226626_().m_188503_(BetterMineshaftsCommon.CONFIG.maxY - BetterMineshaftsCommon.CONFIG.minY + 1) + BetterMineshaftsCommon.CONFIG.minY;
        BlockPos.MutableBlockPos startingPos = new BlockPos.MutableBlockPos(context.f_226628_().m_151382_(3), y, context.f_226628_().m_151391_(3));
        VerticalEntrance entryPoint = new VerticalEntrance(-1, startingPos, direction, this.config, context.f_226629_().m_151558_());
        structurePiecesBuilder.m_142679_((StructurePiece)entryPoint);
        ((BetterMineshaftPiece)entryPoint).m_214092_(entryPoint, (StructurePieceAccessor)structurePiecesBuilder, (RandomSource)context.f_226626_());
    }
}

