/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.controller;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.EmptyHandler;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.controller.IControllableStorage;
import net.p3pp3rf1y.sophisticatedcore.controller.IControllerBoundable;
import net.p3pp3rf1y.sophisticatedcore.controller.ILinkable;
import net.p3pp3rf1y.sophisticatedcore.inventory.CachedFailedInsertInventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.IItemHandlerSimpleInserter;
import net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import org.apache.logging.log4j.util.Supplier;

public abstract class ControllerBlockEntityBase
extends BlockEntity
implements IItemHandlerSimpleInserter {
    public static final int SEARCH_RANGE = 15;
    private List<BlockPos> storagePositions = new ArrayList<BlockPos>();
    private List<Integer> baseIndexes = new ArrayList<Integer>();
    private int totalSlots = 0;
    private final Map<ItemStackKey, Set<BlockPos>> stackStorages = new HashMap<ItemStackKey, Set<BlockPos>>();
    private final Map<BlockPos, Set<ItemStackKey>> storageStacks = new HashMap<BlockPos, Set<ItemStackKey>>();
    private final Map<Item, Set<ItemStackKey>> itemStackKeys = new HashMap<Item, Set<ItemStackKey>>();
    private final Comparator<BlockPos> distanceComparator = Comparator.comparingDouble(p -> p.m_123331_((Vec3i)this.m_58899_())).thenComparing(Comparator.naturalOrder());
    private final Set<BlockPos> emptySlotsStorages = new TreeSet<BlockPos>(this.distanceComparator);
    private final Map<Item, Set<BlockPos>> memorizedItemStorages = new HashMap<Item, Set<BlockPos>>();
    private final Map<BlockPos, Set<Item>> storageMemorizedItems = new HashMap<BlockPos, Set<Item>>();
    private final Map<Integer, Set<BlockPos>> memorizedStackStorages = new HashMap<Integer, Set<BlockPos>>();
    private final Map<BlockPos, Set<Integer>> storageMemorizedStacks = new HashMap<BlockPos, Set<Integer>>();
    private final Map<Item, Set<BlockPos>> filterItemStorages = new HashMap<Item, Set<BlockPos>>();
    private final Map<BlockPos, Set<Item>> storageFilterItems = new HashMap<BlockPos, Set<Item>>();
    private Set<BlockPos> linkedBlocks = new TreeSet<BlockPos>(this.distanceComparator);
    private Set<BlockPos> connectingBlocks = new TreeSet<BlockPos>(this.distanceComparator);
    private Set<BlockPos> nonConnectingBlocks = new TreeSet<BlockPos>(this.distanceComparator);
    @Nullable
    private LazyOptional<IItemHandler> itemHandlerCap;
    @Nullable
    private LazyOptional<IItemHandler> noSideItemHandlerCap;

    public boolean addLinkedBlock(BlockPos linkedPos) {
        if (this.f_58857_ != null && !this.f_58857_.m_5776_() && this.isWithinRange(linkedPos) && !this.linkedBlocks.contains(linkedPos) && !this.storagePositions.contains(linkedPos)) {
            this.linkedBlocks.add(linkedPos);
            this.m_6596_();
            WorldHelper.getBlockEntity((BlockGetter)this.f_58857_, linkedPos, ILinkable.class).ifPresent(l -> {
                if (l.connectLinkedSelf()) {
                    LinkedHashSet<BlockPos> positionsToCheck = new LinkedHashSet<BlockPos>();
                    positionsToCheck.add(linkedPos);
                    this.searchAndAddBoundables(positionsToCheck, true);
                }
                this.searchAndAddBoundables(new LinkedHashSet<BlockPos>(l.getConnectablePositions()), false);
            });
            WorldHelper.notifyBlockUpdate(this);
            return true;
        }
        return false;
    }

    public void removeLinkedBlock(BlockPos storageBlockPos) {
        this.linkedBlocks.remove(storageBlockPos);
        this.m_6596_();
        this.verifyStoragesConnected();
        WorldHelper.notifyBlockUpdate(this);
    }

    public void onLoad() {
        super.onLoad();
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            this.stackStorages.clear();
            this.storageStacks.clear();
            this.itemStackKeys.clear();
            this.emptySlotsStorages.clear();
            this.storagePositions.forEach(this::addStorageStacksAndRegisterListeners);
        }
    }

    public boolean isStorageConnected(BlockPos storagePos) {
        return this.storagePositions.contains(storagePos);
    }

    public void searchAndAddBoundables() {
        HashSet<BlockPos> positionsToCheck = new HashSet<BlockPos>();
        for (Direction dir : Direction.values()) {
            positionsToCheck.add(this.m_58899_().m_121955_(dir.m_122436_()));
        }
        this.searchAndAddBoundables(positionsToCheck, false);
    }

    public void changeSlots(BlockPos storagePos, int newSlots, boolean hasEmptySlots) {
        this.updateBaseIndexesAndTotalSlots(storagePos, newSlots);
        this.updateEmptySlots(storagePos, hasEmptySlots);
    }

    public void updateEmptySlots(BlockPos storagePos, boolean hasEmptySlots) {
        if (this.emptySlotsStorages.contains(storagePos) && !hasEmptySlots) {
            this.emptySlotsStorages.remove(storagePos);
        } else if (!this.emptySlotsStorages.contains(storagePos) && hasEmptySlots) {
            this.emptySlotsStorages.add(storagePos);
        }
    }

    private void updateBaseIndexesAndTotalSlots(BlockPos storagePos, int newSlots) {
        int index = this.storagePositions.indexOf(storagePos);
        int originalSlots = this.getStorageSlots(index);
        int diff = newSlots - originalSlots;
        for (int i = index; i < this.baseIndexes.size(); ++i) {
            this.baseIndexes.set(i, this.baseIndexes.get(i) + diff);
        }
        this.totalSlots += diff;
        WorldHelper.notifyBlockUpdate(this);
    }

    private int getStorageSlots(int index) {
        int previousBaseIndex = index == 0 ? 0 : this.baseIndexes.get(index - 1);
        return this.baseIndexes.get(index) - previousBaseIndex;
    }

    public int getSlots(int storageIndex) {
        if (storageIndex < 0 || storageIndex >= this.baseIndexes.size()) {
            return 0;
        }
        return this.getStorageSlots(storageIndex);
    }

    private void searchAndAddBoundables(Set<BlockPos> positionsToCheck, boolean addingLinkedSelf) {
        HashSet positionsChecked = new HashSet();
        boolean first = true;
        while (!positionsToCheck.isEmpty()) {
            Iterator<BlockPos> it = positionsToCheck.iterator();
            BlockPos posToCheck = it.next();
            it.remove();
            boolean finalFirst = first;
            WorldHelper.getLoadedBlockEntity(this.f_58857_, posToCheck, IControllerBoundable.class).ifPresentOrElse(boundable -> this.tryToConnectStorageAndAddPositionsToCheckAround(positionsToCheck, addingLinkedSelf, positionsChecked, posToCheck, finalFirst, (IControllerBoundable)boundable), () -> positionsChecked.add(posToCheck));
            first = false;
        }
    }

    private void tryToConnectStorageAndAddPositionsToCheckAround(Set<BlockPos> positionsToCheck, boolean addingLinkedSelf, Set<BlockPos> positionsChecked, BlockPos posToCheck, boolean finalFirst, IControllerBoundable boundable) {
        if (boundable.canBeConnected() || addingLinkedSelf && finalFirst) {
            IControllableStorage storage;
            ILinkable linkable;
            if (boundable instanceof ILinkable && (linkable = (ILinkable)boundable).isLinked() && (!addingLinkedSelf || !finalFirst)) {
                this.linkedBlocks.remove(posToCheck);
                linkable.setNotLinked();
            } else if (boundable instanceof IControllableStorage && (storage = (IControllableStorage)boundable).hasStorageData()) {
                this.addStorageData(posToCheck);
            } else {
                if (boundable.canConnectStorages()) {
                    this.connectingBlocks.add(posToCheck);
                } else {
                    this.nonConnectingBlocks.add(posToCheck);
                }
                boundable.registerController(this);
            }
            if (boundable.canConnectStorages()) {
                this.addUncheckedPositionsAround(positionsToCheck, positionsChecked, posToCheck);
            }
        }
    }

    private void addUncheckedPositionsAround(Set<BlockPos> positionsToCheck, Set<BlockPos> positionsChecked, BlockPos currentPos) {
        for (Direction dir : Direction.values()) {
            BlockPos pos = currentPos.m_121955_(dir.m_122436_());
            if (positionsChecked.contains(pos) || (this.storagePositions.contains(pos) || this.connectingBlocks.contains(pos) || this.nonConnectingBlocks.contains(pos)) && !this.linkedBlocks.contains(pos) || !this.isWithinRange(pos)) continue;
            positionsToCheck.add(pos);
        }
    }

    private boolean isWithinRange(BlockPos pos) {
        return Math.abs(pos.m_123341_() - this.m_58899_().m_123341_()) <= 15 && Math.abs(pos.m_123342_() - this.m_58899_().m_123342_()) <= 15 && Math.abs(pos.m_123343_() - this.m_58899_().m_123343_()) <= 15;
    }

    public void addStorage(BlockPos storagePos) {
        if (this.storagePositions.contains(storagePos)) {
            this.removeStorageInventoryData(storagePos);
        }
        if (this.isWithinRange(storagePos)) {
            LinkedHashSet<BlockPos> positionsToCheck = new LinkedHashSet<BlockPos>();
            positionsToCheck.add(storagePos);
            this.searchAndAddBoundables(positionsToCheck, false);
        }
    }

    private void addStorageData(BlockPos storagePos) {
        this.storagePositions.add(storagePos);
        this.totalSlots += this.getInventoryHandlerValueFromHolder(storagePos, IItemHandler::getSlots).orElse(0).intValue();
        this.baseIndexes.add(this.totalSlots);
        this.addStorageStacksAndRegisterListeners(storagePos);
        this.m_6596_();
        WorldHelper.notifyBlockUpdate(this);
    }

    public void addStorageStacksAndRegisterListeners(BlockPos storagePos) {
        WorldHelper.getLoadedBlockEntity(this.f_58857_, storagePos, IControllableStorage.class).ifPresent(storage -> {
            ITrackedContentsItemHandler handler = storage.getStorageWrapper().getInventoryForInputOutput();
            handler.getTrackedStacks().forEach(k -> this.addStorageStack(storagePos, (ItemStackKey)k));
            if (handler.hasEmptySlots()) {
                this.emptySlotsStorages.add(storagePos);
            }
            MemorySettingsCategory memorySettings = storage.getStorageWrapper().getSettingsHandler().getTypeCategory(MemorySettingsCategory.class);
            memorySettings.getFilterItemSlots().keySet().forEach(i -> this.addStorageMemorizedItem(storagePos, (Item)i));
            memorySettings.getFilterStackSlots().keySet().forEach(stackHash -> this.addStorageMemorizedStack(storagePos, (int)stackHash));
            this.setStorageFilterItems(storagePos, storage.getStorageWrapper().getInventoryHandler().getFilterItems());
            storage.registerController(this);
        });
    }

    public void addStorageMemorizedItem(BlockPos storagePos, Item item) {
        this.memorizedItemStorages.computeIfAbsent(item, stackKey -> new LinkedHashSet()).add(storagePos);
        this.storageMemorizedItems.computeIfAbsent(storagePos, pos -> new HashSet()).add(item);
    }

    public void addStorageMemorizedStack(BlockPos storagePos, int stackHash) {
        this.memorizedStackStorages.computeIfAbsent(stackHash, stackKey -> new LinkedHashSet()).add(storagePos);
        this.storageMemorizedStacks.computeIfAbsent(storagePos, pos -> new HashSet()).add(stackHash);
    }

    public void removeStorageMemorizedItem(BlockPos storagePos, Item item) {
        this.memorizedItemStorages.computeIfPresent(item, (i, positions) -> {
            positions.remove(storagePos);
            return positions;
        });
        if (this.memorizedItemStorages.containsKey(item) && this.memorizedItemStorages.get(item).isEmpty()) {
            this.memorizedItemStorages.remove(item);
        }
        this.storageMemorizedItems.remove(storagePos);
    }

    public void removeStorageMemorizedStack(BlockPos storagePos, int stackHash) {
        this.memorizedStackStorages.computeIfPresent(stackHash, (i, positions) -> {
            positions.remove(storagePos);
            return positions;
        });
        if (this.memorizedStackStorages.containsKey(stackHash) && this.memorizedStackStorages.get(stackHash).isEmpty()) {
            this.memorizedStackStorages.remove(stackHash);
        }
        this.storageMemorizedStacks.remove(storagePos);
    }

    private <T> Optional<T> getInventoryHandlerValueFromHolder(BlockPos storagePos, Function<IItemHandlerSimpleInserter, T> valueGetter) {
        return this.getWrapperValueFromHolder(storagePos, wrapper -> valueGetter.apply(wrapper.getInventoryForInputOutput()));
    }

    private <T> Optional<T> getWrapperValueFromHolder(BlockPos storagePos, Function<IStorageWrapper, T> valueGetter) {
        return WorldHelper.getLoadedBlockEntity(this.f_58857_, storagePos, IControllableStorage.class).map(holder -> valueGetter.apply(holder.getStorageWrapper()));
    }

    public void addStorageStack(BlockPos storagePos, ItemStackKey itemStackKey) {
        this.stackStorages.computeIfAbsent(itemStackKey, stackKey -> new LinkedHashSet()).add(storagePos);
        this.storageStacks.computeIfAbsent(storagePos, pos -> new HashSet()).add(itemStackKey);
        this.itemStackKeys.computeIfAbsent(itemStackKey.getStack().m_41720_(), item -> new LinkedHashSet()).add(itemStackKey);
    }

    public void removeStorageStack(BlockPos storagePos, ItemStackKey stackKey) {
        this.stackStorages.computeIfPresent(stackKey, (sk, positions) -> {
            positions.remove(storagePos);
            return positions;
        });
        if (this.stackStorages.containsKey(stackKey) && this.stackStorages.get(stackKey).isEmpty()) {
            this.stackStorages.remove(stackKey);
            this.itemStackKeys.computeIfPresent(stackKey.getStack().m_41720_(), (i, stackKeys) -> {
                stackKeys.remove(stackKey);
                return stackKeys;
            });
            if (this.itemStackKeys.containsKey(stackKey.getStack().m_41720_()) && this.itemStackKeys.get(stackKey.getStack().m_41720_()).isEmpty()) {
                this.itemStackKeys.remove(stackKey.getStack().m_41720_());
            }
        }
        this.storageStacks.computeIfPresent(storagePos, (pos, stackKeys) -> {
            stackKeys.remove(stackKey);
            return stackKeys;
        });
        if (this.storageStacks.containsKey(storagePos) && this.storageStacks.get(storagePos).isEmpty()) {
            this.storageStacks.remove(storagePos);
        }
    }

    public void removeStorageStacks(BlockPos storagePos) {
        this.storageStacks.computeIfPresent(storagePos, (pos, stackKeys) -> {
            stackKeys.forEach(stackKey -> {
                Set<BlockPos> storages = this.stackStorages.get(stackKey);
                if (storages != null) {
                    storages.remove(storagePos);
                    if (storages.isEmpty()) {
                        this.stackStorages.remove(stackKey);
                        this.itemStackKeys.computeIfPresent(stackKey.getStack().m_41720_(), (i, positions) -> {
                            positions.remove(stackKey);
                            return positions;
                        });
                        if (this.itemStackKeys.containsKey(stackKey.getStack().m_41720_()) && this.itemStackKeys.get(stackKey.getStack().m_41720_()).isEmpty()) {
                            this.itemStackKeys.remove(stackKey.getStack().m_41720_());
                        }
                    }
                }
            });
            return stackKeys;
        });
        this.storageStacks.remove(storagePos);
    }

    protected boolean hasItem(Item item) {
        return this.itemStackKeys.containsKey(item);
    }

    protected boolean isMemorizedItem(ItemStack stack) {
        return this.memorizedItemStorages.containsKey(stack.m_41720_()) || this.memorizedStackStorages.containsKey(ItemStackKey.getHashCode(stack));
    }

    protected boolean isFilterItem(Item item) {
        return this.filterItemStorages.containsKey(item);
    }

    public void removeStorage(BlockPos storagePos) {
        this.removeConnectingBlock(storagePos);
        this.removeStorageInventoryDataAndUnregisterController(storagePos);
        this.verifyStoragesConnected();
    }

    private void removeConnectingBlock(BlockPos storagePos) {
        if (this.connectingBlocks.remove(storagePos)) {
            WorldHelper.getLoadedBlockEntity(this.f_58857_, storagePos, IControllableStorage.class).ifPresent(IControllableStorage::unregisterController);
        }
    }

    public void removeNonConnectingBlock(BlockPos storagePos) {
        if (this.nonConnectingBlocks.remove(storagePos)) {
            WorldHelper.getLoadedBlockEntity(this.f_58857_, storagePos, IControllerBoundable.class).ifPresent(IControllerBoundable::unregisterController);
        }
    }

    private void removeStorageInventoryDataAndUnregisterController(BlockPos storagePos) {
        if (!this.storagePositions.contains(storagePos)) {
            return;
        }
        this.removeStorageInventoryData(storagePos);
        this.linkedBlocks.remove(storagePos);
        WorldHelper.getLoadedBlockEntity(this.f_58857_, storagePos, IControllableStorage.class).ifPresent(IControllableStorage::unregisterController);
        this.m_6596_();
        WorldHelper.notifyBlockUpdate(this);
    }

    private void removeStorageInventoryData(BlockPos storagePos) {
        int idx = this.storagePositions.indexOf(storagePos);
        this.totalSlots -= this.getStorageSlots(idx);
        this.removeStorageStacks(storagePos);
        this.removeStorageMemorizedItems(storagePos);
        this.removeStorageMemorizedStacks(storagePos);
        this.removeStorageWithEmptySlots(storagePos);
        this.removeStorageFilterItems(storagePos);
        this.storagePositions.remove(idx);
        this.removeBaseIndexAt(idx);
    }

    private void removeStorageFilterItems(BlockPos storagePos) {
        this.storageFilterItems.computeIfPresent(storagePos, (pos, items) -> {
            items.forEach(item -> {
                Set<BlockPos> storages = this.filterItemStorages.get(item);
                if (storages != null) {
                    storages.remove(storagePos);
                    if (storages.isEmpty()) {
                        this.filterItemStorages.remove(item);
                    }
                }
            });
            return items;
        });
        this.storageFilterItems.remove(storagePos);
    }

    private void removeStorageMemorizedItems(BlockPos storagePos) {
        this.storageMemorizedItems.computeIfPresent(storagePos, (pos, items) -> {
            items.forEach(item -> {
                Set<BlockPos> storages = this.memorizedItemStorages.get(item);
                if (storages != null) {
                    storages.remove(storagePos);
                    if (storages.isEmpty()) {
                        this.memorizedItemStorages.remove(item);
                    }
                }
            });
            return items;
        });
        this.storageMemorizedItems.remove(storagePos);
    }

    private void removeStorageMemorizedStacks(BlockPos storagePos) {
        this.storageMemorizedStacks.computeIfPresent(storagePos, (pos, items) -> {
            items.forEach(stackHash -> {
                Set<BlockPos> storages = this.memorizedStackStorages.get(stackHash);
                if (storages != null) {
                    storages.remove(storagePos);
                    if (storages.isEmpty()) {
                        this.memorizedStackStorages.remove(stackHash);
                    }
                }
            });
            return items;
        });
        this.storageMemorizedStacks.remove(storagePos);
    }

    private void verifyStoragesConnected() {
        HashSet<BlockPos> toVerify = new HashSet<BlockPos>(this.storagePositions);
        toVerify.addAll(this.connectingBlocks);
        toVerify.addAll(this.nonConnectingBlocks);
        HashSet<BlockPos> positionsToCheck = new HashSet<BlockPos>();
        for (Direction dir : Direction.values()) {
            BlockPos offsetPos = this.m_58899_().m_121955_(dir.m_122436_());
            if (!toVerify.contains(offsetPos)) continue;
            positionsToCheck.add(offsetPos);
        }
        HashSet<BlockPos> positionsChecked = new HashSet<BlockPos>();
        this.verifyConnected(toVerify, positionsToCheck, positionsChecked);
        this.linkedBlocks.forEach(linkedPosition -> WorldHelper.getBlockEntity((BlockGetter)this.m_58904_(), linkedPosition, ILinkable.class).ifPresent(l -> {
            if (l.connectLinkedSelf() && toVerify.contains(linkedPosition)) {
                positionsToCheck.add((BlockPos)linkedPosition);
            }
            l.getConnectablePositions().forEach(p -> {
                if (toVerify.contains(p)) {
                    positionsToCheck.add((BlockPos)p);
                }
            });
        }));
        this.verifyConnected(toVerify, positionsToCheck, positionsChecked);
        toVerify.forEach(storagePos -> {
            this.removeConnectingBlock((BlockPos)storagePos);
            this.removeNonConnectingBlock((BlockPos)storagePos);
            this.removeStorageInventoryDataAndUnregisterController((BlockPos)storagePos);
        });
    }

    private void verifyConnected(HashSet<BlockPos> toVerify, Set<BlockPos> positionsToCheck, Set<BlockPos> positionsChecked) {
        while (!positionsToCheck.isEmpty()) {
            Iterator<BlockPos> it = positionsToCheck.iterator();
            BlockPos posToCheck = it.next();
            it.remove();
            positionsChecked.add(posToCheck);
            WorldHelper.getLoadedBlockEntity(this.f_58857_, posToCheck, IControllerBoundable.class).ifPresent(h -> {
                toVerify.remove(posToCheck);
                if (h.canConnectStorages()) {
                    for (Direction dir : Direction.values()) {
                        BlockPos pos = posToCheck.m_121955_(dir.m_122436_());
                        if (positionsChecked.contains(pos) || !toVerify.contains(pos)) continue;
                        positionsToCheck.add(pos);
                    }
                }
            });
        }
    }

    private void removeBaseIndexAt(int idx) {
        if (idx >= this.baseIndexes.size()) {
            return;
        }
        int slotsRemoved = this.getStorageSlots(idx);
        this.baseIndexes.remove(idx);
        for (int i = idx; i < this.baseIndexes.size(); ++i) {
            this.baseIndexes.set(i, this.baseIndexes.get(i) - slotsRemoved);
        }
    }

    protected ControllerBlockEntityBase(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                if (this.noSideItemHandlerCap == null) {
                    this.noSideItemHandlerCap = LazyOptional.of(() -> this).cast();
                }
                return this.noSideItemHandlerCap.cast();
            }
            if (this.itemHandlerCap == null) {
                this.itemHandlerCap = LazyOptional.of(() -> new CachedFailedInsertInventoryHandler(() -> this, () -> this.f_58857_ != null ? this.f_58857_.m_46467_() : 0L));
            }
            return this.itemHandlerCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.itemHandlerCap != null) {
            this.itemHandlerCap.invalidate();
            this.itemHandlerCap = null;
        }
        if (this.noSideItemHandlerCap != null) {
            this.noSideItemHandlerCap.invalidate();
            this.noSideItemHandlerCap = null;
        }
    }

    public int getSlots() {
        return this.totalSlots;
    }

    private int getIndexForSlot(int slot) {
        if (slot < 0) {
            return -1;
        }
        for (int i = 0; i < this.baseIndexes.size(); ++i) {
            if (slot - this.baseIndexes.get(i) >= 0) continue;
            return i;
        }
        return -1;
    }

    protected IItemHandlerModifiable getHandlerFromIndex(int index) {
        if (index < 0 || index >= this.storagePositions.size()) {
            return (IItemHandlerModifiable)EmptyHandler.INSTANCE;
        }
        return this.getWrapperValueFromHolder(this.storagePositions.get(index), wrapper -> wrapper.getInventoryForInputOutput()).orElse((IItemHandlerModifiable)EmptyHandler.INSTANCE);
    }

    protected int getSlotFromIndex(int slot, int index) {
        if (index <= 0 || index >= this.baseIndexes.size()) {
            return slot;
        }
        return slot - this.baseIndexes.get(index - 1);
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        if (this.isSlotIndexInvalid(slot)) {
            return ItemStack.f_41583_;
        }
        int handlerIndex = this.getIndexForSlot(slot);
        IItemHandlerModifiable handler = this.getHandlerFromIndex(handlerIndex);
        if (this.validateHandlerSlotIndex((IItemHandler)handler, handlerIndex, slot = this.getSlotFromIndex(slot, handlerIndex), "getStackInSlot")) {
            return handler.getStackInSlot(slot);
        }
        return ItemStack.f_41583_;
    }

    private boolean isSlotIndexInvalid(int slot) {
        return slot < 0 || slot >= this.totalSlots;
    }

    private boolean validateHandlerSlotIndex(IItemHandler handler, int handlerIndex, int slot, String methodName) {
        if (slot >= 0 && slot < handler.getSlots()) {
            return true;
        }
        if (handlerIndex < 0 || handlerIndex >= this.storagePositions.size()) {
            SophisticatedCore.LOGGER.debug("Invalid handler index calculated {} in controller's {} method. If you see many of these messages try replacing controller at {}", new Supplier[]{() -> handlerIndex, () -> methodName, () -> this.m_58899_().m_123344_()});
        } else {
            SophisticatedCore.LOGGER.debug("Invalid slot {} passed into controller's {} method for storage at {}. If you see many of these messages try replacing controller at {}", new Supplier[]{() -> slot, () -> methodName, () -> this.storagePositions.get(handlerIndex).m_123344_(), () -> this.m_58899_().m_123344_()});
        }
        return false;
    }

    @Nonnull
    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (this.isSlotIndexInvalid(slot)) {
            return stack;
        }
        return this.insertItem(stack, simulate, true);
    }

    @Override
    public ItemStack insertItem(ItemStack stack, boolean simulate) {
        return this.insertItem(stack, simulate, true);
    }

    protected ItemStack insertItem(ItemStack stack, boolean simulate, boolean insertIntoAnyEmpty) {
        ItemStackKey stackKey = ItemStackKey.of(stack);
        ItemStack remaining = stack;
        if ((remaining = this.insertIntoStoragesThatMatchStack(remaining, stackKey, simulate)).m_41619_()) {
            return remaining;
        }
        if ((remaining = this.insertIntoStoragesThatMatchItem(remaining, simulate)).m_41619_()) {
            return remaining;
        }
        if (this.memorizedItemStorages.containsKey(stack.m_41720_()) && (remaining = this.insertIntoStorages(this.memorizedItemStorages.get(stack.m_41720_()), remaining, simulate, false)).m_41619_()) {
            return remaining;
        }
        int stackHash = stackKey.hashCode();
        if (this.memorizedStackStorages.containsKey(stackHash) && (remaining = this.insertIntoStorages(this.memorizedStackStorages.get(stackHash), remaining, simulate, false)).m_41619_()) {
            return remaining;
        }
        if (this.filterItemStorages.containsKey(stack.m_41720_()) && (remaining = this.insertIntoStorages(this.filterItemStorages.get(stack.m_41720_()), remaining, simulate, false)).m_41619_()) {
            return remaining;
        }
        return insertIntoAnyEmpty ? this.insertIntoStorages(this.emptySlotsStorages, remaining, simulate, false) : remaining;
    }

    private ItemStack insertIntoStoragesThatMatchStack(ItemStack remaining, ItemStackKey stackKey, boolean simulate) {
        if (this.stackStorages.containsKey(stackKey)) {
            Set<BlockPos> positions = this.stackStorages.get(stackKey);
            remaining = this.insertIntoStorages(positions, remaining, simulate, false);
        }
        return remaining;
    }

    private ItemStack insertIntoStoragesThatMatchItem(ItemStack remaining, boolean simulate) {
        if (!this.emptySlotsStorages.isEmpty() && this.itemStackKeys.containsKey(remaining.m_41720_())) {
            Set<ItemStackKey> matchingStackKeys = this.itemStackKeys.get(remaining.m_41720_());
            if (remaining.m_41613_() > remaining.m_41741_()) {
                matchingStackKeys = new LinkedHashSet<ItemStackKey>(matchingStackKeys);
            }
            for (ItemStackKey key : matchingStackKeys) {
                Set<BlockPos> positions;
                if (!this.stackStorages.containsKey(key) || !(remaining = this.insertIntoStorages(positions = this.stackStorages.get(key), remaining, simulate, true)).m_41619_()) continue;
                return ItemStack.f_41583_;
            }
        }
        return remaining;
    }

    private ItemStack insertIntoStorages(Set<BlockPos> positions, ItemStack stack, boolean simulate, boolean checkHasEmptySlotFirst) {
        ItemStack remaining = stack;
        LinkedHashSet<BlockPos> positionsCopy = new LinkedHashSet<BlockPos>(positions);
        for (BlockPos storagePos : positionsCopy) {
            if (checkHasEmptySlotFirst && !this.emptySlotsStorages.contains(storagePos) || !(remaining = this.insertIntoStorage(storagePos, remaining, simulate)).m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        return remaining;
    }

    private ItemStack insertIntoStorage(BlockPos storagePos, ItemStack remaining, boolean simulate) {
        ItemStack finalRemaining = remaining;
        remaining = this.getInventoryHandlerValueFromHolder(storagePos, ins -> ins.insertItem(finalRemaining, simulate)).orElse(remaining);
        return remaining;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.isSlotIndexInvalid(slot)) {
            return ItemStack.f_41583_;
        }
        int handlerIndex = this.getIndexForSlot(slot);
        IItemHandlerModifiable handler = this.getHandlerFromIndex(handlerIndex);
        if (this.validateHandlerSlotIndex((IItemHandler)handler, handlerIndex, slot = this.getSlotFromIndex(slot, handlerIndex), "extractItem(int slot, int amount, boolean simulate)")) {
            return handler.extractItem(slot, amount, simulate);
        }
        return ItemStack.f_41583_;
    }

    public int getSlotLimit(int slot) {
        int localSlot;
        if (this.isSlotIndexInvalid(slot)) {
            return 0;
        }
        int handlerIndex = this.getIndexForSlot(slot);
        IItemHandlerModifiable handler = this.getHandlerFromIndex(handlerIndex);
        if (this.validateHandlerSlotIndex((IItemHandler)handler, handlerIndex, localSlot = this.getSlotFromIndex(slot, handlerIndex), "getSlotLimit(int slot)")) {
            return handler.getSlotLimit(localSlot);
        }
        return 0;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        int localSlot;
        if (this.isSlotIndexInvalid(slot)) {
            return false;
        }
        int handlerIndex = this.getIndexForSlot(slot);
        IItemHandlerModifiable handler = this.getHandlerFromIndex(handlerIndex);
        if (this.validateHandlerSlotIndex((IItemHandler)handler, handlerIndex, localSlot = this.getSlotFromIndex(slot, handlerIndex), "isItemValid(int slot, ItemStack stack)")) {
            return handler.isItemValid(localSlot, stack);
        }
        return false;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        if (this.isSlotIndexInvalid(slot)) {
            return;
        }
        int handlerIndex = this.getIndexForSlot(slot);
        IItemHandlerModifiable handler = this.getHandlerFromIndex(handlerIndex);
        if (this.validateHandlerSlotIndex((IItemHandler)handler, handlerIndex, slot = this.getSlotFromIndex(slot, handlerIndex), "setStackInSlot(int slot, ItemStack stack)")) {
            handler.setStackInSlot(slot, stack);
        }
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.detachFromStoragesAndUnlinkBlocks();
    }

    public void detachFromStoragesAndUnlinkBlocks() {
        this.storagePositions.forEach(pos -> WorldHelper.getLoadedBlockEntity(this.f_58857_, pos, IControllableStorage.class).ifPresent(IControllableStorage::unregisterController));
        this.connectingBlocks.forEach(pos -> WorldHelper.getLoadedBlockEntity(this.f_58857_, pos, IControllableStorage.class).ifPresent(IControllableStorage::unregisterController));
        this.nonConnectingBlocks.forEach(pos -> WorldHelper.getLoadedBlockEntity(this.f_58857_, pos, IControllerBoundable.class).ifPresent(IControllerBoundable::unregisterController));
        new HashSet<BlockPos>(this.linkedBlocks).forEach(linkedPos -> WorldHelper.getLoadedBlockEntity(this.f_58857_, linkedPos, ILinkable.class).ifPresent(ILinkable::unlinkFromController));
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.saveData(tag);
    }

    private CompoundTag saveData(CompoundTag tag) {
        NBTHelper.putList(tag, "storagePositions", this.storagePositions, p -> LongTag.m_128882_((long)p.m_121878_()));
        NBTHelper.putList(tag, "connectingBlocks", this.connectingBlocks, p -> LongTag.m_128882_((long)p.m_121878_()));
        NBTHelper.putList(tag, "nonConnectingBlocks", this.nonConnectingBlocks, p -> LongTag.m_128882_((long)p.m_121878_()));
        NBTHelper.putList(tag, "linkedBlocks", this.linkedBlocks, p -> LongTag.m_128882_((long)p.m_121878_()));
        NBTHelper.putList(tag, "baseIndexes", this.baseIndexes, IntTag::m_128679_);
        tag.m_128405_("totalSlots", this.totalSlots);
        return tag;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.storagePositions = NBTHelper.getCollection(tag, "storagePositions", (byte)4, t -> Optional.of(BlockPos.m_122022_((long)((LongTag)t).m_7046_())), ArrayList::new).orElseGet(ArrayList::new);
        this.connectingBlocks = NBTHelper.getCollection(tag, "connectingBlocks", (byte)4, t -> Optional.of(BlockPos.m_122022_((long)((LongTag)t).m_7046_())), LinkedHashSet::new).orElseGet(LinkedHashSet::new);
        this.nonConnectingBlocks = NBTHelper.getCollection(tag, "nonConnectingBlocks", (byte)4, t -> Optional.of(BlockPos.m_122022_((long)((LongTag)t).m_7046_())), LinkedHashSet::new).orElseGet(LinkedHashSet::new);
        this.baseIndexes = NBTHelper.getCollection(tag, "baseIndexes", (byte)3, t -> Optional.of(((IntTag)t).m_7047_()), ArrayList::new).orElseGet(ArrayList::new);
        this.totalSlots = tag.m_128451_("totalSlots");
        this.linkedBlocks = NBTHelper.getCollection(tag, "linkedBlocks", (byte)4, t -> Optional.of(BlockPos.m_122022_((long)((LongTag)t).m_7046_())), LinkedHashSet::new).orElseGet(LinkedHashSet::new);
    }

    public CompoundTag m_5995_() {
        return this.saveData(super.m_5995_());
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void addStorageWithEmptySlots(BlockPos storageBlockPos) {
        this.emptySlotsStorages.add(storageBlockPos);
    }

    public void removeStorageWithEmptySlots(BlockPos storageBlockPos) {
        this.emptySlotsStorages.remove(storageBlockPos);
    }

    public Set<BlockPos> getLinkedBlocks() {
        return this.linkedBlocks;
    }

    public List<BlockPos> getStoragePositions() {
        return this.storagePositions;
    }

    public void setStorageFilterItems(BlockPos storagePos, Set<Item> filterItems) {
        this.removeStorageFilterItems(storagePos);
        if (filterItems.isEmpty()) {
            return;
        }
        for (Item item : filterItems) {
            this.filterItemStorages.computeIfAbsent(item, stackKey -> new LinkedHashSet()).add(storagePos);
        }
        this.storageFilterItems.put(storagePos, new LinkedHashSet<Item>(filterItems));
    }
}

