/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.tank;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.p3pp3rf1y.sophisticatedcore.client.gui.StorageScreenBase;
import net.p3pp3rf1y.sophisticatedcore.client.gui.UpgradeInventoryPartBase;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Dimension;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.GuiHelper;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Position;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TextureBlitData;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.UV;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageContainerMenuBase;
import net.p3pp3rf1y.sophisticatedcore.init.ModFluids;
import net.p3pp3rf1y.sophisticatedcore.network.PacketHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.tank.TankClickMessage;
import net.p3pp3rf1y.sophisticatedcore.upgrades.tank.TankUpgradeContainer;
import net.p3pp3rf1y.sophisticatedcore.util.XpHelper;

public class TankInventoryPart
extends UpgradeInventoryPartBase<TankUpgradeContainer> {
    private static final TextureBlitData OVERLAY = new TextureBlitData(GuiHelper.GUI_CONTROLS, Dimension.SQUARE_256, new UV(47, 30), new Dimension(16, 18));
    private final Position pos;
    private final int height;
    private final StorageScreenBase<?> screen;

    public TankInventoryPart(int upgradeSlot, TankUpgradeContainer container, Position pos, int height, StorageScreenBase<?> screen) {
        super(upgradeSlot, container);
        this.pos = pos;
        this.height = height;
        this.screen = screen;
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int i;
        GuiHelper.blit(guiGraphics, this.getTankLeft(), this.pos.y(), GuiHelper.BAR_BACKGROUND_TOP);
        int yOffset = 18;
        for (i = 0; i < (this.height - 36) / 18; ++i) {
            GuiHelper.blit(guiGraphics, this.getTankLeft(), this.pos.y() + yOffset, GuiHelper.BAR_BACKGROUND_MIDDLE);
            yOffset += 18;
        }
        GuiHelper.blit(guiGraphics, this.getTankLeft(), this.pos.y() + yOffset, GuiHelper.BAR_BACKGROUND_BOTTOM);
        this.renderFluid(guiGraphics);
        yOffset = 0;
        for (i = 0; i < this.height / 18; ++i) {
            GuiHelper.blit(guiGraphics, this.getTankLeft() + 1, this.pos.y() + yOffset, OVERLAY);
            yOffset += 18;
        }
    }

    private int getTankLeft() {
        return this.pos.x() + 9;
    }

    @Override
    public boolean handleMouseReleased(double mouseX, double mouseY, int button) {
        if (mouseX < (double)(this.screen.getGuiLeft() + this.getTankLeft()) || mouseX >= (double)(this.screen.getGuiLeft() + this.getTankLeft() + 18) || mouseY < (double)(this.screen.getGuiTop() + this.pos.y()) || mouseY >= (double)(this.screen.getGuiTop() + this.pos.y() + this.height)) {
            return false;
        }
        ItemStack cursorStack = ((StorageContainerMenuBase)this.screen.m_6262_()).m_142621_();
        if (cursorStack.m_41613_() > 1 || !cursorStack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent()) {
            return false;
        }
        PacketHandler.INSTANCE.sendToServer(new TankClickMessage(this.upgradeSlot));
        return true;
    }

    @Override
    public void renderErrorOverlay(GuiGraphics guiGraphics) {
        this.screen.renderOverlay(guiGraphics, StorageScreenBase.ERROR_SLOT_COLOR, this.getTankLeft() + 1, this.pos.y() + 1, 16, this.height - 2);
    }

    @Override
    public void renderTooltip(StorageScreenBase<?> screen, GuiGraphics guiGraphics, int mouseX, int mouseY) {
        FluidStack contents = ((TankUpgradeContainer)this.container).getContents();
        int capacity = ((TankUpgradeContainer)this.container).getTankCapacity();
        if (contents.isEmpty()) {
            contents = FluidStack.EMPTY;
        }
        int screenX = screen.getGuiLeft() + this.pos.x() + 10;
        int screenY = screen.getGuiTop() + this.pos.y() + 1;
        if (mouseX >= screenX && mouseX < screenX + 16 && mouseY >= screenY && mouseY < screenY + this.height - 2) {
            ArrayList<Object> tooltip = new ArrayList<Object>();
            if (!contents.isEmpty()) {
                tooltip.add(contents.getDisplayName());
            }
            tooltip.add(this.getContentsTooltip(contents, capacity));
            guiGraphics.m_280677_(screen.f_96547_, tooltip, Optional.empty(), mouseX, mouseY);
        }
    }

    private MutableComponent getContentsTooltip(FluidStack contents, int capacity) {
        if (contents.getFluid().m_205067_(ModFluids.EXPERIENCE_TAG)) {
            double contentsLevels = XpHelper.getLevelsForExperience((int)XpHelper.liquidToExperience(contents.getAmount()));
            double tankCapacityLevels = XpHelper.getLevelsForExperience((int)XpHelper.liquidToExperience(capacity));
            return Component.m_237110_((String)TranslationHelper.INSTANCE.translUpgradeKey("tank.xp_contents_tooltip"), (Object[])new Object[]{String.format("%.1f", contentsLevels), String.format("%.1f", tankCapacityLevels)});
        }
        return Component.m_237110_((String)TranslationHelper.INSTANCE.translUpgradeKey("tank.contents_tooltip"), (Object[])new Object[]{String.format("%,d", contents.getAmount()), String.format("%,d", capacity)});
    }

    private void renderFluid(GuiGraphics guiGraphics) {
        FluidStack contents = ((TankUpgradeContainer)this.container).getContents();
        int capacity = ((TankUpgradeContainer)this.container).getTankCapacity();
        if (contents.isEmpty()) {
            return;
        }
        Fluid fluid = contents.getFluid();
        int fill = contents.getAmount();
        int displayLevel = (int)((float)(this.height - 2) * ((float)fill / (float)capacity));
        IClientFluidTypeExtensions renderProperties = IClientFluidTypeExtensions.of((Fluid)fluid);
        ResourceLocation texture = renderProperties.getStillTexture(contents);
        TextureAtlasSprite still = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(texture);
        GuiHelper.renderTiledFluidTextureAtlas(guiGraphics, still, renderProperties.getTintColor(contents), this.pos.x() + 10, this.pos.y() + 1 + this.height - 2 - displayLevel, displayLevel);
    }
}

