/*
 * Decompiled with CFR 0.152.
 */
package com.mysticsbiomes;

import com.google.common.collect.Sets;
import com.mysticsbiomes.common.block.state.MysticWoodTypes;
import com.mysticsbiomes.common.entity.animal.SeaOtter;
import com.mysticsbiomes.common.world.AnimalSpawnsBuilder;
import com.mysticsbiomes.data.provider.MysticBlockStatesProvider;
import com.mysticsbiomes.data.provider.MysticLootTablesProvider;
import com.mysticsbiomes.init.MysticBiomes;
import com.mysticsbiomes.init.MysticBlockEntities;
import com.mysticsbiomes.init.MysticBlocks;
import com.mysticsbiomes.init.MysticConfig;
import com.mysticsbiomes.init.MysticEntities;
import com.mysticsbiomes.init.MysticFeatures;
import com.mysticsbiomes.init.MysticItems;
import com.mysticsbiomes.init.MysticParticles;
import com.mysticsbiomes.init.MysticPoiTypes;
import com.mysticsbiomes.init.MysticSounds;
import com.mysticsbiomes.init.MysticTab;
import com.mysticsbiomes.init.MysticVanillaCompat;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.common.data.DatapackBuiltinEntriesProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;

@Mod(value="mysticsbiomes")
public class MysticsBiomes {
    public static final String modId = "mysticsbiomes";

    public static ResourceLocation modLoc(String path) {
        return new ResourceLocation(modId, path);
    }

    public MysticsBiomes() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::dataSetup);
        bus.addListener(this::commonSetup);
        bus.addListener(this::clientSetup);
        MysticBlocks.BLOCKS.register(bus);
        MysticBlockEntities.BLOCK_ENTITIES.register(bus);
        MysticEntities.ENTITIES.register(bus);
        MysticFeatures.FEATURES.register(bus);
        MysticFeatures.TREE_DECORATORS.register(bus);
        MysticFeatures.TRUNK_PLACERS.register(bus);
        MysticItems.ITEMS.register(bus);
        MysticParticles.PARTICLES.register(bus);
        MysticPoiTypes.POI_TYPES.register(bus);
        MysticSounds.SOUNDS.register(bus);
        MysticTab.CREATIVE_TABS.register(bus);
        DeferredRegister BIOME_MODIFIERS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)modId);
        BIOME_MODIFIERS.register(bus);
        BIOME_MODIFIERS.register("animal_spawns", AnimalSpawnsBuilder::makeCodec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)MysticConfig.COMMON_SPEC);
    }

    private void dataSetup(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        ExistingFileHelper helper = event.getExistingFileHelper();
        RegistrySetBuilder builder = new RegistrySetBuilder();
        builder.m_254916_(Registries.f_256911_, MysticFeatures.Configured::bootstrap);
        builder.m_254916_(Registries.f_256988_, MysticFeatures.Placed::bootstrap);
        builder.m_254916_(Registries.f_256952_, MysticBiomes::bootstrap);
        generator.addProvider(event.includeServer(), (DataProvider)new DatapackBuiltinEntriesProvider(output, event.getLookupProvider(), builder, Set.of(modId)));
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(output, Collections.unmodifiableSet(Sets.newHashSet()), List.of(new LootTableProvider.SubProviderEntry(MysticLootTablesProvider::new, LootContextParamSets.f_81421_))));
        generator.addProvider(event.includeClient(), (DataProvider)new MysticBlockStatesProvider(output, helper));
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            EntityDataSerializers.m_135050_(SeaOtter.SEA_OTTER_STATE);
            MysticBiomes.registerRegionProvider();
            MysticBiomes.registerSurfaceRules();
            MysticVanillaCompat.registerFlammables();
            MysticVanillaCompat.registerCompostables();
        });
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            MysticVanillaCompat.registerRenderLayers();
            MysticWoodTypes.registerWoodTypes();
        });
    }
}

