/*
 * Decompiled with CFR 0.152.
 */
package com.mysticsbiomes.client.entity.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mysticsbiomes.client.entity.animation.RedPandaAnimation;
import com.mysticsbiomes.common.entity.animal.RedPanda;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RedPandaModel<T extends RedPanda>
extends HierarchicalModel<T> {
    private final ModelPart root;
    public final ModelPart head;
    private final ModelPart headStanding;
    private final ModelPart body;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftFrontLeg;
    private final ModelPart rightHindLeg;
    private final ModelPart leftHindLeg;

    public RedPandaModel(ModelPart root) {
        this.root = root.m_171324_("root");
        this.head = this.root.m_171324_("head");
        this.headStanding = this.root.m_171324_("head_standing");
        this.body = this.root.m_171324_("body");
        this.rightFrontLeg = this.root.m_171324_("right_front_leg");
        this.leftFrontLeg = this.root.m_171324_("left_front_leg");
        this.rightHindLeg = this.root.m_171324_("right_hind_leg");
        this.leftHindLeg = this.root.m_171324_("left_hind_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition partdefinition = mesh.m_171576_();
        PartDefinition root = partdefinition.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition head = root.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-3.5f, -3.0f, -5.0f, 7.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-6.0f, (float)-3.0f));
        head.m_171599_("right_ear", CubeListBuilder.m_171558_().m_171514_(27, 6).m_171480_().m_171488_(-1.0f, -1.5f, -0.5f, 3.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-3.5f, (float)-2.5f, (float)-1.5f));
        head.m_171599_("left_ear", CubeListBuilder.m_171558_().m_171514_(27, 6).m_171488_(-2.0f, -1.5f, -0.5f, 3.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.5f, (float)-2.5f, (float)-1.5f));
        head.m_171599_("snout", CubeListBuilder.m_171558_().m_171514_(27, 0).m_171488_(-2.0f, -1.5f, -2.0f, 4.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)1.5f, (float)-5.0f));
        PartDefinition head_standing = root.m_171599_("head_standing", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-3.5f, -6.0f, -2.5f, 7.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-3.0f, (float)-5.5f));
        head_standing.m_171599_("right_ear2", CubeListBuilder.m_171558_().m_171514_(27, 6).m_171480_().m_171488_(-1.0f, -1.5f, -0.5f, 3.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-3.5f, (float)-5.5f, (float)1.0f));
        head_standing.m_171599_("left_ear2", CubeListBuilder.m_171558_().m_171514_(27, 6).m_171488_(-2.0f, -1.5f, -0.5f, 3.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.5f, (float)-5.5f, (float)1.0f));
        head_standing.m_171599_("snout2", CubeListBuilder.m_171558_().m_171514_(27, 0).m_171488_(-2.0f, -1.5f, -2.0f, 4.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.5f, (float)-2.5f));
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-6.0f, (float)2.0f));
        body.m_171599_("body_r1", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-3.0f, -5.0f, -3.0f, 6.0f, 10.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition tail = body.m_171599_("tail", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)5.0f));
        tail.m_171599_("tail_r1", CubeListBuilder.m_171558_().m_171514_(27, 17).m_171488_(-2.5f, 0.0f, -2.5f, 5.0f, 9.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        root.m_171599_("right_front_leg", CubeListBuilder.m_171558_().m_171514_(40, 1).m_171480_().m_171488_(-0.99f, -1.0f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-2.0f, (float)-4.0f, (float)-2.0f));
        root.m_171599_("left_front_leg", CubeListBuilder.m_171558_().m_171514_(40, 1).m_171488_(-1.01f, -1.0f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)-4.0f, (float)-2.0f));
        root.m_171599_("right_hind_leg", CubeListBuilder.m_171558_().m_171514_(40, 1).m_171480_().m_171488_(-0.99f, -1.0f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-2.0f, (float)-4.0f, (float)5.0f));
        root.m_171599_("left_hind_leg", CubeListBuilder.m_171558_().m_171514_(40, 1).m_171488_(-1.01f, -1.0f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)-4.0f, (float)5.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)48, (int)32);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.headStanding.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.headStanding.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104207_ = !((RedPanda)((Object)entity)).isEating();
        this.headStanding.f_104207_ = ((RedPanda)((Object)entity)).isEating();
        this.m_233381_(((RedPanda)((Object)entity)).idleAnimationState, RedPandaAnimation.RED_PANDA_IDLE, ageInTicks);
        this.m_233381_(((RedPanda)((Object)entity)).sleepingAnimationState, RedPandaAnimation.RED_PANDA_SLEEP, ageInTicks);
        this.m_233381_(((RedPanda)((Object)entity)).eatAnimationState, RedPandaAnimation.RED_PANDA_EAT, ageInTicks);
        if (!((RedPanda)((Object)entity)).m_5803_() && !((RedPanda)((Object)entity)).isEating()) {
            if (entity.m_20142_()) {
                this.m_267799_(RedPandaAnimation.RED_PANDA_SPRINT, limbSwing, limbSwingAmount, 6.5f, 2.5f);
            } else {
                this.m_267799_(RedPandaAnimation.RED_PANDA_WALK, limbSwing, limbSwingAmount, 10.0f, 8.5f);
            }
        }
    }

    public void m_7695_(PoseStack stack, VertexConsumer consumer, int light, int overlay, float r, float g, float b, float a) {
        if (this.f_102610_) {
            stack.m_85836_();
            float f1 = 0.75f;
            stack.m_85841_(f1, f1, f1);
            stack.m_252880_(0.0f, 2.15f, 0.0625f);
            this.headParts().forEach(part -> part.m_104306_(stack, consumer, light, overlay, r, g, b, a));
            stack.m_85849_();
            stack.m_85836_();
            f1 = 0.5f;
            stack.m_85841_(f1, f1, f1);
            stack.m_252880_(0.0f, 3.0f, 0.0f);
            this.bodyParts().forEach(part -> part.m_104306_(stack, consumer, light, overlay, r, g, b, a));
            stack.m_85849_();
        } else {
            super.m_7695_(stack, consumer, light, overlay, r, g, b, a);
        }
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body, (Object)this.rightFrontLeg, (Object)this.leftFrontLeg, (Object)this.rightHindLeg, (Object)this.leftHindLeg);
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

