/*
 * Decompiled with CFR 0.152.
 */
package com.mysticsbiomes.client.entity.model;

import com.mysticsbiomes.client.entity.animation.SeaOtterAnimation;
import com.mysticsbiomes.common.entity.animal.SeaOtter;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SeaOtterModel<T extends SeaOtter>
extends HierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart head2;
    private final ModelPart body;
    private final ModelPart neck;

    public SeaOtterModel(ModelPart root) {
        this.root = root.m_171324_("root");
        this.head = this.root.m_171324_("head");
        this.head2 = this.root.m_171324_("head2");
        this.body = this.root.m_171324_("body");
        this.neck = this.body.m_171324_("neck");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_().m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)18.5f, (float)-0.1f));
        PartDefinition head = root.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-3.0f, -3.0f, -5.0f, 6.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(24, 6).m_171488_(-2.0f, -1.0f, -6.0f, 4.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-0.5f, (float)-4.9f));
        head.m_171599_("right_whiskers", CubeListBuilder.m_171558_().m_171514_(35, 6).m_171480_().m_171488_(-2.0f, -1.5f, 0.0f, 2.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-3.0f, (float)0.5f, (float)-4.0f));
        head.m_171599_("left_whiskers", CubeListBuilder.m_171558_().m_171514_(35, 6).m_171488_(0.0f, -1.5f, 0.0f, 2.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)0.5f, (float)-4.0f));
        PartDefinition head2 = root.m_171599_("head2", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-3.0f, -5.0f, -2.5f, 6.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(24, 6).m_171488_(-2.0f, -3.0f, -3.5f, 4.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)1.5f, (float)-7.4f));
        head2.m_171599_("right_whiskers2", CubeListBuilder.m_171558_().m_171514_(35, 6).m_171480_().m_171488_(-2.0f, -2.0f, 0.0f, 2.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-3.0f, (float)-1.0f, (float)-1.5f));
        head2.m_171599_("left_whiskers2", CubeListBuilder.m_171558_().m_171514_(35, 6).m_171488_(0.0f, -2.0f, 0.0f, 2.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)-1.0f, (float)-1.5f));
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-0.5f, (float)-4.9f));
        PartDefinition torso = body.m_171599_("torso", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        torso.m_171599_("torso_r1", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-3.0f, 0.0f, -3.5f, 6.0f, 11.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-0.5f, (float)0.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition neck = body.m_171599_("neck", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.5f, (float)2.5f));
        neck.m_171599_("neck_r1", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-3.0f, -2.5f, -2.5f, 6.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        body.m_171599_("right_front_leg", CubeListBuilder.m_171558_().m_171514_(25, 16).m_171480_().m_171488_(-1.0f, 0.0f, -0.9f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-1.9f, (float)2.0f, (float)1.0f));
        body.m_171599_("left_front_leg", CubeListBuilder.m_171558_().m_171514_(25, 16).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.9f, (float)2.0f, (float)1.1f));
        body.m_171599_("right_hind_leg", CubeListBuilder.m_171558_().m_171514_(24, 24).m_171480_().m_171488_(-1.5f, 0.0f, -1.0f, 3.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-2.5f, (float)2.0f, (float)9.0f));
        body.m_171599_("left_hind_leg", CubeListBuilder.m_171558_().m_171514_(24, 24).m_171488_(-1.5f, 0.0f, -1.0f, 3.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.5f, (float)2.0f, (float)9.0f));
        PartDefinition tail = body.m_171599_("tail", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-0.5f, (float)11.0f));
        tail.m_171599_("tail_r1", CubeListBuilder.m_171558_().m_171514_(36, 20).m_171488_(-1.0f, 0.0f, -1.5f, 2.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)48, (int)32);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head2.f_104203_ = -this.head.f_104203_;
        this.head2.f_104204_ = -this.head.f_104204_;
        boolean flag = ((SeaOtter)((Object)entity)).isFloating();
        this.head.f_104207_ = !flag;
        this.head2.f_104207_ = flag;
        this.neck.f_104207_ = flag;
        this.m_233385_(((SeaOtter)((Object)entity)).startSwimmingAnimationState, SeaOtterAnimation.SEA_OTTER_SWIMMING_TRANSITION, ageInTicks, 1.0f);
        this.m_233385_(((SeaOtter)((Object)entity)).floatingAnimationState, SeaOtterAnimation.SEA_OTTER_FLOATING, ageInTicks, 1.0f);
        this.m_233385_(((SeaOtter)((Object)entity)).sitDownAnimationState, SeaOtterAnimation.SEA_OTTER_SIT_DOWN, ageInTicks, 1.0f);
        this.m_233385_(((SeaOtter)((Object)entity)).sitUpAnimationState, SeaOtterAnimation.SEA_OTTER_SIT_UP, ageInTicks, 1.0f);
        if (!((SeaOtter)((Object)entity)).isInAnimationTransition()) {
            if (entity.m_20069_()) {
                if (!flag) {
                    if (entity.m_5842_() && entity.m_20183_().m_123342_() < entity.m_9236_().m_5736_()) {
                        this.body.m_171327_(headPitch * ((float)Math.PI / 180), netHeadYaw * ((float)Math.PI / 180), 0.0f);
                    }
                    this.m_267799_(SeaOtterAnimation.SEA_OTTER_SWIMMING, limbSwing, limbSwingAmount, 3.0f, 6.0f);
                }
            } else {
                this.m_267799_(SeaOtterAnimation.SEA_OTTER_WALKING, limbSwing, limbSwingAmount, 3.0f, 6.0f);
            }
        }
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

