/*
 * Decompiled with CFR 0.152.
 */
package com.mysticsbiomes.client.entity.renderer;

import com.google.common.collect.Maps;
import com.mysticsbiomes.MysticsBiomes;
import com.mysticsbiomes.client.entity.model.ButterflyModel;
import com.mysticsbiomes.client.entity.model.layer.MysticModelLayers;
import com.mysticsbiomes.common.entity.animal.Butterfly;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ButterflyRenderer
extends MobRenderer<Butterfly, ButterflyModel<Butterfly>> {
    private static final Map<Integer, Map<Integer, ResourceLocation>> TEXTURES = (Map)Util.m_137469_((Object)Maps.newHashMap(), map -> {
        for (Butterfly.Type type : Butterfly.Type.values()) {
            map.put(type.getId(), ButterflyRenderer.variant(type.m_7912_()));
        }
    });

    public ButterflyRenderer(EntityRendererProvider.Context context) {
        super(context, new ButterflyModel(context.m_174023_(MysticModelLayers.BUTTERFLY)), 0.4f);
    }

    public ResourceLocation getTextureLocation(Butterfly butterfly) {
        Map<Integer, ResourceLocation> texture = TEXTURES.get(butterfly.getVariant().getId());
        return butterfly.hasVisibleNectar() ? texture.get(2) : texture.get(1);
    }

    public static Map<Integer, ResourceLocation> variant(String type) {
        HashMap map = Maps.newHashMap();
        map.put(1, MysticsBiomes.modLoc("textures/entity/butterfly/" + type + ".png"));
        map.put(2, MysticsBiomes.modLoc("textures/entity/butterfly/" + type + "_nectar.png"));
        return map;
    }
}

