/*
 * Decompiled with CFR 0.152.
 */
package com.mysticsbiomes.client.entity.renderer;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import com.mysticsbiomes.MysticsBiomes;
import com.mysticsbiomes.common.entity.MysticBoat;
import com.mysticsbiomes.common.entity.MysticChestBoat;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.BoatRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.vehicle.Boat;

public class MysticBoatRenderer
extends BoatRenderer {
    private final Map<MysticBoat.Type, Pair<ResourceLocation, ListModel<Boat>>> boatResources = (Map)Stream.of(MysticBoat.Type.values()).collect(ImmutableMap.toImmutableMap(key -> key, model -> Pair.of((Object)MysticsBiomes.modLoc(MysticBoatRenderer.getTextureLocation(model, hasChest)), (Object)this.createBoatModel(context, (MysticBoat.Type)((Object)model), hasChest))));

    public MysticBoatRenderer(EntityRendererProvider.Context context, boolean hasChest) {
        super(context, false);
    }

    public Pair<ResourceLocation, ListModel<Boat>> getModelWithLocation(Boat boat) {
        if (boat instanceof MysticChestBoat) {
            return this.boatResources.get((Object)((MysticChestBoat)boat).getModel());
        }
        return this.boatResources.get((Object)((MysticBoat)boat).getModel());
    }

    private static String getTextureLocation(MysticBoat.Type type, boolean hasChest) {
        return hasChest ? "textures/entity/boats/chest/" + type.getName() + ".png" : "textures/entity/boats/" + type.getName() + ".png";
    }

    private static ModelLayerLocation createLocation(String name) {
        return new ModelLayerLocation(MysticsBiomes.modLoc(name), "main");
    }

    public static ModelLayerLocation createBoatModelName(MysticBoat.Type type) {
        return MysticBoatRenderer.createLocation("boats/" + type.getName());
    }

    public static ModelLayerLocation createChestBoatModelName(MysticBoat.Type type) {
        return MysticBoatRenderer.createLocation("boats/chest/" + type.getName());
    }

    private BoatModel createBoatModel(EntityRendererProvider.Context context, MysticBoat.Type type, boolean hasChest) {
        ModelLayerLocation location = hasChest ? MysticBoatRenderer.createChestBoatModelName(type) : MysticBoatRenderer.createBoatModelName(type);
        ModelPart baked = context.m_174023_(location);
        return hasChest ? new ChestBoatModel(baked) : new BoatModel(baked);
    }
}

