/*
 * Decompiled with CFR 0.152.
 */
package com.mysticsbiomes.client.entity.renderer;

import com.google.common.collect.Maps;
import com.mysticsbiomes.MysticsBiomes;
import com.mysticsbiomes.client.entity.model.layer.MysticModelLayers;
import com.mysticsbiomes.common.entity.animal.RainbowChicken;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.model.ChickenModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RainbowChickenRenderer
extends MobRenderer<RainbowChicken, ChickenModel<RainbowChicken>> {
    private static final Map<Integer, ResourceLocation> TEXTURES = (Map)Util.m_137469_((Object)Maps.newHashMap(), map -> {
        for (RainbowChicken.Type type : RainbowChicken.Type.values()) {
            map.put(type.getId(), MysticsBiomes.modLoc("textures/entity/rainbow_chickens/" + type.m_7912_() + "_chicken.png"));
        }
    });

    public RainbowChickenRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new ChickenModel(context.m_174023_(MysticModelLayers.RAINBOW_CHICKEN)), 0.3f);
    }

    public ResourceLocation getTextureLocation(RainbowChicken chicken) {
        return TEXTURES.get(chicken.getVariant().getId());
    }

    protected float getBob(RainbowChicken chicken, float ticks) {
        float f = Mth.m_14179_((float)ticks, (float)chicken.oFlap, (float)chicken.flap);
        float f1 = Mth.m_14179_((float)ticks, (float)chicken.oFlapSpeed, (float)chicken.flapSpeed);
        return (Mth.m_14031_((float)f) + 1.0f) * f1;
    }
}

