/*
 * Decompiled with CFR 0.152.
 */
package com.mysticsbiomes.common.biome;

import com.mojang.datafixers.util.Pair;
import com.mysticsbiomes.MysticsBiomes;
import com.mysticsbiomes.init.MysticBiomes;
import com.mysticsbiomes.init.MysticConfig;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import terrablender.api.Region;
import terrablender.api.RegionType;

public class MysticBiomeProvider
extends Region {
    private static final ResourceLocation BIOME_LOCATION = MysticsBiomes.modLoc("overworld_provider");

    public MysticBiomeProvider(int weight) {
        super(BIOME_LOCATION, RegionType.OVERWORLD, weight);
    }

    public void addBiomes(Registry<Biome> registry, Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> mapper) {
        this.addModifiedVanillaOverworldBiomes(mapper, builder -> {
            if (((Boolean)MysticConfig.COMMON.enableStrawberryFields.get()).booleanValue()) {
                builder.replaceBiome(Biomes.f_48176_, MysticBiomes.STRAWBERRY_FIELDS);
            }
            if (((Boolean)MysticConfig.COMMON.enableLavenderMeadow.get()).booleanValue()) {
                builder.replaceBiome(Biomes.f_186754_, MysticBiomes.LAVENDER_MEADOW);
            }
            if (((Boolean)MysticConfig.COMMON.enableBambooBlossomForest.get()).booleanValue()) {
                builder.replaceBiome(Biomes.f_186761_, MysticBiomes.BAMBOO_BLOSSOM_FOREST);
            }
            if (((Boolean)MysticConfig.COMMON.enableAutumnalGrove.get()).booleanValue()) {
                builder.replaceBiome(Biomes.f_48206_, MysticBiomes.AUTUMNAL_GROVE);
            }
            if (((Boolean)MysticConfig.COMMON.enableLushOasis.get()).booleanValue()) {
                builder.replaceBiome(Biomes.f_48203_, MysticBiomes.LUSH_OASIS);
            }
            if (((Boolean)MysticConfig.COMMON.enableLagoon.get()).booleanValue()) {
                builder.replaceBiome(Biomes.f_48217_, MysticBiomes.LAGOON);
            }
            if (((Boolean)MysticConfig.COMMON.enableTropics.get()).booleanValue()) {
                builder.replaceBiome(Biomes.f_48222_, MysticBiomes.TROPICS);
            }
        });
    }
}

