/*
 * Decompiled with CFR 0.152.
 */
package com.mysticsbiomes.common.block;

import com.mysticsbiomes.common.block.MysticCeilingHangingSignBlock;
import com.mysticsbiomes.common.block.MysticLogBlock;
import com.mysticsbiomes.common.block.MysticStandingSignBlock;
import com.mysticsbiomes.common.block.MysticWallHangingSignBlock;
import com.mysticsbiomes.common.block.MysticWallSignBlock;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;

public interface BlockTemplate {
    public static MysticLogBlock log(Supplier<Block> block, MapColor yColor, MapColor xzColor) {
        return new MysticLogBlock(block.get(), BlockBehaviour.Properties.m_284310_().m_284495_(state -> state.m_61143_((Property)RotatedPillarBlock.f_55923_) == Direction.Axis.Y ? yColor : xzColor).m_280658_(NoteBlockInstrument.BASS).m_60978_(2.0f).m_60918_(SoundType.f_56736_).m_278183_());
    }

    public static RotatedPillarBlock rotatedPillar(MapColor color) {
        return new RotatedPillarBlock(BlockBehaviour.Properties.m_284310_().m_284180_(color).m_280658_(NoteBlockInstrument.BASS).m_60978_(2.0f).m_60918_(SoundType.f_56736_).m_278183_());
    }

    public static Block planks(MapColor color) {
        return new Block(BlockBehaviour.Properties.m_284310_().m_284180_(color).m_280658_(NoteBlockInstrument.BASS).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_).m_278183_());
    }

    public static StairBlock stairs(Block block) {
        return new StairBlock(() -> ((Block)block).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)block));
    }

    public static SlabBlock slab(Block block) {
        return new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)block));
    }

    public static FenceBlock fence(Block block) {
        return new FenceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)block).m_280606_());
    }

    public static FenceGateBlock fenceGate(Block block, WoodType woodType) {
        return new FenceGateBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)block).m_280606_(), woodType);
    }

    public static ButtonBlock button(BlockSetType setType) {
        return new ButtonBlock(BlockBehaviour.Properties.m_284310_().m_60910_().m_60978_(0.5f).m_278166_(PushReaction.DESTROY), setType, 30, true);
    }

    public static PressurePlateBlock pressurePlate(Block block, BlockSetType setType) {
        return new PressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, BlockBehaviour.Properties.m_60926_((BlockBehaviour)block).m_280606_().m_60910_().m_60978_(0.5f).m_278166_(PushReaction.DESTROY), setType);
    }

    public static TrapDoorBlock trapdoor(Block block, BlockSetType setType) {
        return new TrapDoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)block).m_60955_().m_60978_(3.0f).m_60922_(BlockTemplate::never), setType);
    }

    public static DoorBlock door(Block block, BlockSetType setType) {
        return new DoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)block).m_60955_().m_60978_(3.0f).m_278166_(PushReaction.DESTROY), setType);
    }

    public static MysticStandingSignBlock sign(Block block, WoodType woodType) {
        return new MysticStandingSignBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)block).m_280606_().m_60910_().m_60978_(1.0f), woodType);
    }

    public static MysticWallSignBlock wallSign(Block block, WoodType woodType) {
        return new MysticWallSignBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)block).lootFrom(() -> block), woodType);
    }

    public static MysticCeilingHangingSignBlock hangingSign(Block block, WoodType woodType) {
        return new MysticCeilingHangingSignBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)block).m_280606_().m_60910_().m_60978_(1.0f).m_278183_(), woodType);
    }

    public static MysticWallHangingSignBlock wallHangingSign(Block block, WoodType woodType) {
        return new MysticWallHangingSignBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)block).lootFrom(() -> block), woodType);
    }

    public static FlowerPotBlock potted(Block block) {
        return new FlowerPotBlock(block, BlockBehaviour.Properties.m_284310_().m_60966_().m_60955_().m_278166_(PushReaction.DESTROY));
    }

    public static boolean never(BlockState state, BlockGetter getter, BlockPos pos, EntityType<?> entityType) {
        return false;
    }

    public static boolean never(BlockState state, BlockGetter getter, BlockPos pos) {
        return false;
    }
}

