/*
 * Decompiled with CFR 0.152.
 */
package com.mysticsbiomes.common.block;

import com.mysticsbiomes.common.block.entity.ButterflyNestBlockEntity;
import com.mysticsbiomes.init.MysticBlockEntities;
import com.mysticsbiomes.init.MysticItems;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.WitherSkull;
import net.minecraft.world.entity.vehicle.MinecartTNT;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;

public class ButterflyNestBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final IntegerProperty NECTAR_LEVEL = IntegerProperty.m_61631_((String)"nectar_level", (int)0, (int)5);

    public ButterflyNestBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)NECTAR_LEVEL, (Comparable)Integer.valueOf(0))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ButterflyNestBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return level.f_46443_ ? null : ButterflyNestBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)MysticBlockEntities.BUTTERFLY_NEST.get()), ButterflyNestBlockEntity::serverTick);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        ItemStack stack = player.m_21120_(hand);
        int i = (Integer)state.m_61143_((Property)NECTAR_LEVEL);
        boolean flag = false;
        if (i >= 12) {
            Item item = stack.m_41720_();
            if (stack.m_150930_((Item)MysticItems.GLASS_JAR.get())) {
                stack.m_41774_(1);
                level.m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11770_, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (stack.m_41619_()) {
                    player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42787_));
                } else if (!player.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_42787_))) {
                    player.m_36176_(new ItemStack((ItemLike)Items.f_42787_), false);
                }
                flag = true;
                level.m_142346_((Entity)player, GameEvent.f_157816_, pos);
            }
            if (!level.m_5776_() && flag) {
                player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
            }
        }
        if (flag) {
            this.resetNectarLevel(level, state, pos);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return super.m_6227_(state, level, pos, player, hand, result);
    }

    public void resetNectarLevel(Level level, BlockState state, BlockPos pos) {
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)NECTAR_LEVEL, (Comparable)Integer.valueOf(0)), 3);
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity;
        if (!level.f_46443_ && player.m_7500_() && level.m_46469_().m_46207_(GameRules.f_46136_) && (blockEntity = level.m_7702_(pos)) instanceof ButterflyNestBlockEntity) {
            CompoundTag tag;
            boolean flag;
            ButterflyNestBlockEntity entity = (ButterflyNestBlockEntity)blockEntity;
            ItemStack stack = new ItemStack((ItemLike)this);
            int i = (Integer)state.m_61143_((Property)NECTAR_LEVEL);
            boolean bl = flag = !entity.isEmpty();
            if (flag || i > 0) {
                tag = new CompoundTag();
                tag.m_128365_("Butterflies", (Tag)entity.writeButterflies());
                BlockItem.m_186338_((ItemStack)stack, (BlockEntityType)((BlockEntityType)MysticBlockEntities.BUTTERFLY_NEST.get()), (CompoundTag)tag);
            }
            tag = new CompoundTag();
            tag.m_128405_("nectar_level", i);
            stack.m_41700_("BlockStateTag", (Tag)tag);
            ItemEntity itemEntity = new ItemEntity(level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), stack);
            itemEntity.m_32060_();
            level.m_7967_((Entity)itemEntity);
        }
        super.m_5707_(level, pos, state, player);
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        BlockEntity blockEntity;
        Entity entity = (Entity)builder.m_287159_(LootContextParams.f_81455_);
        if ((entity instanceof PrimedTnt || entity instanceof Creeper || entity instanceof WitherSkull || entity instanceof WitherBoss || entity instanceof MinecartTNT) && (blockEntity = (BlockEntity)builder.m_287159_(LootContextParams.f_81462_)) instanceof ButterflyNestBlockEntity) {
            ButterflyNestBlockEntity nest = (ButterflyNestBlockEntity)blockEntity;
            nest.emptyAllLivingFromNest(null, state, ButterflyNestBlockEntity.ReleaseStatus.EMERGENCY);
        }
        return super.m_49635_(state, builder);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState state1, LevelAccessor accessor, BlockPos pos, BlockPos pos1) {
        BlockEntity blockEntity;
        if (accessor.m_8055_(pos1).m_60734_() instanceof FireBlock && (blockEntity = accessor.m_7702_(pos)) instanceof ButterflyNestBlockEntity) {
            ButterflyNestBlockEntity nest = (ButterflyNestBlockEntity)blockEntity;
            nest.emptyAllLivingFromNest(null, state, ButterflyNestBlockEntity.ReleaseStatus.EMERGENCY);
        }
        return super.m_7417_(state, direction, state1, accessor, pos, pos1);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{NECTAR_LEVEL, FACING});
    }
}

