/*
 * Decompiled with CFR 0.152.
 */
package com.mysticsbiomes.common.block;

import java.util.function.Supplier;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.Tags;

public class FruitPlantBlock
extends BushBlock
implements BonemealableBlock {
    public static final IntegerProperty AGE = BlockStateProperties.f_222999_;
    public static final BooleanProperty CUT = BooleanProperty.m_61465_((String)"cropped");
    private final Supplier<Item> fruitItem;

    public FruitPlantBlock(Supplier<Item> fruitItem, BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)CUT, (Comparable)Boolean.valueOf(false)));
        this.fruitItem = fruitItem;
    }

    public ItemStack m_7397_(BlockGetter getter, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)this.fruitItem.get());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        int age = (Integer)state.m_61143_((Property)AGE);
        if (age == 0) {
            return Block.m_49796_((double)4.0, (double)12.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
        }
        if (age == 1) {
            return Block.m_49796_((double)4.0, (double)10.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
        }
        if (age == 2) {
            return Block.m_49796_((double)2.0, (double)8.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
        }
        return Block.m_49796_((double)2.0, (double)4.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_204117_(Tags.Items.SHEARS) && !((Boolean)state.m_61143_((Property)CUT)).booleanValue()) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CriteriaTriggers.f_10562_.m_285767_(serverPlayer, pos, stack);
            }
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)CUT, (Comparable)Boolean.TRUE), 11);
            stack.m_41622_(1, (LivingEntity)player, blockState -> blockState.m_21190_(hand));
            level.m_5594_(player, pos, SoundEvents.f_184217_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        int age = (Integer)state.m_61143_((Property)AGE);
        if (age == 4) {
            FruitPlantBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)this.fruitItem.get(), 1));
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)), 2);
            level.m_5594_(null, pos, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return super.m_6227_(state, level, pos, player, hand, result);
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int age = (Integer)state.m_61143_((Property)AGE);
        if (age < 4 && ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (random.m_188503_(72) == 0 ? 1 : 0) != 0)) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(age + 1)), 2);
            level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223722_((BlockState)state));
            ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    public boolean m_6724_(BlockState state) {
        return (Boolean)state.m_61143_((Property)CUT) == false && (Integer)state.m_61143_((Property)AGE) < 4;
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return level.m_8055_(pos.m_7494_()).m_204336_(BlockTags.f_13035_);
    }

    protected boolean m_6266_(BlockState state, BlockGetter getter, BlockPos pos) {
        return state.m_204336_(BlockTags.f_13035_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE}).m_61104_(new Property[]{CUT});
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean valid) {
        return (Integer)state.m_61143_((Property)AGE) < 4;
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        int i = Math.min(4, (Integer)state.m_61143_((Property)AGE) + 1);
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(i)), 3);
    }
}

