/*
 * Decompiled with CFR 0.152.
 */
package com.mysticsbiomes.common.block;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MapleLeafPileBlock
extends Block {
    public static final IntegerProperty LAYERS = BlockStateProperties.f_61417_;
    protected static final VoxelShape[] SHAPE_BY_LAYER = new VoxelShape[]{Shapes.m_83040_(), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};
    private final Supplier<ParticleOptions> particle;

    public MapleLeafPileBlock(Supplier<ParticleOptions> particleType) {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283824_).m_60910_().m_60955_().m_280170_().m_60978_(0.1f).m_60918_(SoundType.f_56740_).m_278166_(PushReaction.DESTROY));
        this.particle = particleType;
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity instanceof LivingEntity && (Integer)state.m_61143_((Property)LAYERS) > 1) {
            double d = 1.0 - 0.1 * (double)((Integer)state.m_61143_((Property)LAYERS) - 1);
            entity.m_7601_(state, new Vec3(d, d, d));
            if (entity.f_19791_ > entity.m_20186_() + 0.25) {
                for (int i = 1; i < (Integer)state.m_61143_((Property)LAYERS); ++i) {
                    double d0 = (double)pos.m_123341_() + level.m_213780_().m_188500_() + 0.2;
                    double d1 = (double)pos.m_123342_() + 0.5;
                    double d2 = (double)pos.m_123343_() + level.m_213780_().m_188500_() + 0.2;
                    level.m_7106_(this.particle.get(), d0, d1, d2, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState state1, LevelAccessor accessor, BlockPos pos, BlockPos pos1) {
        return !state.m_60710_((LevelReader)accessor, pos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, direction, state1, accessor, pos, pos1);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = context.m_43725_().m_8055_(context.m_8083_());
        if (state.m_60713_((Block)this)) {
            int i = (Integer)state.m_61143_((Property)LAYERS);
            return (BlockState)state.m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(Math.min(8, i + 1)));
        }
        return super.m_5573_(context);
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext context) {
        int i = (Integer)state.m_61143_((Property)LAYERS);
        if (context.m_43722_().m_150930_(this.m_5456_()) && i < 8) {
            if (context.m_7058_()) {
                return context.m_43719_() == Direction.UP;
            }
            return true;
        }
        return i == 1;
    }

    public boolean m_7357_(BlockState state, BlockGetter getter, BlockPos pos, PathComputationType type) {
        return false;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_LAYER[(Integer)state.m_61143_((Property)LAYERS)];
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    public VoxelShape m_7947_(BlockState state, BlockGetter getter, BlockPos pos) {
        return SHAPE_BY_LAYER[(Integer)state.m_61143_((Property)LAYERS)];
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_LAYER[(Integer)state.m_61143_((Property)LAYERS)];
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter getter, BlockPos pos) {
        return Shapes.m_83040_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LAYERS});
    }
}

