/*
 * Decompiled with CFR 0.152.
 */
package com.mysticsbiomes.common.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.mysticsbiomes.common.block.MysticCakeBlock;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;

public class MysticCandleCakeBlock
extends AbstractCandleBlock {
    protected static final VoxelShape CAKE_SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0);
    protected static final VoxelShape CANDLE_SHAPE = Block.m_49796_((double)7.0, (double)8.0, (double)7.0, (double)9.0, (double)14.0, (double)9.0);
    protected static final VoxelShape SHAPE = Shapes.m_83110_((VoxelShape)CAKE_SHAPE, (VoxelShape)CANDLE_SHAPE);
    protected final Block cake;
    protected final Block candle;
    protected static Map<Pair<Block, MysticCakeBlock>, MysticCandleCakeBlock> BY_CANDLE = Maps.newHashMap();

    public MysticCandleCakeBlock(Supplier<Block> cake, Block candle) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)cake.get())).m_60953_(state -> (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_) != false ? 3 : 0));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_151895_, (Comparable)Boolean.FALSE));
        this.cake = cake.get();
        this.candle = candle;
        BY_CANDLE.put((Pair<Block, MysticCakeBlock>)Pair.of((Object)candle, (Object)((Object)((MysticCakeBlock)cake.get()))), this);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public ItemStack m_7397_(BlockGetter getter, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)this.cake);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_150930_(Items.f_42409_) && !stack.m_150930_(Items.f_42613_)) {
            if (result.m_82450_().f_82480_ - (double)result.m_82425_().m_123342_() > 0.5 && player.m_21120_(hand).m_41619_() && ((Boolean)state.m_61143_((Property)f_151895_)).booleanValue()) {
                MysticCandleCakeBlock.m_151899_((Player)player, (BlockState)state, (LevelAccessor)level, (BlockPos)pos);
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            InteractionResult interaction = MysticCakeBlock.m_51185_((LevelAccessor)level, pos, this.cake.m_49966_(), player);
            if (interaction.m_19077_()) {
                MysticCandleCakeBlock.m_49950_((BlockState)state, (Level)level, (BlockPos)pos);
            }
            return interaction;
        }
        return InteractionResult.PASS;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState state1, LevelAccessor level, BlockPos pos, BlockPos pos1) {
        return direction == Direction.DOWN && !state.m_60710_((LevelReader)level, pos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, direction, state1, level, pos, pos1);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return level.m_8055_(pos.m_7495_()).m_280296_();
    }

    public boolean m_7357_(BlockState state, BlockGetter getter, BlockPos pos, PathComputationType type) {
        return false;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        return CakeBlock.f_152743_;
    }

    public static BlockState byCandle(Block candle, MysticCakeBlock cake) {
        return BY_CANDLE.get(Pair.of((Object)candle, (Object)((Object)cake))).m_49966_();
    }

    protected Iterable<Vec3> m_142199_(BlockState state) {
        return ImmutableList.of((Object)new Vec3(0.5, 1.0, 0.5));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_151895_});
    }

    public static List<Block> getMysticCandleCakes() {
        return ForgeRegistries.BLOCKS.getValues().stream().filter(block -> block instanceof MysticCandleCakeBlock).collect(Collectors.toList());
    }

    public Block getCake() {
        return this.cake;
    }

    public Block getCandle() {
        return this.candle;
    }
}

