/*
 * Decompiled with CFR 0.152.
 */
package com.mysticsbiomes.common.block;

import com.mysticsbiomes.common.block.BlockTemplate;
import java.util.OptionalInt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MysticLeavesBlock
extends Block {
    public static final IntegerProperty DISTANCE = IntegerProperty.m_61631_((String)"distance", (int)1, (int)16);
    public static final BooleanProperty PERSISTENT = BlockStateProperties.f_61447_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public MysticLeavesBlock(SoundType soundType) {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_60978_(0.2f).m_60977_().m_60918_(soundType).m_60955_().m_60960_(BlockTemplate::never).m_60971_(BlockTemplate::never).m_278183_().m_278166_(PushReaction.DESTROY).m_60924_(BlockTemplate::never));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)DISTANCE, (Comparable)Integer.valueOf(16))).m_61124_((Property)PERSISTENT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean m_6724_(BlockState state) {
        return (Boolean)state.m_61143_((Property)PERSISTENT) == false && (Integer)state.m_61143_((Property)DISTANCE) == 16;
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!((Boolean)state.m_61143_((Property)PERSISTENT)).booleanValue() && (Integer)state.m_61143_((Property)DISTANCE) == 16) {
            MysticLeavesBlock.m_49950_((BlockState)state, (Level)level, (BlockPos)pos);
            level.m_7471_(pos, false);
        }
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        BlockPos belowPos;
        BlockState belowState;
        if (!(!level.m_46758_(pos.m_7494_()) || random.m_188503_(15) != 1 || (belowState = level.m_8055_(belowPos = pos.m_7495_())).m_60815_() && belowState.m_60783_((BlockGetter)level, belowPos, Direction.UP))) {
            ParticleUtils.m_272037_((Level)level, (BlockPos)pos, (RandomSource)random, (ParticleOptions)ParticleTypes.f_123803_);
        }
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        level.m_7731_(pos, MysticLeavesBlock.updateDistance(state, (LevelAccessor)level, pos), 3);
    }

    private static BlockState updateDistance(BlockState state, LevelAccessor level, BlockPos pos) {
        int distance = 16;
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.values()) {
            mutablePos.m_122159_((Vec3i)pos, direction);
            distance = Math.min(distance, MysticLeavesBlock.getDistanceAt(level.m_8055_((BlockPos)mutablePos)) + 1);
            if (distance == 1) break;
        }
        return (BlockState)state.m_61124_((Property)DISTANCE, (Comparable)Integer.valueOf(distance));
    }

    public VoxelShape m_7947_(BlockState state, BlockGetter getter, BlockPos pos) {
        return Shapes.m_83040_();
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState state2, LevelAccessor accessor, BlockPos pos, BlockPos pos2) {
        int i;
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            accessor.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)accessor));
        }
        if ((i = MysticLeavesBlock.getDistanceAt(state2) + 1) != 1 || (Integer)state.m_61143_((Property)DISTANCE) != i) {
            accessor.m_186460_(pos, (Block)this, 1);
        }
        return state;
    }

    private static int getDistanceAt(BlockState state) {
        return MysticLeavesBlock.getOptionalDistanceAt(state).orElse(16);
    }

    private static OptionalInt getOptionalDistanceAt(BlockState state) {
        if (state.m_204336_(BlockTags.f_13106_)) {
            return OptionalInt.of(0);
        }
        return state.m_61138_((Property)DISTANCE) ? OptionalInt.of((Integer)state.m_61143_((Property)DISTANCE)) : OptionalInt.empty();
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        BlockState blockState = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)PERSISTENT, (Comparable)Boolean.TRUE)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
        return MysticLeavesBlock.updateDistance(blockState, (LevelAccessor)context.m_43725_(), context.m_8083_());
    }

    public int m_7753_(BlockState state, BlockGetter getter, BlockPos pos) {
        return 1;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{DISTANCE, PERSISTENT, WATERLOGGED});
    }
}

