/*
 * Decompiled with CFR 0.152.
 */
package com.mysticsbiomes.common.block;

import com.mysticsbiomes.init.MysticBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CactusBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;

public class SaguaroCactusBlock
extends CactusBlock {
    public static final IntegerProperty AGE = BlockStateProperties.f_61410_;
    public static final EnumProperty<BranchShape> ATTACHMENT = EnumProperty.m_61587_((String)"shape", BranchShape.class);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty BRANCH = BooleanProperty.m_61465_((String)"branch");
    public static final BooleanProperty NATURAL = BooleanProperty.m_61465_((String)"natural");
    public static final BooleanProperty CUT = BooleanProperty.m_61465_((String)"cropped");
    public static final BooleanProperty TOP = BooleanProperty.m_61465_((String)"top");

    public SaguaroCactusBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_(ATTACHMENT, (Comparable)((Object)BranchShape.BASE))).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)BRANCH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)NATURAL, (Comparable)Boolean.valueOf(false))).m_61124_((Property)CUT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)TOP, (Comparable)Boolean.valueOf(true)));
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockPos abovePos = pos.m_7494_();
        boolean hasBlossomAbove = level.m_8055_(abovePos).m_60713_((Block)MysticBlocks.SAGUARO_BLOSSOM.get());
        if (!((Boolean)state.m_61143_((Property)NATURAL)).booleanValue() && !((Boolean)state.m_61143_((Property)CUT)).booleanValue() && (level.m_46859_(abovePos) || hasBlossomAbove)) {
            int height = 1;
            while (level.m_8055_(pos.m_6625_(height)).m_60713_((Block)this)) {
                ++height;
            }
            if (height < 5) {
                int age = (Integer)state.m_61143_((Property)AGE);
                if (ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)abovePos, (BlockState)state, (boolean)true)) {
                    if (age == 15) {
                        level.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)), 4);
                        BlockState blockState = this.m_49966_();
                        if (((Boolean)state.m_61143_((Property)BRANCH)).booleanValue()) {
                            if (height < 2) {
                                level.m_46597_(abovePos, (BlockState)((BlockState)blockState.m_61124_(ATTACHMENT, (Comparable)((Object)BranchShape.BRANCH))).m_61124_((Property)BRANCH, (Comparable)Boolean.valueOf(true)));
                            }
                        } else {
                            level.m_46597_(abovePos, (BlockState)blockState.m_61124_(ATTACHMENT, (Comparable)((Object)BranchShape.BASE)));
                            if (hasBlossomAbove) {
                                level.m_46597_(abovePos.m_7494_(), ((Block)MysticBlocks.SAGUARO_BLOSSOM.get()).m_49966_());
                            }
                        }
                        if (height == 2 && !((Boolean)state.m_61143_((Property)BRANCH)).booleanValue()) {
                            for (Direction direction : Direction.Plane.HORIZONTAL) {
                                BlockPos branchPos;
                                if (random.m_188503_(2) != 0 || !level.m_46859_(branchPos = pos.m_121945_(direction))) continue;
                                level.m_46597_(branchPos, (BlockState)((BlockState)((BlockState)blockState.m_61124_((Property)FACING, (Comparable)direction.m_122424_())).m_61124_(ATTACHMENT, (Comparable)((Object)BranchShape.BASE_BRANCH))).m_61124_((Property)BRANCH, (Comparable)Boolean.valueOf(true)));
                            }
                        }
                        if (random.m_188503_(8) == 0 && !hasBlossomAbove) {
                            level.m_46597_(abovePos, ((Block)MysticBlocks.SAGUARO_BLOSSOM.get()).m_49966_());
                        }
                    } else {
                        level.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(age + 1)), 4);
                    }
                    ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
                }
            }
        }
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockState relativeState;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            relativeState = level.m_8055_(pos.m_121945_(direction));
            if (!relativeState.m_280296_() || !(relativeState.m_60734_() instanceof SaguaroCactusBlock) || level.m_8055_(pos.m_7495_()).m_60795_() && state.m_61143_(ATTACHMENT) != BranchShape.BASE_BRANCH && state.m_61143_(ATTACHMENT) != BranchShape.BASE_BRANCH_UPWARD) continue;
            return (Boolean)state.m_61143_((Property)BRANCH) != false || (Boolean)state.m_61143_((Property)BRANCH) == false && (Boolean)relativeState.m_61143_((Property)BRANCH) != false;
        }
        BlockState belowState = level.m_8055_(pos.m_7495_());
        if (((Boolean)state.m_61143_((Property)BRANCH)).booleanValue()) {
            BlockPos relativePos = pos.m_121945_(((Direction)state.m_61143_((Property)FACING)).m_122424_());
            relativeState = level.m_8055_(relativePos);
            if (relativeState.m_60734_() instanceof SaguaroCactusBlock && (relativeState.m_61143_(ATTACHMENT) == BranchShape.BASE || relativeState.m_61143_(ATTACHMENT) == BranchShape.BASE_BRANCH_UPWARD)) {
                return true;
            }
            if (belowState.m_60734_() instanceof SaguaroCactusBlock) {
                BranchShape belowShape = (BranchShape)((Object)belowState.m_61143_(ATTACHMENT));
                return belowShape == BranchShape.BRANCH || belowShape == BranchShape.BASE_BRANCH || belowShape == BranchShape.BASE_BRANCH_UPWARD;
            }
        }
        return belowState.m_60713_((Block)this) || (Boolean)state.m_61143_((Property)BRANCH) == false && belowState.m_204336_(BlockTags.f_13029_);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState state2, LevelAccessor level, BlockPos pos, BlockPos pos1) {
        if (state.m_60734_() instanceof SaguaroCactusBlock && state.m_61143_(ATTACHMENT) == BranchShape.BASE_BRANCH) {
            return (BlockState)state.m_61124_(ATTACHMENT, (Comparable)((Object)BranchShape.BASE_BRANCH_UPWARD));
        }
        state = level.m_8055_(pos.m_7494_()).m_60734_() instanceof SaguaroCactusBlock ? (BlockState)state.m_61124_((Property)TOP, (Comparable)Boolean.valueOf(false)) : (BlockState)state.m_61124_((Property)TOP, (Comparable)Boolean.valueOf(true));
        if (!state.m_60710_((LevelReader)level, pos)) {
            level.m_46961_(pos, true);
        }
        return state;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState oppositeFace = context.m_43725_().m_8055_(context.m_8083_().m_121945_(context.m_43719_().m_122424_()));
        BlockPos abovePos = context.m_8083_().m_7494_();
        BlockState aboveState = context.m_43725_().m_8055_(abovePos);
        boolean flag = !aboveState.m_60795_();
        BlockState state = (BlockState)this.m_49966_().m_61124_((Property)TOP, (Comparable)Boolean.valueOf(flag));
        if (oppositeFace.m_60713_((Block)this)) {
            if (oppositeFace.m_61143_(ATTACHMENT) == BranchShape.BASE && context.m_43719_() == Direction.UP) {
                state = (BlockState)((BlockState)this.m_49966_().m_61124_(ATTACHMENT, (Comparable)((Object)BranchShape.BASE))).m_61124_((Property)TOP, (Comparable)Boolean.valueOf(flag));
            }
            if (oppositeFace.m_61143_(ATTACHMENT) == BranchShape.BASE && context.m_43719_().m_122434_().m_122479_()) {
                state = (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)BRANCH, (Comparable)Boolean.valueOf(true))).m_61124_((Property)TOP, (Comparable)Boolean.valueOf(flag))).m_61124_(ATTACHMENT, (Comparable)((Object)BranchShape.BASE_BRANCH))).m_61124_((Property)FACING, (Comparable)context.m_43719_().m_122424_());
            }
            if (((BranchShape)((Object)oppositeFace.m_61143_(ATTACHMENT))).ordinal() >= BranchShape.BASE_BRANCH.ordinal() && context.m_43719_() == Direction.UP) {
                state = (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)BRANCH, (Comparable)Boolean.valueOf(true))).m_61124_((Property)TOP, (Comparable)Boolean.valueOf(flag))).m_61124_(ATTACHMENT, (Comparable)((Object)BranchShape.BRANCH))).m_61124_((Property)FACING, (Comparable)((Direction)oppositeFace.m_61143_((Property)FACING)));
            }
        }
        return state;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return this.m_5940_(state, getter, pos, context);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        if (state.m_61143_(ATTACHMENT) == BranchShape.BASE_BRANCH) {
            return switch ((Direction)state.m_61143_((Property)FACING)) {
                case Direction.NORTH -> Block.m_49796_((double)3.0, (double)2.0, (double)-2.0, (double)13.0, (double)12.0, (double)13.0);
                case Direction.SOUTH -> Block.m_49796_((double)3.0, (double)2.0, (double)3.0, (double)13.0, (double)12.0, (double)18.0);
                case Direction.WEST -> Block.m_49796_((double)-2.0, (double)2.0, (double)3.0, (double)13.0, (double)12.0, (double)13.0);
                default -> Block.m_49796_((double)3.0, (double)2.0, (double)3.0, (double)18.0, (double)12.0, (double)13.0);
            };
        }
        if (state.m_61143_(ATTACHMENT) == BranchShape.BASE_BRANCH_UPWARD) {
            return switch ((Direction)state.m_61143_((Property)FACING)) {
                case Direction.NORTH -> Shapes.m_83110_((VoxelShape)Block.m_49796_((double)3.0, (double)2.0, (double)-2.0, (double)13.0, (double)12.0, (double)13.0), (VoxelShape)Block.m_49796_((double)3.0, (double)2.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0));
                case Direction.SOUTH -> Shapes.m_83110_((VoxelShape)Block.m_49796_((double)3.0, (double)2.0, (double)3.0, (double)13.0, (double)12.0, (double)18.0), (VoxelShape)Block.m_49796_((double)3.0, (double)2.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0));
                case Direction.WEST -> Shapes.m_83110_((VoxelShape)Block.m_49796_((double)-2.0, (double)2.0, (double)3.0, (double)13.0, (double)12.0, (double)13.0), (VoxelShape)Block.m_49796_((double)3.0, (double)2.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0));
                default -> Shapes.m_83110_((VoxelShape)Block.m_49796_((double)3.0, (double)2.0, (double)3.0, (double)18.0, (double)12.0, (double)13.0), (VoxelShape)Block.m_49796_((double)3.0, (double)2.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0));
            };
        }
        if (state.m_61143_(ATTACHMENT) == BranchShape.BRANCH) {
            return Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
        }
        return Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_150930_(Items.f_42574_) && !((Boolean)state.m_61143_((Property)CUT)).booleanValue()) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)CUT, (Comparable)Boolean.valueOf(true)), 11);
            if (!player.m_7500_()) {
                stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
            }
            level.m_5594_(player, pos, SoundEvents.f_184217_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE, ATTACHMENT, FACING, BRANCH, NATURAL, CUT, TOP});
    }

    public static enum BranchShape implements StringRepresentable
    {
        BASE("base"),
        BASE_BRANCH("base_branch"),
        BASE_BRANCH_UPWARD("base_branch_upward"),
        BRANCH("branch");

        private final String name;

        private BranchShape(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

