/*
 * Decompiled with CFR 0.152.
 */
package com.mysticsbiomes.common.block;

import com.mysticsbiomes.init.MysticBlocks;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BambooLeaves;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.ToolActions;

public class SpringBambooStalkBlock
extends Block
implements BonemealableBlock,
IPlantable {
    protected static final VoxelShape SMALL_SHAPE = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    protected static final VoxelShape LARGE_SHAPE = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    protected static final VoxelShape COLLISION_SHAPE = Block.m_49796_((double)6.5, (double)0.0, (double)6.5, (double)9.5, (double)16.0, (double)9.5);
    public static final IntegerProperty AGE = BlockStateProperties.f_61405_;
    public static final EnumProperty<BambooLeaves> LEAVES = BlockStateProperties.f_61400_;
    public static final IntegerProperty STAGE = BlockStateProperties.f_61387_;

    public SpringBambooStalkBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_(LEAVES, (Comparable)BambooLeaves.NONE)).m_61124_((Property)STAGE, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE, LEAVES, STAGE});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        VoxelShape shape = state.m_61143_(LEAVES) == BambooLeaves.LARGE ? LARGE_SHAPE : SMALL_SHAPE;
        Vec3 vec3 = state.m_60824_(getter, pos);
        return shape.m_83216_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        Vec3 vec3 = state.m_60824_(getter, pos);
        return COLLISION_SHAPE.m_83216_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        if (!fluidState.m_76178_()) {
            return null;
        }
        BlockState belowState = context.m_43725_().m_8055_(context.m_8083_().m_7495_());
        if (belowState.m_204336_(BlockTags.f_144274_) || belowState.m_204336_(BlockTags.f_13029_) || belowState.m_60713_((Block)MysticBlocks.SPRING_BAMBOO.get()) || belowState.m_60713_((Block)MysticBlocks.SPRING_BAMBOO_SAPLING.get())) {
            if (belowState.m_60713_((Block)MysticBlocks.SPRING_BAMBOO_SAPLING.get())) {
                return (BlockState)this.m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(0));
            }
            if (belowState.m_60713_((Block)MysticBlocks.SPRING_BAMBOO.get())) {
                int i = (Integer)belowState.m_61143_((Property)AGE) > 0 ? 1 : 0;
                return (BlockState)this.m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(i));
            }
            BlockState aboveState = context.m_43725_().m_8055_(context.m_8083_().m_7494_());
            return aboveState.m_60713_((Block)MysticBlocks.SPRING_BAMBOO.get()) ? (BlockState)this.m_49966_().m_61124_((Property)AGE, (Comparable)((Integer)aboveState.m_61143_((Property)AGE))) : ((Block)MysticBlocks.SPRING_BAMBOO_SAPLING.get()).m_49966_();
        }
        return null;
    }

    public BlockState getPlant(BlockGetter world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        return state.m_60734_() != this ? this.m_49966_() : state;
    }

    public float m_5880_(BlockState state, Player player, BlockGetter getter, BlockPos pos) {
        return player.m_21205_().canPerformAction(ToolActions.SWORD_DIG) ? 1.0f : super.m_5880_(state, player, getter, pos);
    }

    public boolean m_6724_(BlockState state) {
        return (Integer)state.m_61143_((Property)STAGE) == 0;
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource source) {
        if (!state.m_60710_((LevelReader)level, pos)) {
            level.m_46961_(pos, true);
        }
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource source) {
        int i;
        if ((Integer)state.m_61143_((Property)STAGE) == 0 && level.m_46859_(pos.m_7494_()) && level.m_45524_(pos.m_7494_(), 0) >= 9 && (i = this.getHeightBelowUpToMax((BlockGetter)level, pos) + 1) < 16 && ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (source.m_188503_(3) == 0 ? 1 : 0) != 0)) {
            this.growBamboo(state, (Level)level, pos, source, i);
            ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    public boolean m_7420_(BlockState state, BlockGetter getter, BlockPos pos) {
        return true;
    }

    public boolean m_7357_(BlockState state, BlockGetter getter, BlockPos pos, PathComputationType type) {
        return false;
    }

    public boolean m_180643_(BlockState state, BlockGetter getter, BlockPos pos) {
        return false;
    }

    public boolean m_7898_(BlockState state, LevelReader reader, BlockPos pos) {
        BlockState belowState = reader.m_8055_(pos.m_7495_());
        return belowState.m_204336_(BlockTags.f_144274_) || belowState.m_204336_(BlockTags.f_13029_) || belowState.m_60713_((Block)MysticBlocks.SPRING_BAMBOO.get()) || belowState.m_60713_((Block)MysticBlocks.SPRING_BAMBOO_SAPLING.get());
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState state2, LevelAccessor accessor, BlockPos pos, BlockPos pos2) {
        if (!state.m_60710_((LevelReader)accessor, pos)) {
            accessor.m_186460_(pos, (Block)this, 1);
        }
        if (direction == Direction.UP && state2.m_60713_((Block)MysticBlocks.SPRING_BAMBOO.get()) && (Integer)state2.m_61143_((Property)AGE) > (Integer)state.m_61143_((Property)AGE)) {
            accessor.m_7731_(pos, (BlockState)state.m_61122_((Property)AGE), 2);
        }
        return super.m_7417_(state, direction, state2, accessor, pos, pos2);
    }

    public boolean m_7370_(LevelReader reader, BlockPos pos, BlockState state, boolean valid) {
        int j;
        int i = this.getHeightAboveUpToMax((BlockGetter)reader, pos);
        return i + (j = this.getHeightBelowUpToMax((BlockGetter)reader, pos)) + 1 < 16 && (Integer)reader.m_8055_(pos.m_6630_(i)).m_61143_((Property)STAGE) != 1;
    }

    public boolean m_214167_(Level level, RandomSource source, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel level, RandomSource source, BlockPos pos, BlockState state) {
        int i = this.getHeightAboveUpToMax((BlockGetter)level, pos);
        int j = this.getHeightBelowUpToMax((BlockGetter)level, pos);
        int k = i + j + 1;
        int l = 1 + source.m_188503_(2);
        for (int i1 = 0; i1 < l; ++i1) {
            BlockPos abovePos = pos.m_6630_(i);
            BlockState aboveState = level.m_8055_(abovePos);
            if (k >= 16 || (Integer)aboveState.m_61143_((Property)STAGE) == 1 || !level.m_46859_(abovePos.m_7494_())) {
                return;
            }
            this.growBamboo(aboveState, (Level)level, abovePos, source, k);
            ++i;
            ++k;
        }
    }

    protected void growBamboo(BlockState state, Level level, BlockPos pos, RandomSource source, int age) {
        BlockState belowState = level.m_8055_(pos.m_7495_());
        BlockPos belowPos = pos.m_6625_(2);
        BlockState belowState2 = level.m_8055_(belowPos);
        BambooLeaves leaves = BambooLeaves.NONE;
        if (age >= 1) {
            if (belowState.m_60713_((Block)MysticBlocks.SPRING_BAMBOO.get()) && belowState.m_61143_(LEAVES) != BambooLeaves.NONE) {
                if (belowState.m_60713_((Block)MysticBlocks.SPRING_BAMBOO.get()) && belowState.m_61143_(LEAVES) != BambooLeaves.NONE) {
                    leaves = BambooLeaves.LARGE;
                    if (belowState2.m_60713_((Block)MysticBlocks.SPRING_BAMBOO.get())) {
                        level.m_7731_(pos.m_7495_(), (BlockState)belowState.m_61124_(LEAVES, (Comparable)BambooLeaves.SMALL), 3);
                        level.m_7731_(belowPos, (BlockState)belowState2.m_61124_(LEAVES, (Comparable)BambooLeaves.NONE), 3);
                    }
                }
            } else {
                leaves = BambooLeaves.SMALL;
            }
        }
        int i = (Integer)state.m_61143_((Property)AGE) != 1 && !belowState2.m_60713_((Block)MysticBlocks.SPRING_BAMBOO.get()) ? 0 : 1;
        int j = !(age >= 11 && source.m_188501_() < 0.25f || age == 15) ? 0 : 1;
        level.m_7731_(pos.m_7494_(), (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(i))).m_61124_(LEAVES, (Comparable)leaves)).m_61124_((Property)STAGE, (Comparable)Integer.valueOf(j)), 3);
    }

    protected int getHeightAboveUpToMax(BlockGetter getter, BlockPos pos) {
        int i;
        for (i = 0; i < 16 && getter.m_8055_(pos.m_6630_(i + 1)).m_60713_((Block)MysticBlocks.SPRING_BAMBOO.get()); ++i) {
        }
        return i;
    }

    protected int getHeightBelowUpToMax(BlockGetter getter, BlockPos pos) {
        int i;
        for (i = 0; i < 16 && getter.m_8055_(pos.m_6625_(i + 1)).m_60713_((Block)MysticBlocks.SPRING_BAMBOO.get()); ++i) {
        }
        return i;
    }
}

