/*
 * Decompiled with CFR 0.152.
 */
package com.mysticsbiomes.common.block;

import com.mysticsbiomes.init.MysticItems;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.Tags;

public class StrawberryBushBlock
extends BushBlock
implements BonemealableBlock {
    public static final IntegerProperty AGE = IntegerProperty.m_61631_((String)"age", (int)0, (int)6);
    public static final BooleanProperty CUT = BooleanProperty.m_61465_((String)"cropped");
    public static final BooleanProperty CONDITION = BooleanProperty.m_61465_((String)"perfect_condition");
    public static final BooleanProperty MODIFIED = BooleanProperty.m_61465_((String)"modified");
    private static final VoxelShape SEEDLING_SHAPE = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)5.0, (double)13.0);
    private static final VoxelShape FLOWERING_SHAPE = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)9.0, (double)13.0);
    private static final VoxelShape MATURE_SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)11.0, (double)14.0);

    public StrawberryBushBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)CUT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)CONDITION, (Comparable)Boolean.valueOf(false))).m_61124_((Property)MODIFIED, (Comparable)Boolean.valueOf(false)));
    }

    public ItemStack m_7397_(BlockGetter getter, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)MysticItems.STRAWBERRY.get());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        if ((Integer)state.m_61143_((Property)AGE) < 3) {
            return SEEDLING_SHAPE;
        }
        return (Integer)state.m_61143_((Property)AGE) < 5 ? FLOWERING_SHAPE : MATURE_SHAPE;
    }

    public boolean m_6724_(BlockState state) {
        return (Integer)state.m_61143_((Property)AGE) < 6 && (Boolean)state.m_61143_((Property)CUT) == false;
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if ((Integer)state.m_61143_((Property)AGE) < 6) {
            float f = this.calculateGrowthSpeed((Level)level, pos);
            if (f <= 142.0f && !((Boolean)state.m_61143_((Property)MODIFIED)).booleanValue()) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)CONDITION, (Comparable)Boolean.TRUE), 11);
            }
            if (!(f <= 0.0f) && ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (random.m_188503_((int)f) == 0 ? 1 : 0) != 0)) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)AGE) + 1)), 2);
                level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223722_((BlockState)state));
                ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
            }
        }
    }

    private float calculateGrowthSpeed(Level level, BlockPos pos) {
        float temperature = ((Biome)level.m_204166_(pos).get()).m_47554_();
        float brightness = level.m_45524_(pos.m_7494_(), 0);
        float speed = 142.0f;
        if (temperature < 0.95f && brightness >= 7.0f) {
            speed /= temperature;
        } else if (temperature <= 0.0f) {
            speed = 0.0f;
        }
        BlockState belowState = level.m_8055_(pos.m_7495_());
        boolean fertile = belowState.canSustainPlant((BlockGetter)level, pos.m_7495_(), Direction.UP, (IPlantable)this) && belowState.isFertile((BlockGetter)level, pos);
        speed = fertile ? speed * 0.65f : speed;
        return Math.max(speed, 0.0f);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_204117_(Tags.Items.SHEARS) && !((Boolean)state.m_61143_((Property)CUT)).booleanValue()) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CriteriaTriggers.f_10562_.m_285767_(serverPlayer, pos, stack);
            }
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)CUT, (Comparable)Boolean.TRUE), 11);
            stack.m_41622_(1, (LivingEntity)player, blockState -> blockState.m_21190_(hand));
            level.m_5594_(player, pos, SoundEvents.f_184217_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if ((Integer)state.m_61143_((Property)AGE) == 6) {
            if (((Boolean)state.m_61143_((Property)CONDITION)).booleanValue() && level.f_46441_.m_188503_(64) == 0) {
                StrawberryBushBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)MysticItems.SWEET_STRAWBERRY.get(), 1));
            }
            StrawberryBushBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)MysticItems.STRAWBERRY.get(), 1 + level.f_46441_.m_188503_(3)));
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(2)), 2);
            level.m_5594_(null, pos, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return super.m_6227_(state, level, pos, player, hand, result);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE}).m_61104_(new Property[]{CUT}).m_61104_(new Property[]{CONDITION}).m_61104_(new Property[]{MODIFIED});
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean valid) {
        return (Integer)state.m_61143_((Property)AGE) < 6;
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        int i = Math.min(6, (Integer)state.m_61143_((Property)AGE) + 1);
        level.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(i))).m_61124_((Property)MODIFIED, (Comparable)Boolean.TRUE), 6);
    }
}

