/*
 * Decompiled with CFR 0.152.
 */
package com.mysticsbiomes.common.block.entity;

import com.mysticsbiomes.common.block.ButterflyNestBlock;
import com.mysticsbiomes.common.entity.animal.Butterfly;
import com.mysticsbiomes.init.MysticBlockEntities;
import com.mysticsbiomes.init.MysticBlocks;
import com.mysticsbiomes.init.MysticSounds;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;

public class ButterflyNestBlockEntity
extends BlockEntity {
    private static final List<String> IGNORED_TAGS = Arrays.asList("Air", "ArmorDropChances", "ArmorItems", "Brain", "CanPickUpLoot", "DeathTime", "FallDistance", "FallFlying", "Fire", "HandDropChances", "HandItems", "HurtByTimestamp", "HurtTime", "LeftHanded", "Motion", "NoGravity", "OnGround", "PortalCooldown", "Pos", "Rotation", "Passengers", "Leash");
    private final List<ButterflyData> stored = new ArrayList<ButterflyData>();

    public ButterflyNestBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)MysticBlockEntities.BUTTERFLY_NEST.get(), pos, state);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("Butterflies", (Tag)this.writeButterflies());
    }

    public ListTag writeButterflies() {
        ListTag list = new ListTag();
        for (ButterflyData data : this.stored) {
            CompoundTag tag = data.entityData.m_6426_();
            tag.m_128473_("UUID");
            CompoundTag tag1 = new CompoundTag();
            tag1.m_128365_("EntityData", (Tag)tag);
            tag1.m_128405_("TicksInNest", data.ticksInNest);
            tag1.m_128405_("MinOccupationTicks", data.minOccupationTicks);
            list.add((Object)tag1);
        }
        return list;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.stored.clear();
        ListTag list = tag.m_128437_("Butterflies", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag tag1 = list.m_128728_(i);
            ButterflyData data = new ButterflyData(tag1.m_128469_("EntityData"), tag1.m_128451_("TicksInNest"), tag1.m_128451_("MinOccupationTicks"));
            this.stored.add(data);
        }
    }

    static void removeIgnoredTags(CompoundTag tag) {
        for (String s : IGNORED_TAGS) {
            tag.m_128473_(s);
        }
    }

    public boolean isEmpty() {
        return this.stored.isEmpty();
    }

    public boolean isFull() {
        return this.stored.size() == 3;
    }

    public boolean isFireNearby() {
        if (this.f_58857_ != null) {
            for (BlockPos pos : BlockPos.m_121940_((BlockPos)this.f_58858_.m_7918_(-1, -1, -1), (BlockPos)this.f_58858_.m_7918_(1, 1, 1))) {
                if (!(this.f_58857_.m_8055_(pos).m_60734_() instanceof FireBlock)) continue;
                return true;
            }
        }
        return false;
    }

    public void addOccupant(Entity entity, boolean hasNectar) {
        this.addOccupantWithPresetTicks(entity, hasNectar, 0);
    }

    public void addOccupantWithPresetTicks(Entity entity, boolean hasNectar, int ticksInNest) {
        if (this.stored.size() < 3) {
            entity.m_8127_();
            entity.m_20153_();
            CompoundTag tag = new CompoundTag();
            entity.m_20223_(tag);
            this.storeButterfly(tag, ticksInNest, hasNectar);
            if (this.f_58857_ != null) {
                BlockPos pos = this.m_58899_();
                this.f_58857_.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (SoundEvent)MysticSounds.BUTTERFLY_NEST_ENTER.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                this.f_58857_.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223719_((Entity)entity, (BlockState)this.m_58900_()));
            }
            entity.m_146870_();
            super.m_6596_();
        }
    }

    public void storeButterfly(CompoundTag tag, int ticksInNest, boolean hasNectar) {
        this.stored.add(new ButterflyData(tag, ticksInNest, hasNectar ? 2400 : 600));
    }

    public void emptyAllLivingFromNest(@Nullable Player player, BlockState state, ReleaseStatus status) {
        List<Entity> list = this.releaseAllOccupants(state, status);
        if (player != null) {
            for (Entity entity : list) {
                if (!(entity instanceof Butterfly)) continue;
                Butterfly butterfly = (Butterfly)entity;
                if (!(player.m_20182_().m_82557_(entity.m_20182_()) <= 16.0)) continue;
                butterfly.setStayOutOfNestCountdown(400);
            }
        }
    }

    private List<Entity> releaseAllOccupants(BlockState state, ReleaseStatus status) {
        ArrayList<Entity> list = new ArrayList<Entity>();
        if (this.f_58857_ != null) {
            this.stored.removeIf(data -> ButterflyNestBlockEntity.releaseOccupant(this.f_58857_, this.f_58858_, state, data, list, status));
        }
        if (!list.isEmpty()) {
            super.m_6596_();
        }
        return list;
    }

    private static void setReleaseData(int i, Butterfly butterfly) {
        int age = butterfly.m_146764_();
        if (age < 0) {
            butterfly.m_146762_(Math.min(0, age + i));
        } else if (age > 0) {
            butterfly.m_146762_(Math.max(0, age - i));
        }
        butterfly.m_27601_(Math.max(0, butterfly.m_27591_() - i));
    }

    private static boolean releaseOccupant(Level level, BlockPos pos, BlockState state, ButterflyData data, @Nullable List<Entity> occupants, ReleaseStatus status) {
        boolean flag;
        if ((level.m_46462_() || level.m_46471_()) && status != ReleaseStatus.EMERGENCY) {
            return false;
        }
        CompoundTag tag = data.entityData.m_6426_();
        ButterflyNestBlockEntity.removeIgnoredTags(tag);
        tag.m_128365_("NestPos", (Tag)NbtUtils.m_129224_((BlockPos)pos));
        tag.m_128379_("NoGravity", true);
        Direction direction = (Direction)state.m_61143_((Property)ButterflyNestBlock.FACING);
        BlockPos relativePos = pos.m_121945_(direction);
        boolean bl = flag = !level.m_8055_(relativePos).m_60812_((BlockGetter)level, relativePos).m_83281_();
        if (flag && status != ReleaseStatus.EMERGENCY) {
            return false;
        }
        Entity entity = EntityType.m_20645_((CompoundTag)tag, (Level)level, e -> e);
        if (entity != null) {
            if (entity instanceof Butterfly) {
                Butterfly butterfly = (Butterfly)entity;
                float f = entity.m_20205_();
                double d3 = flag ? 0.0 : 0.55 + (double)(f / 2.0f);
                double d0 = (double)pos.m_123341_() + 0.5 + d3 * (double)direction.m_122429_();
                double d1 = (double)pos.m_123342_() + 0.5 - (double)(entity.m_20206_() / 2.0f);
                double d2 = (double)pos.m_123343_() + 0.5 + d3 * (double)direction.m_122431_();
                butterfly.setStayOutOfNestCountdown(400);
                butterfly.setInNest(false);
                if (status == ReleaseStatus.NECTAR_DELIVERED) {
                    int i;
                    butterfly.dropOffNectar();
                    if (state.m_60713_((Block)MysticBlocks.BUTTERFLY_NEST.get()) && (i = ((Integer)state.m_61143_((Property)ButterflyNestBlock.NECTAR_LEVEL)).intValue()) < 12) {
                        level.m_46597_(pos, (BlockState)state.m_61124_((Property)ButterflyNestBlock.NECTAR_LEVEL, (Comparable)Integer.valueOf(i + butterfly.getNectarPoints())));
                    }
                }
                if (status == ReleaseStatus.SLEEPING) {
                    butterfly.setSleeping(false);
                    butterfly.setTicksSinceLastSlept(0);
                }
                ButterflyNestBlockEntity.setReleaseData(data.ticksInNest, butterfly);
                if (occupants != null) {
                    occupants.add((Entity)butterfly);
                }
                entity.m_7678_(d0, d1, d2, entity.m_146908_(), entity.m_146909_());
            }
            level.m_5594_(null, pos, (SoundEvent)MysticSounds.BUTTERFLY_NEST_EXIT.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223719_((Entity)entity, (BlockState)level.m_8055_(pos)));
            return level.m_7967_(entity);
        }
        return false;
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, ButterflyNestBlockEntity entity) {
        ButterflyNestBlockEntity.tickOccupants(level, pos, state, entity.stored);
        for (ButterflyData data : entity.stored) {
            if (entity.stored.isEmpty() || !(level.m_213780_().m_188500_() < 0.075) || !data.entityData.m_128471_("IsBreeding") || !(level instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123750_, Mth.m_14139_((double)level.f_46441_.m_188500_(), (double)((double)pos.m_123341_() - (double)0.4f), (double)((double)pos.m_123341_() + (double)0.4f)) + 0.5, (double)pos.m_7494_().m_123342_(), Mth.m_14139_((double)level.f_46441_.m_188500_(), (double)((double)pos.m_123343_() - (double)0.4f), (double)((double)pos.m_123343_() + (double)0.4f)) + 0.5, 0, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private static void tickOccupants(Level level, BlockPos pos, BlockState state, List<ButterflyData> list) {
        boolean flag = false;
        Iterator<ButterflyData> iterator = list.iterator();
        while (iterator.hasNext()) {
            ReleaseStatus releaseStatus;
            ButterflyData data = iterator.next();
            if (data.ticksInNest > data.minOccupationTicks && ButterflyNestBlockEntity.releaseOccupant(level, pos, state, data, null, releaseStatus = data.entityData.m_128451_("NectarPoints") > 0 ? ReleaseStatus.NECTAR_DELIVERED : (data.entityData.m_128471_("IsSleeping") ? ReleaseStatus.SLEEPING : ReleaseStatus.RELEASED))) {
                flag = true;
                iterator.remove();
            }
            ++data.ticksInNest;
        }
        if (flag) {
            ButterflyNestBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    static class ButterflyData {
        final CompoundTag entityData;
        int ticksInNest;
        final int minOccupationTicks;

        ButterflyData(CompoundTag tag, int ticksInNest, int minTicks) {
            ButterflyNestBlockEntity.removeIgnoredTags(tag);
            this.entityData = tag;
            this.ticksInNest = ticksInNest;
            this.minOccupationTicks = minTicks;
        }
    }

    public static enum ReleaseStatus {
        NECTAR_DELIVERED,
        SLEEPING,
        RELEASED,
        EMERGENCY;

    }
}

