/*
 * Decompiled with CFR 0.152.
 */
package com.mysticsbiomes.common.entity;

import com.mysticsbiomes.init.MysticBlocks;
import com.mysticsbiomes.init.MysticEntities;
import com.mysticsbiomes.init.MysticItems;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class MysticBoat
extends Boat {
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE = SynchedEntityData.m_135353_(MysticBoat.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public MysticBoat(EntityType<? extends Boat> type, Level level) {
        super(type, level);
        this.f_19850_ = true;
    }

    public MysticBoat(Level level, double x, double y, double z) {
        this((EntityType<? extends Boat>)((EntityType)MysticEntities.BOAT.get()), level);
        this.m_6034_(x, y, z);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_TYPE, (Object)Type.STRAWBERRY.ordinal());
    }

    protected void m_7380_(CompoundTag nbt) {
        nbt.m_128359_("model", this.getModel().getName());
    }

    protected void m_7378_(CompoundTag nbt) {
        if (nbt.m_128425_("model", 8)) {
            this.f_19804_.m_135381_(DATA_ID_TYPE, (Object)Type.byName(nbt.m_128461_("model")).ordinal());
        }
    }

    protected void m_7840_(double y, boolean onGround, @Nonnull BlockState state, @Nonnull BlockPos pos) {
        this.f_38281_ = this.m_20184_().f_82480_;
        if (!this.m_20159_()) {
            if (onGround) {
                if (this.f_19789_ > 3.0f) {
                    if (this.f_38279_ != Boat.Status.ON_LAND) {
                        this.m_183634_();
                        return;
                    }
                    this.m_142535_(this.f_19789_, 1.0f, this.m_269291_().m_268989_());
                    if (!this.m_9236_().f_46443_ && !this.m_213877_()) {
                        this.m_6074_();
                        if (this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
                            for (int i = 0; i < 3; ++i) {
                                this.m_19998_((ItemLike)this.getModel().getPlanks());
                            }
                            for (int j = 0; j < 2; ++j) {
                                this.m_19998_((ItemLike)Items.f_42398_);
                            }
                        }
                    }
                }
                this.m_183634_();
            } else if (!this.m_9236_().m_6425_(this.m_20183_().m_7495_()).m_205070_(FluidTags.f_13131_) && y < 0.0) {
                this.f_19789_ -= (float)y;
            }
        }
    }

    public Item m_38369_() {
        return switch (Type.byId((Integer)this.f_19804_.m_135370_(DATA_ID_TYPE))) {
            default -> throw new IncompatibleClassChangeError();
            case Type.STRAWBERRY -> (Item)MysticItems.STRAWBERRY_BOAT.get();
            case Type.CHERRY -> (Item)MysticItems.CHERRY_BOAT.get();
            case Type.PEACH -> (Item)MysticItems.PEACH_BOAT.get();
            case Type.MAPLE -> (Item)MysticItems.MAPLE_BOAT.get();
            case Type.SEA_FOAM -> (Item)MysticItems.SEA_FOAM_BOAT.get();
            case Type.TROPICAL -> (Item)MysticItems.TROPICAL_BOAT.get();
            case Type.JACARANDA -> (Item)MysticItems.JACARANDA_BOAT.get();
        };
    }

    public Type getModel() {
        return Type.byId((Integer)this.f_19804_.m_135370_(DATA_ID_TYPE));
    }

    public void setModel(Type type) {
        this.f_19804_.m_135381_(DATA_ID_TYPE, (Object)type.ordinal());
    }

    public static enum Type {
        STRAWBERRY((Block)MysticBlocks.STRAWBERRY_PLANKS.get(), "strawberry"),
        CHERRY((Block)MysticBlocks.CHERRY_PLANKS.get(), "cherry"),
        PEACH((Block)MysticBlocks.PEACH_PLANKS.get(), "peach"),
        MAPLE((Block)MysticBlocks.MAPLE_PLANKS.get(), "maple"),
        SEA_FOAM((Block)MysticBlocks.SEA_FOAM_PLANKS.get(), "sea_foam"),
        TROPICAL((Block)MysticBlocks.TROPICAL_PLANKS.get(), "tropical"),
        JACARANDA((Block)MysticBlocks.JACARANDA_PLANKS.get(), "jacaranda");

        private final String name;
        private final Block planks;

        private Type(Block block, String name) {
            this.name = name;
            this.planks = block;
        }

        public String getName() {
            return this.name;
        }

        public Block getPlanks() {
            return this.planks;
        }

        public String toString() {
            return this.name;
        }

        public static Type byId(int id) {
            Type[] types = Type.values();
            if (id < 0 || id >= types.length) {
                id = 0;
            }
            return types[id];
        }

        public static Type byName(String name) {
            Type[] types;
            for (Type type : types = Type.values()) {
                if (!type.getName().equals(name)) continue;
                return type;
            }
            return types[0];
        }
    }
}

