/*
 * Decompiled with CFR 0.152.
 */
package com.mysticsbiomes.common.entity.animal;

import com.google.common.collect.Maps;
import com.mysticsbiomes.common.block.entity.ButterflyNestBlockEntity;
import com.mysticsbiomes.init.MysticBlocks;
import com.mysticsbiomes.init.MysticPoiTypes;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.AirRandomPos;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Butterfly
extends Animal
implements FlyingAnimal {
    private static final EntityDataAccessor<Integer> DATA_TYPE_ID = SynchedEntityData.m_135353_(Butterfly.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(Butterfly.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private boolean sleeping;
    private boolean isInNest;
    private int ticksSinceLastSlept;
    private int stayOutOfNestCountdown;
    private int ticksBeforeLocatingNewNest;
    private int ticksSincePollinated;
    private int nectarPoints;
    @Nullable
    private BlockPos nestPos;
    @Nullable
    private Block givenFlower;
    PollinateGoal pollinateGoal;
    SpreadFlowersGoal spreadFlowersGoal;
    public AnimationState flyingAnimationState = new AnimationState();

    public Butterfly(EntityType<? extends Butterfly> type, Level level) {
        super(type, level);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, true);
        this.f_21365_ = new ButterflyLookControl();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_TYPE_ID, (Object)0);
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
    }

    protected void m_8099_() {
        this.spreadFlowersGoal = new SpreadFlowersGoal();
        this.f_21345_.m_25352_(0, (Goal)this.spreadFlowersGoal);
        this.f_21345_.m_25352_(1, (Goal)new TemptGoal((PathfinderMob)this, 1.25, Ingredient.m_204132_((TagKey)ItemTags.f_13149_), false));
        this.pollinateGoal = new PollinateGoal();
        this.f_21345_.m_25352_(2, (Goal)this.pollinateGoal);
        this.f_21345_.m_25352_(3, (Goal)new EnterNestGoal());
        this.f_21345_.m_25352_(4, (Goal)new GoToNestGoal());
        this.f_21345_.m_25352_(5, (Goal)new LocateNestGoal());
        this.f_21345_.m_25352_(6, (Goal)new WanderGoal());
        this.f_21345_.m_25352_(7, (Goal)new FloatGoal((Mob)this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22280_, (double)0.6f).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22277_, 28.0);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128359_("Type", this.getVariant().m_7912_());
        tag.m_128405_("TypeId", this.getVariant().getId());
        tag.m_128379_("HasVisibleNectar", this.hasVisibleNectar());
        tag.m_128379_("IsSleeping", this.m_5803_());
        tag.m_128379_("IsInNest", this.isInNest());
        tag.m_128405_("NectarPoints", this.nectarPoints);
        tag.m_128405_("TicksSincePollinated", this.ticksSincePollinated);
        tag.m_128405_("TicksSinceLastSlept", this.ticksSinceLastSlept);
        tag.m_128405_("CannotEnterNestTicks", this.stayOutOfNestCountdown);
        if (this.nestPos != null) {
            tag.m_128365_("NestPos", (Tag)NbtUtils.m_129224_((BlockPos)this.nestPos));
        }
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setVariant(Type.byName(tag.m_128461_("Type")));
        this.setVariant(Type.byId(tag.m_128451_("TypeId")));
        this.setHasVisibleNectar(tag.m_128471_("HasVisibleNectar"));
        this.sleeping = tag.m_128471_("IsSleeping");
        this.isInNest = tag.m_128471_("IsInNest");
        this.nectarPoints = tag.m_128451_("NectarPoints");
        this.ticksSincePollinated = tag.m_128451_("TicksSincePollinated");
        this.ticksSinceLastSlept = tag.m_128451_("TicksSinceLastSlept");
        this.stayOutOfNestCountdown = tag.m_128451_("CannotEnterNestTicks");
        this.nestPos = null;
        if (tag.m_128441_("NestPos")) {
            this.nestPos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("NestPos"));
        }
    }

    public AgeableMob m_142606_(ServerLevel level, AgeableMob mob) {
        return null;
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public Type getVariant() {
        return Type.byId((Integer)this.f_19804_.m_135370_(DATA_TYPE_ID));
    }

    public void setVariant(Type type) {
        this.f_19804_.m_135381_(DATA_TYPE_ID, (Object)type.getId());
    }

    private boolean getFlag() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 8) != 0;
    }

    private void setFlag(boolean value) {
        if (value) {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) | 8)));
        } else {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 0xFFFFFFF7)));
        }
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor accessor, DifficultyInstance instance, MobSpawnType type, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        data = super.m_6518_(accessor, instance, type, data, tag);
        this.setVariant(Type.byId(this.f_19796_.m_188503_(6)));
        return data;
    }

    public void m_8119_() {
        Level level;
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            this.flyingAnimationState.m_246184_(this.m_29443_(), this.f_19797_);
        }
        if ((level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.f_19796_.m_188501_() < 0.05f) {
                if (this.hasNectar()) {
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123782_, Mth.m_14139_((double)this.m_9236_().f_46441_.m_188500_(), (double)(this.m_20185_() - (double)0.3f), (double)(this.m_20185_() + (double)0.3f)), this.m_20227_(0.5), Mth.m_14139_((double)this.m_9236_().f_46441_.m_188500_(), (double)(this.m_20189_() - (double)0.3f), (double)(this.m_20189_() + (double)0.3f)), 0, 0.0, 0.0, 0.0, 0.0);
                }
                if (this.spreadFlowersGoal != null && this.spreadFlowersGoal.isPlantingFlower()) {
                    for (int i = 0; i < 5; ++i) {
                        double d0 = this.f_19796_.m_188583_() * 0.02;
                        double d1 = this.f_19796_.m_188583_() * 0.02;
                        double d2 = this.f_19796_.m_188583_() * 0.02;
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() - 0.5, this.m_20262_(1.0), 0, (double)((float)this.m_9236_().m_213780_().m_188503_(4) / 24.0f), d0, d1, d2);
                    }
                }
            }
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            if (this.stayOutOfNestCountdown > 0) {
                --this.stayOutOfNestCountdown;
            }
            if (this.ticksBeforeLocatingNewNest > 0) {
                --this.ticksBeforeLocatingNewNest;
            }
            if (this.f_19797_ % 20 == 0 && !this.isNestValid()) {
                this.nestPos = null;
            }
        }
    }

    protected void m_8024_() {
        super.m_8024_();
        if (!this.m_5803_()) {
            ++this.ticksSinceLastSlept;
        }
        if (this.hasNest()) {
            ++this.ticksSincePollinated;
        }
    }

    protected void angryParticle() {
        double d = this.f_19796_.m_188583_() * 0.02;
        ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123792_, this.m_20208_(1.0), this.m_20187_() - 0.25, this.m_20262_(1.0), 0, (double)((float)this.m_9236_().m_213780_().m_188503_(4) / 24.0f), d, d, d);
    }

    protected PathNavigation m_6037_(Level level) {
        FlyingPathNavigation navigation = new FlyingPathNavigation((Mob)this, level){

            public boolean m_6342_(BlockPos p_27947_) {
                return !this.f_26495_.m_8055_(p_27947_.m_7495_()).m_60795_();
            }

            public void m_7638_() {
                if (!Butterfly.this.isBusy()) {
                    super.m_7638_();
                }
            }
        };
        navigation.m_26440_(false);
        navigation.m_7008_(false);
        navigation.m_26443_(true);
        return navigation;
    }

    protected void m_7840_(double distance, boolean b, BlockState state, BlockPos pos) {
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
    }

    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return dimensions.f_20378_ * 0.5f;
    }

    public float m_5610_(BlockPos pos, LevelReader reader) {
        return reader.m_8055_(pos).m_60795_() ? 5.0f : 0.0f;
    }

    public boolean m_29443_() {
        return !this.m_20096_();
    }

    public boolean hasNest() {
        return this.nestPos != null;
    }

    private boolean isInNest() {
        return this.isInNest;
    }

    public void setInNest(boolean isInNest) {
        this.isInNest = isInNest;
    }

    private boolean isNestValid() {
        if (this.nestPos == null) {
            return false;
        }
        if (this.isTooFarAway(this.nestPos)) {
            return false;
        }
        BlockEntity blockEntity = this.m_9236_().m_7702_(this.nestPos);
        return blockEntity instanceof ButterflyNestBlockEntity;
    }

    private boolean isNestNearFire() {
        if (this.nestPos == null) {
            return false;
        }
        BlockEntity blockEntity = this.m_9236_().m_7702_(this.nestPos);
        return blockEntity instanceof ButterflyNestBlockEntity && ((ButterflyNestBlockEntity)blockEntity).isFireNearby();
    }

    private boolean doesNestHaveSpace(BlockPos pos) {
        BlockEntity blockEntity = this.m_9236_().m_7702_(pos);
        if (blockEntity instanceof ButterflyNestBlockEntity) {
            ButterflyNestBlockEntity entity = (ButterflyNestBlockEntity)blockEntity;
            return !entity.isFull();
        }
        return false;
    }

    private boolean canEnterNest() {
        return this.stayOutOfNestCountdown <= 0;
    }

    private boolean wantsToEnterNest() {
        if (this.isBusy()) {
            return false;
        }
        if (this.canEnterNest()) {
            boolean flag = this.m_9236_().m_46471_() || this.m_9236_().m_46462_() || this.isTired() || this.hasNectar();
            return flag && !this.isNestNearFire();
        }
        return false;
    }

    public void setStayOutOfNestCountdown(int ticks) {
        this.stayOutOfNestCountdown = ticks;
    }

    public boolean m_5803_() {
        return this.sleeping;
    }

    public void setSleeping(boolean sleeping) {
        this.sleeping = sleeping;
    }

    public boolean isTired() {
        return this.ticksSinceLastSlept > 18000;
    }

    public void setTicksSinceLastSlept(int ticks) {
        this.ticksSinceLastSlept = ticks;
    }

    private boolean isBusy() {
        return this.pollinateGoal.isPollinating() || this.spreadFlowersGoal.isPlantingFlower();
    }

    public boolean wasGivenFlower() {
        return this.givenFlower != null;
    }

    public boolean hasNectar() {
        return this.nectarPoints > 0;
    }

    public int getNectarPoints() {
        return this.nectarPoints;
    }

    public boolean hasVisibleNectar() {
        return this.getFlag();
    }

    public void setHasVisibleNectar(boolean hasNectar) {
        this.setFlag(hasNectar);
    }

    public void dropOffNectar() {
        this.nectarPoints = 0;
        this.setHasVisibleNectar(false);
        this.resetTicksSincePollinated();
    }

    public void resetTicksSincePollinated() {
        this.ticksSincePollinated = 0;
    }

    public boolean canPollinate() {
        return this.ticksSincePollinated >= 2400;
    }

    private boolean wantsToPollinate() {
        return this.canPollinate() && this.canEnterNest() && !this.hasNectar() && this.f_19796_.m_188503_(64) == 0;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (player.m_21120_(hand).m_204117_(ItemTags.f_13145_)) {
            if (!this.m_9236_().f_46443_) {
                if (this.canPollinate()) {
                    this.givenFlower = Block.m_49814_((Item)player.m_21120_(hand).m_41720_());
                    for (int i = 0; i < 5; ++i) {
                        ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() - 0.5, this.m_20262_(1.0), 0, (double)((float)this.m_9236_().m_213780_().m_188503_(4) / 24.0f), this.f_19796_.m_188583_() * 0.02, this.f_19796_.m_188583_() * 0.02, this.f_19796_.m_188583_() * 0.02);
                    }
                    return InteractionResult.CONSUME;
                }
                this.angryParticle();
                return InteractionResult.FAIL;
            }
            return InteractionResult.PASS;
        }
        return this.hasNest() ? super.m_6071_(player, hand) : InteractionResult.PASS;
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_204117_(ItemTags.f_13148_);
    }

    private void pathfindRandomlyTowards(BlockPos pos) {
        Vec3 vec31;
        Vec3 vec3 = Vec3.m_82539_((Vec3i)pos);
        int i = 0;
        BlockPos pos1 = this.m_20183_();
        int j = (int)vec3.f_82480_ - pos1.m_123342_();
        if (j > 2) {
            i = 4;
        } else if (j < -2) {
            i = -4;
        }
        int k = 6;
        int l = 8;
        int i1 = pos1.m_123333_((Vec3i)pos);
        if (i1 < 15) {
            k = i1 / 2;
            l = i1 / 2;
        }
        if ((vec31 = AirRandomPos.m_148387_((PathfinderMob)this, (int)k, (int)l, (int)i, (Vec3)vec3, (double)0.3141592741012573)) != null) {
            this.f_21344_.m_26529_(0.5f);
            this.f_21344_.m_26519_(vec31.f_82479_, vec31.f_82480_, vec31.f_82481_, 1.0);
        }
    }

    private boolean pathfindDirectlyTowards(BlockPos pos, double speedModifier) {
        this.f_21344_.m_26529_(10.0f);
        this.f_21344_.m_26519_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), speedModifier);
        return this.f_21344_.m_26570_() != null && this.f_21344_.m_26570_().m_77403_();
    }

    private boolean isCloserThan(BlockPos pos, int distance) {
        return pos.m_123314_((Vec3i)this.m_20183_(), (double)distance);
    }

    private boolean isTooFarAway(BlockPos pos) {
        return !this.isCloserThan(pos, 32);
    }

    private boolean hasReachedTarget(BlockPos pos) {
        if (this.isCloserThan(pos, 2)) {
            return true;
        }
        Path path = this.f_21344_.m_26570_();
        return path != null && path.m_77406_().equals((Object)pos) && path.m_77403_() && path.m_77392_();
    }

    private void setPollinatingPos(BlockPos pos) {
        Vec3 vec3 = Vec3.m_82539_((Vec3i)pos).m_82520_(0.0, (double)0.6f, 0.0);
        if (vec3.m_82554_(this.m_20182_()) > 1.0) {
            Vec3 hoverPos = vec3;
            this.m_21566_().m_6849_(hoverPos.m_7096_(), hoverPos.m_7098_(), hoverPos.m_7094_(), (double)0.35f);
        } else {
            Vec3 hoverPos = vec3;
            boolean flag = this.m_20182_().m_82554_(hoverPos) <= 0.1;
            boolean flag1 = true;
            if (flag) {
                boolean flag2;
                boolean bl = flag2 = this.f_19796_.m_188503_(25) == 0;
                if (flag2) {
                    float offset = (this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.33333334f;
                    hoverPos = new Vec3(vec3.m_7096_() + (double)offset, vec3.m_7098_(), vec3.m_7094_() + (double)offset);
                    this.f_21344_.m_26573_();
                } else {
                    flag1 = false;
                }
                this.m_21563_().m_24946_(vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_());
            }
            if (flag1) {
                this.m_21566_().m_6849_(hoverPos.m_7096_(), hoverPos.m_7098_(), hoverPos.m_7094_(), (double)0.35f);
            }
        }
    }

    class ButterflyLookControl
    extends LookControl {
        ButterflyLookControl() {
            super((Mob)Butterfly.this);
        }

        protected boolean m_8106_() {
            return !Butterfly.this.pollinateGoal.isPollinating() || !Butterfly.this.spreadFlowersGoal.isPlantingFlower();
        }
    }

    class SpreadFlowersGoal
    extends Goal {
        private int successfulTicks;
        private boolean plantingFlower;
        @Nullable
        private BlockPos emptyPos;

        SpreadFlowersGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return Butterfly.this.hasNectar() && Butterfly.this.pollinateGoal.willSpreadFlowersAfter;
        }

        public boolean m_8045_() {
            return Butterfly.this.hasNectar() && Butterfly.this.wasGivenFlower() && this.successfulTicks < 1200;
        }

        public void m_8056_() {
            this.successfulTicks = 0;
            this.emptyPos = this.findRandomEmptyPos();
        }

        public void m_8041_() {
            this.plantingFlower = false;
            if (Butterfly.this.hasNectar() && !Butterfly.this.m_9236_().f_46443_) {
                if (this.emptyPos != null) {
                    if (Butterfly.this.givenFlower != null) {
                        BlockState flowerState = Butterfly.this.givenFlower.m_49966_();
                        if (Butterfly.this.m_9236_().m_46859_(this.emptyPos) && flowerState.m_60710_((LevelReader)Butterfly.this.m_9236_(), this.emptyPos)) {
                            Butterfly.this.m_9236_().m_46597_(this.emptyPos, flowerState);
                            Butterfly.this.m_9236_().m_220407_(GameEvent.f_157797_, this.emptyPos, GameEvent.Context.m_223719_((Entity)Butterfly.this, (BlockState)flowerState));
                            Butterfly.this.m_9236_().m_5594_(null, this.emptyPos, SoundEvents.f_11991_, SoundSource.BLOCKS, 0.7f, 0.9f + Butterfly.this.f_19796_.m_188501_() * 0.2f);
                        }
                        --Butterfly.this.nectarPoints;
                        this.emptyPos = null;
                    }
                } else {
                    Butterfly.this.angryParticle();
                }
            }
            if (Butterfly.this.nectarPoints == 0) {
                Butterfly.this.setHasVisibleNectar(false);
            }
            if (Butterfly.this.nectarPoints == 0 || Butterfly.this.givenFlower == null) {
                Butterfly.this.givenFlower = null;
                Butterfly.this.pollinateGoal.flowerPos = null;
                Butterfly.this.pollinateGoal.willSpreadFlowersAfter = false;
                Butterfly.this.ticksSincePollinated = 0;
                Butterfly.this.f_21344_.m_26573_();
            }
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            int ticks = 0;
            if (this.emptyPos != null) {
                if (!Butterfly.this.hasReachedTarget(this.emptyPos)) {
                    Butterfly.this.pathfindDirectlyTowards(this.emptyPos, 0.4);
                } else {
                    this.plantingFlower = true;
                    ++this.successfulTicks;
                    Butterfly.this.setPollinatingPos(this.emptyPos);
                }
            } else {
                this.emptyPos = this.findRandomEmptyPos();
                if (++ticks > this.m_183277_(600)) {
                    this.fail();
                }
            }
        }

        private BlockPos findRandomEmptyPos() {
            HashMap map = Maps.newHashMap();
            BlockPos flowerPos = Butterfly.this.pollinateGoal.flowerPos;
            BlockPos currentPos = flowerPos != null ? flowerPos : Butterfly.this.m_20183_();
            for (int i = 0; i <= 14; ++i) {
                int x = Mth.m_14143_((float)(currentPos.m_123341_() + (Butterfly.this.f_19796_.m_188499_() ? Butterfly.this.f_19796_.m_188503_(3) : -Butterfly.this.f_19796_.m_188503_(3))));
                int y = Mth.m_14143_((float)(currentPos.m_123342_() + (Butterfly.this.f_19796_.m_188499_() ? Butterfly.this.f_19796_.m_188503_(3) : -Butterfly.this.f_19796_.m_188503_(3))));
                int z = Mth.m_14143_((float)(currentPos.m_123343_() + (Butterfly.this.f_19796_.m_188499_() ? Butterfly.this.f_19796_.m_188503_(3) : -Butterfly.this.f_19796_.m_188503_(3))));
                BlockPos pos = new BlockPos(x, y, z);
                if (!Butterfly.this.m_9236_().m_8055_(pos).m_60795_() || !Butterfly.this.m_9236_().m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50440_)) continue;
                map.put(i, pos);
            }
            return (BlockPos)map.get(0);
        }

        private void fail() {
            Butterfly.this.givenFlower = null;
        }

        public boolean isPlantingFlower() {
            return this.plantingFlower;
        }
    }

    class PollinateGoal
    extends Goal {
        private int pollinatingTicks;
        private boolean pollinating;
        private boolean willSpreadFlowersAfter;
        @Nullable
        private BlockPos flowerPos;
        private final Predicate<BlockState> VALID_POLLINATION_BLOCKS = state -> {
            if (state.m_204336_(BlockTags.f_13041_)) {
                if (state.m_60713_(Blocks.f_50355_)) {
                    return state.m_61143_((Property)DoublePlantBlock.f_52858_) == DoubleBlockHalf.UPPER;
                }
                return true;
            }
            return false;
        };

        PollinateGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (!Butterfly.this.hasNest()) {
                return false;
            }
            if (Butterfly.this.isTired()) {
                return false;
            }
            if (Butterfly.this.m_9236_().m_46471_()) {
                return false;
            }
            if (Butterfly.this.canPollinate()) {
                return Butterfly.this.wasGivenFlower() || Butterfly.this.wantsToPollinate();
            }
            return false;
        }

        public boolean m_8045_() {
            if (Butterfly.this.m_9236_().m_46471_()) {
                return false;
            }
            return this.flowerPos != null && this.pollinatingTicks < 600;
        }

        public void m_8056_() {
            this.pollinatingTicks = 0;
            Optional<BlockPos> optional = this.findNearbyFlower();
            if (optional.isPresent()) {
                this.flowerPos = optional.get();
            }
        }

        public void m_8041_() {
            this.pollinating = false;
            if (this.pollinatingTicks >= 600) {
                Butterfly.this.nectarPoints += 3;
                Butterfly.this.setHasVisibleNectar(true);
            } else {
                Butterfly.this.angryParticle();
            }
            if (!Butterfly.this.wasGivenFlower()) {
                this.flowerPos = null;
                Butterfly.this.f_21344_.m_26573_();
                Butterfly.this.ticksSincePollinated = 0;
            } else {
                this.willSpreadFlowersAfter = true;
            }
        }

        public void m_8037_() {
            Optional<BlockPos> optional = this.findNearbyFlower();
            if (optional.isEmpty()) {
                this.flowerPos = null;
                Butterfly.this.ticksSincePollinated = 2200;
            }
            if (this.flowerPos != null) {
                if (!Butterfly.this.hasReachedTarget(this.flowerPos)) {
                    Butterfly.this.pathfindDirectlyTowards(this.flowerPos, 1.0);
                } else {
                    this.pollinating = true;
                    ++this.pollinatingTicks;
                    Butterfly.this.setPollinatingPos(this.flowerPos);
                }
            }
        }

        private Optional<BlockPos> findNearbyFlower() {
            return Butterfly.this.givenFlower != null ? this.findNearestBlock(block -> block.m_60713_(Butterfly.this.givenFlower), 16.0) : this.findNearestBlock(this.VALID_POLLINATION_BLOCKS, 8.0);
        }

        private Optional<BlockPos> findNearestBlock(Predicate<BlockState> predicate, double distance) {
            BlockPos pos = Butterfly.this.m_20183_();
            BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
            int i = 0;
            while ((double)i <= distance) {
                int j = 0;
                while ((double)j < distance) {
                    int k = 0;
                    while (k <= j) {
                        int l;
                        int n = l = k < j && k > -j ? j : 0;
                        while (l <= j) {
                            mutablePos.m_122154_((Vec3i)pos, k, i - 1, l);
                            if (pos.m_123314_((Vec3i)mutablePos, distance) && predicate.test(Butterfly.this.m_9236_().m_8055_((BlockPos)mutablePos))) {
                                return Optional.of(mutablePos);
                            }
                            l = l > 0 ? -l : 1 - l;
                        }
                        k = k > 0 ? -k : 1 - k;
                    }
                    ++j;
                }
                i = i > 0 ? -i : 1 - i;
            }
            return Optional.empty();
        }

        public boolean isPollinating() {
            return this.pollinating;
        }
    }

    class EnterNestGoal
    extends Goal {
        EnterNestGoal() {
        }

        public boolean m_8036_() {
            BlockEntity blockEntity;
            if (Butterfly.this.nestPos != null && Butterfly.this.wantsToEnterNest() && Butterfly.this.nestPos.m_203195_((Position)Butterfly.this.m_20182_(), 2.0) && (blockEntity = Butterfly.this.m_9236_().m_7702_(Butterfly.this.nestPos)) instanceof ButterflyNestBlockEntity) {
                ButterflyNestBlockEntity entity = (ButterflyNestBlockEntity)blockEntity;
                return !entity.isFull();
            }
            return false;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8056_() {
            BlockEntity blockEntity;
            if (Butterfly.this.m_9236_().m_46462_() || Butterfly.this.isTired()) {
                Butterfly.this.setSleeping(true);
            }
            Butterfly.this.setInNest(true);
            if (Butterfly.this.nestPos != null && (blockEntity = Butterfly.this.m_9236_().m_7702_(Butterfly.this.nestPos)) instanceof ButterflyNestBlockEntity) {
                ButterflyNestBlockEntity entity = (ButterflyNestBlockEntity)blockEntity;
                entity.addOccupant((Entity)Butterfly.this, Butterfly.this.hasNectar());
            }
        }
    }

    class GoToNestGoal
    extends Goal {
        @Nullable
        private Path lastPath;

        GoToNestGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return Butterfly.this.nestPos != null && Butterfly.this.wantsToEnterNest() && !Butterfly.this.hasReachedTarget(Butterfly.this.nestPos) && Butterfly.this.m_9236_().m_8055_(Butterfly.this.nestPos).m_60713_((Block)MysticBlocks.BUTTERFLY_NEST.get());
        }

        public boolean m_8045_() {
            return this.m_8036_();
        }

        public void m_8041_() {
            Butterfly.this.f_21344_.m_26573_();
            Butterfly.this.f_21344_.m_26566_();
        }

        public void m_8037_() {
            if (Butterfly.this.nestPos != null && !Butterfly.this.f_21344_.m_26572_()) {
                if (!Butterfly.this.isCloserThan(Butterfly.this.nestPos, 16)) {
                    Butterfly.this.pathfindRandomlyTowards(Butterfly.this.nestPos);
                } else {
                    boolean flag = Butterfly.this.pathfindDirectlyTowards(Butterfly.this.nestPos, 1.0);
                    if (flag && this.lastPath != null && Butterfly.this.f_21344_.m_26570_() != null && !Butterfly.this.f_21344_.m_26570_().m_77385_(this.lastPath)) {
                        this.lastPath = Butterfly.this.f_21344_.m_26570_();
                    }
                }
            }
        }
    }

    class LocateNestGoal
    extends Goal {
        LocateNestGoal() {
        }

        public boolean m_8036_() {
            return Butterfly.this.ticksBeforeLocatingNewNest == 0 && Butterfly.this.nestPos == null && Butterfly.this.wantsToEnterNest();
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8056_() {
            Butterfly.this.ticksBeforeLocatingNewNest = 200;
            List<BlockPos> list = this.findNearbyNestsWithSpace();
            if (!list.isEmpty()) {
                Iterator<BlockPos> iterator = list.iterator();
                if (iterator.hasNext()) {
                    BlockPos pos;
                    Butterfly.this.nestPos = pos = iterator.next();
                    return;
                }
                Butterfly.this.nestPos = list.get(0);
            }
        }

        private List<BlockPos> findNearbyNestsWithSpace() {
            BlockPos pos = Butterfly.this.m_20183_();
            PoiManager poiManager = ((ServerLevel)Butterfly.this.m_9236_()).m_8904_();
            Stream stream = poiManager.m_27181_(holder -> holder.m_203373_(MysticPoiTypes.BUTTERFLY_NEST.getId()), pos, 20, PoiManager.Occupancy.ANY);
            return stream.map(PoiRecord::m_27257_).filter(Butterfly.this::doesNestHaveSpace).sorted(Comparator.comparingDouble(pos1 -> pos1.m_123331_((Vec3i)pos))).collect(Collectors.toList());
        }
    }

    class WanderGoal
    extends Goal {
        WanderGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return Butterfly.this.f_21344_.m_26571_();
        }

        public boolean m_8045_() {
            return Butterfly.this.f_21344_.m_26572_();
        }

        public void m_8056_() {
            Vec3 vec3 = this.findPos();
            if (vec3 != null) {
                vec3 = new Vec3(vec3.f_82479_, (double)(this.findFurthestBlockBelow(BlockPos.m_274446_((Position)vec3)) + 2), vec3.f_82481_);
                Butterfly.this.f_21344_.m_26536_(Butterfly.this.f_21344_.m_7864_(BlockPos.m_274446_((Position)vec3), 1), 1.0);
            }
        }

        private int findFurthestBlockBelow(BlockPos pos) {
            BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
            while (mutablePos.m_123342_() > 0) {
                mutablePos.m_122184_(0, -1, 0);
                if (Butterfly.this.m_9236_().m_46859_((BlockPos)mutablePos) || Butterfly.this.m_9236_().m_8055_((BlockPos)mutablePos).m_60795_() && !Butterfly.this.m_9236_().m_8055_((BlockPos)mutablePos).m_247087_()) continue;
                return mutablePos.m_123342_();
            }
            return pos.m_123342_();
        }

        @Nullable
        private Vec3 findPos() {
            Vec3 vec3;
            if (Butterfly.this.isNestValid() && Butterfly.this.nestPos != null && !Butterfly.this.isCloserThan(Butterfly.this.nestPos, 22)) {
                Vec3 vec31 = Vec3.m_82512_((Vec3i)Butterfly.this.nestPos);
                vec3 = vec31.m_82546_(Butterfly.this.m_20182_()).m_82541_();
            } else {
                vec3 = Butterfly.this.m_20252_(0.0f);
            }
            Vec3 vec32 = HoverRandomPos.m_148465_((PathfinderMob)Butterfly.this, (int)8, (int)7, (double)vec3.f_82479_, (double)vec3.f_82481_, (float)1.5707964f, (int)3, (int)1);
            return vec32 != null ? vec32 : AirAndWaterRandomPos.m_148357_((PathfinderMob)Butterfly.this, (int)8, (int)4, (int)-2, (double)vec3.f_82479_, (double)vec3.f_82481_, (double)1.5707963705062866);
        }
    }

    public static enum Type implements StringRepresentable
    {
        TANGERINE(0, "tangerine"),
        JELLY(1, "jelly"),
        JULY(2, "july"),
        CANDY(3, "candy"),
        VALENTINE(4, "valentine"),
        MYSTIC(5, "mystic");

        private final int id;
        private final String name;

        private Type(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public String m_7912_() {
            return this.name;
        }

        public static Type byId(int id) {
            return (Type)((Object)ByIdMap.m_262839_(Type::getId, (Object[])Type.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO).apply(id));
        }

        public static Type byName(String name) {
            return (Type)StringRepresentable.m_216439_(Type::values).m_262792_(name, (Enum)TANGERINE);
        }
    }
}

