/*
 * Decompiled with CFR 0.152.
 */
package com.mysticsbiomes.common.entity.animal;

import com.mysticsbiomes.init.MysticEntities;
import com.mysticsbiomes.init.MysticItems;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nonnull;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;

public class RainbowChicken
extends Animal {
    private static final EntityDataAccessor<Integer> DATA_TYPE_ID = SynchedEntityData.m_135353_(RainbowChicken.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final Ingredient FOOD_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42404_, Items.f_42578_, Items.f_42577_, Items.f_42733_, Items.f_271133_, Items.f_276594_});
    public float flap;
    public float flapSpeed;
    public float oFlapSpeed;
    public float oFlap;
    public float flapping = 1.0f;
    private float nextFlap = 1.0f;
    public int eggTime = this.f_19796_.m_188503_(6000) + 6000;

    public RainbowChicken(EntityType<? extends RainbowChicken> type, Level level) {
        super(type, level);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_TYPE_ID, (Object)0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.4));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, FOOD_ITEMS, false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 4.0).m_22268_(Attributes.f_22279_, 0.25);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128359_("Type", this.getVariant().m_7912_());
        tag.m_128405_("TypeId", this.getVariant().getId());
        tag.m_128405_("EggLayTime", this.eggTime);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setVariant(Type.byType(tag.m_128461_("Type")));
        this.setVariant(Type.byId(tag.m_128451_("TypeId")));
        if (tag.m_128441_("EggLayTime")) {
            this.eggTime = tag.m_128451_("EggLayTime");
        }
    }

    public Type getVariant() {
        return Type.byId((Integer)this.f_19804_.m_135370_(DATA_TYPE_ID));
    }

    public void setVariant(Type type) {
        this.f_19804_.m_135381_(DATA_TYPE_ID, (Object)type.getId());
    }

    public RainbowChicken getBreedOffspring(ServerLevel level, AgeableMob partner) {
        RainbowChicken baby = (RainbowChicken)((EntityType)MysticEntities.RAINBOW_CHICKEN.get()).m_20615_((Level)level);
        baby.setVariant(this.getOffspringVariant(this, (Animal)partner));
        return baby;
    }

    private Type getOffspringVariant(Animal parent1, Animal parent2) {
        Type type;
        ArrayList<Type> colorTypes = new ArrayList<Type>();
        colorTypes.add(((RainbowChicken)parent1).getVariant());
        colorTypes.add(((RainbowChicken)parent2).getVariant());
        Type type2 = type = this.m_9236_().f_46441_.m_188499_() ? (Type)((Object)colorTypes.get(0)) : (Type)((Object)colorTypes.get(1));
        if (this.m_9236_().f_46441_.m_188503_(6) == 0) {
            if (colorTypes.contains((Object)Type.PINK) && colorTypes.contains((Object)Type.YELLOW)) {
                type = Type.ORANGE;
            } else if (colorTypes.contains((Object)Type.YELLOW) && colorTypes.contains((Object)Type.CYAN)) {
                type = Type.LIME;
            } else if (colorTypes.contains((Object)Type.CYAN) && colorTypes.contains((Object)Type.PINK)) {
                type = Type.PURPLE;
            }
        }
        return type;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor accessor, DifficultyInstance instance, MobSpawnType type, SpawnGroupData data, CompoundTag tag) {
        this.setVariant(Type.getRandomVariant(accessor.m_213780_()));
        return super.m_6518_(accessor, instance, type, data, tag);
    }

    public Component m_7755_() {
        return Component.m_237115_((String)("entity.mysticsbiomes.rainbow_chicken." + this.getVariant().type));
    }

    public void m_8107_() {
        super.m_8107_();
        this.oFlap = this.flap;
        this.oFlapSpeed = this.flapSpeed;
        this.flapSpeed += (this.m_20096_() ? -1.0f : 4.0f) * 0.3f;
        this.flapSpeed = Mth.m_14036_((float)this.flapSpeed, (float)0.0f, (float)1.0f);
        if (!this.m_20096_() && this.flapping < 1.0f) {
            this.flapping = 1.0f;
        }
        this.flapping *= 0.9f;
        Vec3 vec3 = this.m_20184_();
        if (!this.m_20096_() && vec3.f_82480_ < 0.0) {
            this.m_20256_(vec3.m_82542_(1.0, 0.6, 1.0));
        }
        this.flap += this.flapping * 2.0f;
        if (!this.m_9236_().f_46443_ && this.m_6084_() && !this.m_6162_() && --this.eggTime <= 0) {
            this.m_5496_(SoundEvents.f_11752_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
            this.m_19998_((ItemLike)this.getEggColorByVariant());
            this.m_146850_(GameEvent.f_157810_);
            this.eggTime = this.f_19796_.m_188503_(6000) + 6000;
        }
    }

    private Item getEggColorByVariant() {
        return switch (Type.byId((Integer)this.f_19804_.m_135370_(DATA_TYPE_ID))) {
            default -> throw new IncompatibleClassChangeError();
            case Type.PINK -> (Item)MysticItems.PINK_EGG.get();
            case Type.ORANGE -> (Item)MysticItems.ORANGE_EGG.get();
            case Type.YELLOW -> (Item)MysticItems.YELLOW_EGG.get();
            case Type.LIME -> (Item)MysticItems.LIME_EGG.get();
            case Type.CYAN -> (Item)MysticItems.CYAN_EGG.get();
            case Type.PURPLE -> (Item)MysticItems.PURPLE_EGG.get();
        };
    }

    public Type getVariantByEggColor(ItemStack stack) {
        if (stack.m_41720_() == MysticItems.PINK_EGG.get()) {
            return Type.PINK;
        }
        if (stack.m_41720_() == MysticItems.ORANGE_EGG.get()) {
            return Type.ORANGE;
        }
        if (stack.m_41720_() == MysticItems.YELLOW_EGG.get()) {
            return Type.YELLOW;
        }
        if (stack.m_41720_() == MysticItems.LIME_EGG.get()) {
            return Type.LIME;
        }
        if (stack.m_41720_() == MysticItems.CYAN_EGG.get()) {
            return Type.CYAN;
        }
        if (stack.m_41720_() == MysticItems.PURPLE_EGG.get()) {
            return Type.PURPLE;
        }
        return null;
    }

    public boolean m_6898_(ItemStack stack) {
        return FOOD_ITEMS.test(stack);
    }

    protected boolean m_142039_() {
        return this.f_146794_ > this.nextFlap;
    }

    protected void m_142043_() {
        this.nextFlap = this.f_146794_ + this.flapSpeed / 2.0f;
    }

    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return this.m_6162_() ? dimensions.f_20378_ * 0.85f : dimensions.f_20378_ * 0.92f;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_11750_;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_11753_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11751_;
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(SoundEvents.f_11754_, 0.15f, 1.0f);
    }

    public static enum Type implements StringRepresentable
    {
        PINK(0, "pink"),
        ORANGE(1, "orange"),
        YELLOW(2, "yellow"),
        LIME(3, "lime"),
        CYAN(4, "cyan"),
        PURPLE(5, "purple");

        final int id;
        final String type;

        private Type(int id, String type) {
            this.id = id;
            this.type = type;
        }

        public int getId() {
            return this.id;
        }

        @Nonnull
        public String m_7912_() {
            return this.type;
        }

        public static Type byId(int id) {
            return (Type)((Object)ByIdMap.m_262839_(Type::getId, (Object[])Type.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO).apply(id));
        }

        public static Type byType(String type) {
            return (Type)StringRepresentable.m_216439_(Type::values).m_262792_(type, (Enum)PINK);
        }

        private static Type getRandomVariant(RandomSource random) {
            Type[] types = (Type[])Arrays.stream(Type.values()).toArray(Type[]::new);
            return (Type)((Object)Util.m_214670_((Object[])types, (RandomSource)random));
        }
    }
}

