/*
 * Decompiled with CFR 0.152.
 */
package com.mysticsbiomes.common.entity.animal;

import com.mysticsbiomes.init.MysticBlocks;
import com.mysticsbiomes.init.MysticEntities;
import com.mysticsbiomes.init.MysticItems;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.eventbus.api.Event;

public class RedPanda
extends Animal {
    private static final EntityDataAccessor<Byte> DATA_TRAIT_ID = SynchedEntityData.m_135353_(RedPanda.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Byte> DATA_HIDDEN_TRAIT_ID = SynchedEntityData.m_135353_(RedPanda.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(RedPanda.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Optional<UUID>> DATA_TRUSTED_ID = SynchedEntityData.m_135353_(RedPanda.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final Predicate<ItemEntity> ALLOWED_ITEMS = item -> {
        ItemStack stack = item.m_32055_();
        return (stack.m_150930_(Items.f_41911_) || stack.m_150930_((Item)MysticItems.SPRING_BAMBOO.get()) || stack.m_150930_((Item)MysticItems.CHERRIES.get())) && !item.m_32063_() && item.m_6084_();
    };
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState sleepingAnimationState = new AnimationState();
    public final AnimationState eatAnimationState = new AnimationState();

    public RedPanda(EntityType<? extends RedPanda> type, Level level) {
        super(type, level);
        this.f_21342_ = new RedPandaMoveControl((Mob)this);
        this.f_21365_ = new RedPandaLookControl((Mob)this);
        if (!this.m_6162_()) {
            this.m_21553_(true);
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_TRAIT_ID, (Object)0);
        this.f_19804_.m_135372_(DATA_HIDDEN_TRAIT_ID, (Object)0);
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
        this.f_19804_.m_135372_(DATA_TRUSTED_ID, Optional.empty());
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new RedPandaPanicGoal((PathfinderMob)this, 2.0));
        this.f_21345_.m_25352_(1, (Goal)new SleepGoal());
        this.f_21345_.m_25352_(1, (Goal)new EatBambooGoal());
        this.f_21345_.m_25352_(2, (Goal)new RedPandaBreedGoal(1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50571_.m_5456_(), ((Block)MysticBlocks.SPRING_BAMBOO.get()).m_5456_()}), false));
        this.f_21345_.m_25352_(4, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 6.0f, 1.6, 2.5, entity -> {
            boolean flag = EntitySelector.f_20406_.test(entity) && !this.trusts(entity.m_20148_()) && entity.m_20142_();
            this.m_6858_(flag);
            return flag;
        }));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.125).m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22281_, 8.0);
    }

    public RedPanda getBreedOffspring(ServerLevel level, AgeableMob mob) {
        RedPanda redPanda = (RedPanda)((EntityType)MysticEntities.RED_PANDA.get()).m_20615_((Level)level);
        if (redPanda != null && mob instanceof RedPanda) {
            RedPanda parent = (RedPanda)mob;
            redPanda.setTraitFromParents(this, parent);
        }
        return redPanda;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor accessor, DifficultyInstance instance, MobSpawnType type, SpawnGroupData data, CompoundTag tag) {
        RandomSource random = accessor.m_213780_();
        this.setMainTrait(Trait.getRandom(random));
        this.setHiddenTrait(Trait.getRandom(random));
        if (random.m_188503_(6) == 0) {
            this.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)MysticItems.CHERRIES.get()));
        }
        return super.m_6518_(accessor, instance, type, data, tag);
    }

    protected void m_5502_(Player player, Mob mob) {
        ((RedPanda)mob).addTrustedPlayer(player.m_20148_());
    }

    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return this.m_6162_() ? dimensions.f_20378_ * 0.85f : 0.4f;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128359_("MainTrait", this.getMainTrait().m_7912_());
        tag.m_128359_("HiddenTrait", this.getHiddenTrait().m_7912_());
        tag.m_128379_("Sleeping", this.m_5803_());
        if (this.getTrustedPlayer() != null) {
            tag.m_128365_("Trusted", (Tag)NbtUtils.m_129226_((UUID)this.getTrustedPlayer()));
        }
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setMainTrait(Trait.byName(tag.m_128461_("MainTrait")));
        this.setHiddenTrait(Trait.byName(tag.m_128461_("HiddenTrait")));
        this.setSleeping(tag.m_128471_("Sleeping"));
        if (tag.m_128441_("Trusted")) {
            this.addTrustedPlayer(NbtUtils.m_129233_((Tag)tag.m_128423_("Trusted")));
        }
    }

    public Trait getMainTrait() {
        return Trait.byId(((Byte)this.f_19804_.m_135370_(DATA_TRAIT_ID)).byteValue());
    }

    public void setMainTrait(Trait trait) {
        this.f_19804_.m_135381_(DATA_TRAIT_ID, (Object)((byte)trait.getId()));
    }

    public Trait getHiddenTrait() {
        return Trait.byId(((Byte)this.f_19804_.m_135370_(DATA_HIDDEN_TRAIT_ID)).byteValue());
    }

    public void setHiddenTrait(Trait trait) {
        this.f_19804_.m_135381_(DATA_HIDDEN_TRAIT_ID, (Object)((byte)trait.getId()));
    }

    public void setTraitFromParents(RedPanda parent, @Nullable RedPanda parent2) {
        if (parent2 == null) {
            if (this.f_19796_.m_188499_()) {
                this.setMainTrait(parent.getOneOfTraitsRandomly());
                this.setHiddenTrait(Trait.getRandom(this.f_19796_));
            } else {
                this.setMainTrait(Trait.getRandom(this.f_19796_));
                this.setHiddenTrait(parent.getOneOfTraitsRandomly());
            }
        } else if (this.f_19796_.m_188499_()) {
            this.setMainTrait(parent.getOneOfTraitsRandomly());
            this.setHiddenTrait(parent2.getOneOfTraitsRandomly());
        } else {
            this.setMainTrait(parent2.getOneOfTraitsRandomly());
            this.setHiddenTrait(parent.getOneOfTraitsRandomly());
        }
        if (this.f_19796_.m_188503_(16) == 0) {
            this.setHiddenTrait(Trait.getRandom(this.f_19796_));
        }
        if (this.f_19796_.m_188503_(16) == 0) {
            this.setHiddenTrait(Trait.getRandom(this.f_19796_));
        }
    }

    private Trait getOneOfTraitsRandomly() {
        return this.f_19796_.m_188499_() ? this.getMainTrait() : this.getHiddenTrait();
    }

    public Trait getVariant() {
        return Trait.getMainTraitFromGenes(this.getMainTrait(), this.getHiddenTrait());
    }

    public boolean m_5803_() {
        return this.getFlag(2);
    }

    public void setSleeping(boolean sleeping) {
        this.setFlag(2, sleeping);
    }

    public void wakeUp() {
        this.setSleeping(false);
    }

    public boolean isEating() {
        return this.getFlag(8);
    }

    public void setEating(boolean eating) {
        this.setFlag(8, eating);
    }

    private boolean getFlag(int value) {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & value) != 0;
    }

    private void setFlag(int value, boolean b) {
        if (b) {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) | value)));
        } else {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & ~value)));
        }
    }

    private UUID getTrustedPlayer() {
        return ((Optional)this.f_19804_.m_135370_(DATA_TRUSTED_ID)).orElse(null);
    }

    private void addTrustedPlayer(UUID uuid) {
        this.f_19804_.m_135381_(DATA_TRUSTED_ID, Optional.ofNullable(uuid));
    }

    private boolean trusts(UUID uuid) {
        return this.getTrustedPlayer() == uuid;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_21515_() && this.m_20069_() && this.m_5803_()) {
            this.setSleeping(false);
        }
        if (this.m_9236_().m_5776_()) {
            this.idleAnimationState.m_246184_(!this.f_267362_.m_267780_() && !this.m_5803_(), this.f_19797_);
            this.sleepingAnimationState.m_246184_(!this.f_267362_.m_267780_() && this.m_5803_(), this.f_19797_);
            this.eatAnimationState.m_246184_(this.isEating(), this.f_19797_);
            if (this.isEating() && this.f_19797_ % 20 == 0) {
                for (int i = 0; i < 3; ++i) {
                    Vec3 vec3 = new Vec3(((double)this.f_19796_.m_188501_() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, ((double)this.f_19796_.m_188501_() - 0.5) * 0.1);
                    this.m_9236_().m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, this.m_6844_(EquipmentSlot.MAINHAND)), this.m_20185_(), this.m_20188_() + 0.25, this.m_20189_(), vec3.f_82479_, vec3.f_82480_ + 0.05, vec3.f_82481_);
                }
            }
        }
    }

    public void m_8107_() {
        if (this.m_5803_() || this.m_6107_()) {
            this.f_20899_ = false;
            this.f_20900_ = 0.0f;
            this.f_20902_ = 0.0f;
        }
        super.m_8107_();
    }

    public void m_7822_(byte b) {
        if (b == 45) {
            ItemStack stack = this.m_6844_(EquipmentSlot.MAINHAND);
            if (!stack.m_41619_()) {
                for (int i = 0; i < 8; ++i) {
                    Vec3 vec3 = new Vec3(((double)this.f_19796_.m_188501_() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0).m_82496_(-this.m_146909_() * ((float)Math.PI / 180)).m_82524_(-this.m_146908_() * ((float)Math.PI / 180));
                    this.m_9236_().m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), this.m_20185_() + this.m_20154_().f_82479_ / 2.0, this.m_20186_(), this.m_20189_() + this.m_20154_().f_82481_ / 2.0, vec3.f_82479_, vec3.f_82480_ + 0.05, vec3.f_82481_);
                }
            }
        } else {
            super.m_7822_(b);
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (!this.m_9236_().f_46443_) {
            this.wakeUp();
            this.setEating(false);
        }
        return super.m_6469_(source, amount);
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_150930_(Items.f_41911_) || stack.m_150930_((Item)MysticItems.SPRING_BAMBOO.get());
    }

    public boolean m_7066_(ItemStack stack) {
        EquipmentSlot slot = Mob.m_147233_((ItemStack)stack);
        if (!this.m_6844_(slot).m_41619_()) {
            return false;
        }
        return slot == EquipmentSlot.MAINHAND && super.m_7066_(stack);
    }

    protected void m_7581_(ItemEntity entity) {
        ItemStack stack = entity.m_32055_();
        if ((this.m_6844_(EquipmentSlot.MAINHAND).m_41619_() || !this.m_6844_(EquipmentSlot.MAINHAND).m_150930_((Item)MysticItems.SPRING_BAMBOO.get())) && ALLOWED_ITEMS.test(entity)) {
            this.m_21053_(entity);
            this.spitOutItem(this.m_6844_(EquipmentSlot.MAINHAND));
            this.m_21053_(entity);
            this.m_8061_(EquipmentSlot.MAINHAND, stack.m_41620_(1));
            this.m_21508_(EquipmentSlot.MAINHAND);
            this.m_7938_((Entity)entity, 1);
            entity.m_146870_();
        }
    }

    private void spitOutItem(ItemStack stack) {
        if (!stack.m_41619_() && !this.m_9236_().f_46443_) {
            ItemEntity entity = new ItemEntity(this.m_9236_(), this.m_20185_() + this.m_20154_().f_82479_, this.m_20186_() + 1.0, this.m_20189_() + this.m_20154_().f_82481_, stack);
            entity.m_32010_(40);
            entity.m_32052_(this.m_20148_());
            this.m_5496_(SoundEvents.f_11952_, 1.0f, 1.0f);
            this.m_9236_().m_7967_((Entity)entity);
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (this.m_6898_(stack)) {
            if (this.m_6162_()) {
                this.m_142075_(player, hand, stack);
                this.m_146740_((int)((float)(-this.m_146764_() / 20) * 0.1f), true);
            } else if (!this.m_9236_().f_46443_ && this.m_146764_() == 0 && this.m_5957_()) {
                this.m_142075_(player, hand, stack);
                this.m_27595_(player);
            } else {
                if (this.m_9236_().f_46443_ || this.m_20069_()) {
                    return InteractionResult.PASS;
                }
                this.m_5584_(this.m_9236_(), stack);
                ItemStack mainHandStack = this.m_6844_(EquipmentSlot.MAINHAND);
                if (!mainHandStack.m_41619_() && !player.m_150110_().f_35937_) {
                    this.m_19983_(mainHandStack);
                }
                this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)stack.m_41720_(), 1));
                this.m_142075_(player, hand, stack);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    class RedPandaMoveControl
    extends MoveControl {
        public RedPandaMoveControl(Mob mob) {
            super(mob);
        }

        public void m_8126_() {
            if (!RedPanda.this.m_5803_() && !RedPanda.this.isEating()) {
                super.m_8126_();
            }
        }
    }

    class RedPandaLookControl
    extends LookControl {
        public RedPandaLookControl(Mob mob) {
            super(mob);
        }

        public void m_8128_() {
            if (!RedPanda.this.m_5803_() && !RedPanda.this.isEating()) {
                super.m_8128_();
            }
        }
    }

    class RedPandaPanicGoal
    extends PanicGoal {
        public RedPandaPanicGoal(PathfinderMob mob, double speed) {
            super(mob, speed);
        }

        public void m_8041_() {
            super.m_8041_();
            if (RedPanda.this.m_9236_().m_46462_() && !RedPanda.this.m_20069_()) {
                RedPanda.this.setSleeping(true);
            }
        }
    }

    class SleepGoal
    extends Goal {
        SleepGoal() {
        }

        public boolean m_8036_() {
            return RedPanda.this.m_9236_().m_46462_() && !RedPanda.this.m_20069_();
        }

        public boolean m_8045_() {
            return this.m_8036_();
        }

        public void m_8056_() {
            RedPanda.this.setSleeping(true);
        }

        public void m_8041_() {
            RedPanda.this.wakeUp();
        }
    }

    class EatBambooGoal
    extends Goal {
        private int ticksEating;

        EatBambooGoal() {
        }

        public boolean m_8036_() {
            return RedPanda.this.m_6898_(RedPanda.this.m_21205_()) && !RedPanda.this.m_5803_() && !RedPanda.this.m_20069_() && RedPanda.this.f_19796_.m_188503_(80) == 0;
        }

        public boolean m_8045_() {
            return this.ticksEating < 100;
        }

        public void m_8056_() {
            this.ticksEating = 0;
            RedPanda.this.setEating(true);
            RedPanda.this.f_21344_.m_26573_();
        }

        public void m_8041_() {
            RedPanda.this.setEating(false);
            RedPanda.this.m_21205_().m_41774_(1);
        }

        public void m_8037_() {
            ++this.ticksEating;
        }
    }

    class RedPandaBreedGoal
    extends BreedGoal {
        public RedPandaBreedGoal(double speed) {
            super((Animal)RedPanda.this, speed);
        }

        public boolean m_8036_() {
            return super.m_8036_() && this.canFindBamboo();
        }

        protected void m_8026_() {
            ServerLevel level = (ServerLevel)this.f_25114_;
            RedPanda redPanda = (RedPanda)this.f_25113_.m_142606_(level, (AgeableMob)this.f_25115_);
            BabyEntitySpawnEvent event = new BabyEntitySpawnEvent((Mob)this.f_25113_, (Mob)this.f_25115_, (AgeableMob)redPanda);
            redPanda = (RedPanda)event.getChild();
            boolean cancelled = MinecraftForge.EVENT_BUS.post((Event)event);
            if (cancelled) {
                this.f_25113_.m_146762_(6000);
                this.f_25115_.m_146762_(6000);
                this.f_25113_.m_27594_();
                this.f_25115_.m_27594_();
            } else if (redPanda != null) {
                ServerPlayer causePlayer = this.f_25113_.m_27592_();
                ServerPlayer causePlayer2 = this.f_25115_.m_27592_();
                ServerPlayer player = causePlayer;
                if (causePlayer != null) {
                    redPanda.addTrustedPlayer(causePlayer.m_20148_());
                } else {
                    player = causePlayer2;
                }
                if (causePlayer2 != null && causePlayer != causePlayer2) {
                    redPanda.addTrustedPlayer(causePlayer2.m_20148_());
                }
                if (player != null) {
                    player.m_36220_(Stats.f_12937_);
                    CriteriaTriggers.f_10581_.m_147278_(player, this.f_25113_, this.f_25115_, (AgeableMob)redPanda);
                }
                this.f_25113_.m_146762_(6000);
                this.f_25115_.m_146762_(6000);
                this.f_25113_.m_27594_();
                this.f_25115_.m_27594_();
                redPanda.m_146762_(-24000);
                redPanda.m_7678_(this.f_25113_.m_20185_(), this.f_25113_.m_20186_(), this.f_25113_.m_20189_(), 0.0f, 0.0f);
                level.m_47205_((Entity)redPanda);
                this.f_25114_.m_7605_((Entity)this.f_25113_, (byte)18);
                if (this.f_25114_.m_46469_().m_46207_(GameRules.f_46135_)) {
                    this.f_25114_.m_7967_((Entity)new ExperienceOrb(this.f_25114_, this.f_25113_.m_20185_(), this.f_25113_.m_20186_(), this.f_25113_.m_20189_(), this.f_25113_.m_217043_().m_188503_(7) + 1));
                }
            }
        }

        private boolean canFindBamboo() {
            BlockPos pos = RedPanda.this.m_20183_();
            BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 8; ++j) {
                    int k = 0;
                    while (k <= j) {
                        int l;
                        int n = l = k < j && k > -j ? j : 0;
                        while (l <= j) {
                            mutablePos.m_122154_((Vec3i)pos, k, i, l);
                            BlockState mutableState = this.f_25114_.m_8055_((BlockPos)mutablePos);
                            if (mutableState.m_60713_(Blocks.f_50571_) || mutableState.m_60713_((Block)MysticBlocks.SPRING_BAMBOO.get())) {
                                return true;
                            }
                            l = l > 0 ? -l : 1 - l;
                        }
                        k = k > 0 ? -k : 1 - k;
                    }
                }
            }
            return false;
        }
    }

    public static enum Trait implements StringRepresentable
    {
        NORMAL(0, "normal", false),
        CLUMSY(1, "clumsy", false),
        WEAK(2, "weak", true),
        LAZY(3, "lazy", false),
        PLAYFUL(4, "playful", false),
        MISCHIEVOUS(5, "mischievous", false),
        CHERRY(6, "cherry", true);

        private final int id;
        private final String name;
        private final boolean recessive;

        private Trait(int id, String name, boolean recessive) {
            this.id = id;
            this.name = name;
            this.recessive = recessive;
        }

        public String m_7912_() {
            return this.name;
        }

        public int getId() {
            return this.id;
        }

        public boolean isRecessive() {
            return this.recessive;
        }

        public static Trait byName(String name) {
            return (Trait)StringRepresentable.m_216439_(Trait::values).m_262792_(name, (Enum)NORMAL);
        }

        public static Trait byId(int id) {
            return (Trait)((Object)ByIdMap.m_262839_(Trait::getId, (Object[])Trait.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO).apply(id));
        }

        public static Trait getMainTraitFromGenes(Trait trait1, Trait trait2) {
            if (trait1.isRecessive()) {
                return trait1 == trait2 ? trait1 : NORMAL;
            }
            return trait1;
        }

        public static Trait getRandom(RandomSource source) {
            int i = source.m_188503_(8);
            if (i == 0) {
                return CLUMSY;
            }
            if (i == 1) {
                return WEAK;
            }
            if (i == 2) {
                return LAZY;
            }
            if (i == 4) {
                return PLAYFUL;
            }
            if (i == 5) {
                return MISCHIEVOUS;
            }
            return i == 6 ? CHERRY : NORMAL;
        }
    }
}

