/*
 * Decompiled with CFR 0.152.
 */
package com.mysticsbiomes.common.entity.animal;

import com.mysticsbiomes.init.MysticBiomes;
import com.mysticsbiomes.init.MysticBlocks;
import com.mysticsbiomes.init.MysticEntities;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.sniffer.Sniffer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.AmphibiousNodeEvaluator;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.phys.Vec3;

public class SeaOtter
extends Animal {
    public static final EntityDataSerializer<State> SEA_OTTER_STATE = EntityDataSerializer.m_238090_(State.class);
    private static final EntityDataAccessor<State> DATA_STATE_ID = SynchedEntityData.m_135353_(Sniffer.class, SEA_OTTER_STATE);
    private static final EntityDataAccessor<Byte> DATA_TYPE_ID = SynchedEntityData.m_135353_(SeaOtter.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Boolean> DATA_FLOATING_ID = SynchedEntityData.m_135353_(SeaOtter.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private boolean needsToSurface;
    private int ticksSinceLastSwamAround;
    private int ticksOutOfWater;
    @Nullable
    private BlockPos surfacePos;
    public final AnimationState startSwimmingAnimationState = new AnimationState();
    public final AnimationState startFloatingAnimationState = new AnimationState();
    public final AnimationState floatingAnimationState = new AnimationState();
    public final AnimationState sitDownAnimationState = new AnimationState();
    public final AnimationState sitUpAnimationState = new AnimationState();

    public SeaOtter(EntityType<? extends SeaOtter> type, Level level) {
        super(type, level);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_274367_(1.0f);
        this.f_21342_ = new SeaOtterMoveControl((Mob)this);
        this.f_21365_ = new SeaOtterLookControl((Mob)this);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_STATE_ID, (Object)State.FLOATING);
        this.f_19804_.m_135372_(DATA_TYPE_ID, (Object)0);
        this.f_19804_.m_135372_(DATA_FLOATING_ID, (Object)false);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new PanicGoal((PathfinderMob)this, 2.0));
        this.f_21345_.m_25352_(0, (Goal)new SwimToSurfaceGoal((PathfinderMob)this, 1.0, 16));
        this.f_21345_.m_25352_(0, (Goal)new MoveToWaterGoal((PathfinderMob)this, 1.0, 16));
        this.f_21345_.m_25352_(1, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)MysticBlocks.MILKWEED.get()}), false));
        this.f_21345_.m_25352_(3, (Goal)new SwimAroundGoal((PathfinderMob)this, 1.0, 10));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f, 0.02f, true));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(6, (Goal)new FloatGoal());
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 16.0).m_22268_(Attributes.f_22279_, 1.0);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128359_("Type", this.getVariant().m_7912_());
        tag.m_128379_("Floating", this.isFloating());
        tag.m_128379_("NeedsToSurface", this.needsToSurface());
        tag.m_128405_("TicksSinceSwam", this.ticksSinceLastSwamAround);
        tag.m_128405_("TicksOutOfWater", this.ticksOutOfWater);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setVariant(Type.byName(tag.m_128461_("Type")));
        this.setFloating(tag.m_128471_("Floating"));
        this.setNeedsToSurface(tag.m_128471_("NeedsToSurface"));
        this.ticksSinceLastSwamAround = tag.m_128451_("TicksSinceSwam");
        this.ticksOutOfWater = tag.m_128451_("TicksOutOfWater");
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor accessor, DifficultyInstance instance, MobSpawnType type, SpawnGroupData data, CompoundTag tag) {
        RandomSource random = accessor.m_213780_();
        this.setVariant(Type.getRandomVariant(random));
        return super.m_6518_(accessor, instance, type, data, tag);
    }

    public static boolean checkSurfaceWaterAnimalSpawnRules(EntityType<? extends SeaOtter> entity, LevelAccessor level, MobSpawnType type, BlockPos pos, RandomSource random) {
        return level.m_6425_(pos.m_7495_()).m_205070_(FluidTags.f_13131_) && level.m_8055_(pos.m_7494_()).m_60713_(Blocks.f_49990_) && level.m_204166_(pos).m_203565_(MysticBiomes.LAGOON);
    }

    public AgeableMob m_142606_(ServerLevel level, AgeableMob mob) {
        return (AgeableMob)((EntityType)MysticEntities.SEA_OTTER.get()).m_20615_((Level)level);
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    public Type getVariant() {
        return Type.byId(((Byte)this.f_19804_.m_135370_(DATA_TYPE_ID)).byteValue());
    }

    public void setVariant(Type type) {
        this.f_19804_.m_135381_(DATA_TYPE_ID, (Object)((byte)type.getId()));
    }

    public int m_6062_() {
        return 6000;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.isFloating()) {
            this.f_19798_ = true;
            this.m_20301_(this.m_6062_());
            this.m_20256_(this.m_20184_().m_82542_(1.0, 0.0, 1.0));
        }
        if (!this.m_9236_().f_46443_) {
            if (this.isFloating()) {
                ++this.ticksSinceLastSwamAround;
            }
            if (!this.isFloating() && !this.m_20069_()) {
                ++this.ticksOutOfWater;
            }
        }
        if (this.m_9236_().f_46443_) {
            this.floatingAnimationState.m_246184_(this.isFloating() && !this.isInAnimationTransition(), this.f_19797_);
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_21515_() && this.m_6084_() && !this.needsToSurface && this.m_5842_() && (!this.wantsToSwim() || this.m_20146_() < 400)) {
            this.setNeedsToSurface(true);
        }
    }

    public void m_7023_(Vec3 vec3) {
        if (this.m_21515_() && this.m_20069_()) {
            this.m_19920_(this.m_6113_(), vec3);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
        } else {
            super.m_7023_(vec3);
        }
    }

    protected PathNavigation m_6037_(Level level) {
        return new SeaOtterPathNavigation((Mob)this, level);
    }

    protected BodyRotationControl m_7560_() {
        return new SeaOtterBodyRotationControl((Mob)this);
    }

    public SeaOtter transitionTo(State state) {
        this.resetAnimations();
        switch (state) {
            case SWIMMING: {
                this.setState(State.SWIMMING).setFloating(false);
                this.startSwimmingAnimationState.m_216982_(this.f_19797_);
                break;
            }
            case FLOATING: {
                this.setState(State.FLOATING).setFloating(true);
                break;
            }
            case WALKING: {
                this.setState(State.WALKING);
                break;
            }
            case RESTING: {
                this.setState(State.RESTING);
            }
        }
        return this;
    }

    public void resetAnimations() {
        this.startSwimmingAnimationState.m_216973_();
        this.startFloatingAnimationState.m_216973_();
        this.sitDownAnimationState.m_216973_();
        this.sitUpAnimationState.m_216973_();
    }

    public boolean isInAnimationTransition() {
        return this.startSwimmingAnimationState.m_216984_() || this.startFloatingAnimationState.m_216984_() || this.sitDownAnimationState.m_216984_() || this.sitUpAnimationState.m_216984_();
    }

    private State getState() {
        return (State)((Object)this.f_19804_.m_135370_(DATA_STATE_ID));
    }

    private SeaOtter setState(State state) {
        this.f_19804_.m_135381_(DATA_STATE_ID, (Object)state);
        return this;
    }

    public boolean isFloating() {
        return (Boolean)this.f_19804_.m_135370_(DATA_FLOATING_ID);
    }

    public void setFloating(boolean value) {
        this.f_19804_.m_135381_(DATA_FLOATING_ID, (Object)value);
    }

    public boolean wantsToSwim() {
        return this.ticksSinceLastSwamAround > 300;
    }

    public void resetTicksSinceLastSwam() {
        this.ticksSinceLastSwamAround = 0;
    }

    public boolean needsToSurface() {
        return this.needsToSurface;
    }

    public void setNeedsToSurface(boolean value) {
        this.needsToSurface = value;
    }

    @Nullable
    public BlockPos getSurfacePos() {
        return this.surfacePos;
    }

    public void setSurfacePos(@Nullable BlockPos pos) {
        this.surfacePos = pos;
    }

    public boolean wantsToGoInWater() {
        return this.ticksOutOfWater > 200;
    }

    private class SeaOtterMoveControl
    extends MoveControl {
        public SeaOtterMoveControl(Mob mob) {
            super(mob);
        }

        public void m_8126_() {
            if (SeaOtter.this.m_20069_()) {
                SeaOtter.this.m_20256_(SeaOtter.this.m_20184_().m_82520_(0.0, 0.005, 0.0));
                if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !SeaOtter.this.m_21573_().m_26571_()) {
                    double d2;
                    double d1;
                    double d0 = this.f_24975_ - SeaOtter.this.m_20185_();
                    double d3 = d0 * d0 + (d1 = this.f_24976_ - SeaOtter.this.m_20186_()) * d1 + (d2 = this.f_24977_ - SeaOtter.this.m_20189_()) * d2;
                    if (d3 < 2.500000277905201E-7) {
                        SeaOtter.this.m_21564_(0.0f);
                    } else {
                        float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                        SeaOtter.this.m_146922_(this.m_24991_(SeaOtter.this.m_146908_(), f, 10.0f));
                        SeaOtter.this.f_20883_ = SeaOtter.this.m_146908_();
                        SeaOtter.this.f_20885_ = SeaOtter.this.m_146908_();
                        float speed = (float)(this.f_24978_ * SeaOtter.this.m_21133_(Attributes.f_22279_));
                        SeaOtter.this.m_7910_(speed * 0.02f);
                        double d4 = Math.sqrt(d0 * d0 + d2 * d2);
                        if (Math.abs(d1) > (double)1.0E-5f || Math.abs(d4) > (double)1.0E-5f) {
                            float f3 = -((float)(Mth.m_14136_((double)d1, (double)d4) * 57.2957763671875));
                            f3 = Mth.m_14036_((float)Mth.m_14177_((float)f3), (float)-85.0f, (float)85.0f);
                            SeaOtter.this.m_146926_(this.m_24991_(SeaOtter.this.m_146909_(), f3, 5.0f));
                        }
                        if (d1 > (double)SeaOtter.this.m_274421_() && d0 * d0 + d2 * d2 < 4.0 && d1 <= 1.0 && SeaOtter.this.m_9236_().m_8055_(BlockPos.m_274561_((double)this.f_24975_, (double)this.f_24976_, (double)this.f_24977_)).m_60819_().m_76178_()) {
                            SeaOtter.this.m_21569_().m_24901_();
                            SeaOtter.this.m_7910_(speed);
                        }
                        float f6 = Mth.m_14089_((float)(SeaOtter.this.m_146909_() * ((float)Math.PI / 180)));
                        float f4 = Mth.m_14031_((float)(SeaOtter.this.m_146909_() * ((float)Math.PI / 180)));
                        SeaOtter.this.f_20902_ = f6 * speed;
                        SeaOtter.this.f_20901_ = -f4 * speed;
                    }
                } else {
                    SeaOtter.this.m_7910_(0.0f);
                    SeaOtter.this.m_21570_(0.0f);
                    SeaOtter.this.m_21567_(0.0f);
                    SeaOtter.this.m_21564_(0.0f);
                }
            } else {
                this.f_24978_ = 0.15f;
                super.m_8126_();
            }
        }
    }

    private class SeaOtterLookControl
    extends LookControl {
        public SeaOtterLookControl(Mob mob) {
            super(mob);
        }

        public void m_8128_() {
            if (!SeaOtter.this.isFloating() && !SeaOtter.this.isInAnimationTransition()) {
                if (SeaOtter.this.m_20069_()) {
                    if (this.f_186068_ > 0) {
                        --this.f_186068_;
                        this.m_180896_().ifPresent(i -> {
                            this.f_24937_.f_20885_ = this.m_24956_(this.f_24937_.f_20885_, i.floatValue() + 20.0f, this.f_24938_);
                        });
                        this.m_180897_().ifPresent(i -> this.f_24937_.m_146926_(this.m_24956_(this.f_24937_.m_146909_(), i.floatValue() + 10.0f, this.f_24939_)));
                    } else {
                        if (this.f_24937_.m_21573_().m_26571_()) {
                            this.f_24937_.m_146926_(this.m_24956_(this.f_24937_.m_146909_(), 0.0f, 5.0f));
                        }
                        this.f_24937_.f_20885_ = this.m_24956_(this.f_24937_.f_20885_, this.f_24937_.f_20883_, this.f_24938_);
                    }
                } else {
                    super.m_8128_();
                }
            }
        }
    }

    public static enum State {
        SWIMMING,
        FLOATING,
        WALKING,
        RESTING;

    }

    class SwimToSurfaceGoal
    extends MoveToBlockGoal {
        public SwimToSurfaceGoal(PathfinderMob mob, double speed, int range) {
            super(mob, speed, range);
        }

        public boolean m_8036_() {
            return SeaOtter.this.needsToSurface();
        }

        public boolean m_8045_() {
            return !this.m_6669_().m_203195_((Position)SeaOtter.this.m_20182_(), 1.0);
        }

        public void m_8041_() {
            SeaOtter.this.transitionTo(State.FLOATING);
            SeaOtter.this.setFloating(true);
            SeaOtter.this.setNeedsToSurface(false);
            SeaOtter.this.m_21573_().m_26573_();
        }

        public void m_8037_() {
            BlockPos pos;
            Optional<BlockPos> optional;
            if (this.f_25602_ == BlockPos.f_121853_ && (optional = this.findAir()).isPresent()) {
                this.f_25602_ = optional.get();
                SeaOtter.this.setSurfacePos(this.f_25602_);
            }
            if (!(pos = this.m_6669_()).m_203195_((Position)SeaOtter.this.m_20182_(), 1.0)) {
                SeaOtter.this.f_21344_.m_26519_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, this.f_25599_);
            }
        }

        protected BlockPos m_6669_() {
            return this.f_25602_;
        }

        protected boolean m_6465_(LevelReader level, BlockPos pos) {
            return level.m_8055_(pos).m_60795_() && level.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_49990_);
        }

        protected Optional<BlockPos> findAir() {
            BlockPos pos = SeaOtter.this.m_20183_();
            BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
            int k = this.f_25603_;
            while ((double)k <= 16.0) {
                int l = 0;
                while ((double)l < 16.0) {
                    int i1 = 0;
                    while (i1 <= l) {
                        int j1;
                        int n = j1 = i1 < l && i1 > -l ? l : 0;
                        while (j1 <= l) {
                            mutablePos.m_122154_((Vec3i)pos, i1, k - 1, j1);
                            if (pos.m_123314_((Vec3i)mutablePos, 16.0) && this.m_6465_((LevelReader)SeaOtter.this.m_9236_(), (BlockPos)mutablePos)) {
                                this.f_25602_ = mutablePos;
                                return Optional.of(mutablePos);
                            }
                            j1 = j1 > 0 ? -j1 : 1 - j1;
                        }
                        i1 = i1 > 0 ? -i1 : 1 - i1;
                    }
                    ++l;
                }
                k = k > 0 ? -k : 1 - k;
            }
            return Optional.empty();
        }
    }

    class MoveToWaterGoal
    extends MoveToBlockGoal {
        public MoveToWaterGoal(PathfinderMob mob, double speed, int distance) {
            super(mob, speed, distance);
        }

        public boolean m_8036_() {
            if (SeaOtter.this.m_20069_() || SeaOtter.this.isFloating()) {
                return false;
            }
            return SeaOtter.this.wantsToGoInWater() && super.m_8036_();
        }

        public double m_8052_() {
            return 0.0;
        }

        protected boolean m_6465_(LevelReader level, BlockPos pos) {
            return level.m_8055_(pos).m_60819_().m_205070_(FluidTags.f_13131_) && level.m_8055_(pos.m_7495_()).m_60819_().m_205070_(FluidTags.f_13131_);
        }
    }

    class SwimAroundGoal
    extends RandomSwimmingGoal {
        private int ticksSwimming;

        public SwimAroundGoal(PathfinderMob mob, double speed, int interval) {
            super(mob, speed, interval);
        }

        public boolean m_8036_() {
            return !SeaOtter.this.needsToSurface() && SeaOtter.this.wantsToSwim() && super.m_8036_();
        }

        public boolean m_8045_() {
            return !SeaOtter.this.needsToSurface() && this.ticksSwimming <= 200 && super.m_8045_();
        }

        public void m_8056_() {
            super.m_8056_();
            SeaOtter.this.transitionTo(State.SWIMMING);
        }

        public void m_8041_() {
            super.m_8041_();
            if (this.ticksSwimming > 200) {
                this.ticksSwimming = 0;
                SeaOtter.this.setNeedsToSurface(true);
                SeaOtter.this.resetTicksSinceLastSwam();
            }
        }

        protected Vec3 m_7037_() {
            return BehaviorUtils.m_147444_((PathfinderMob)this.f_25725_, (int)10, (int)4);
        }

        public void m_8037_() {
            this.m_25751_();
            ++this.ticksSwimming;
        }
    }

    class FloatGoal
    extends Goal {
        FloatGoal() {
        }

        public boolean m_8036_() {
            return !SeaOtter.this.wantsToSwim() && SeaOtter.this.getSurfacePos() != null && SeaOtter.this.getSurfacePos().m_123314_((Vec3i)SeaOtter.this.m_20183_(), 0.0);
        }

        public void m_8056_() {
            SeaOtter.this.transitionTo(State.FLOATING);
            SeaOtter.this.setFloating(true);
        }

        public void m_8041_() {
            SeaOtter.this.transitionTo(State.SWIMMING);
            SeaOtter.this.setFloating(false);
            SeaOtter.this.setSurfacePos(null);
        }
    }

    public static enum Type implements StringRepresentable
    {
        BROWN(0, "brown"),
        BEIGE(1, "beige"),
        GRAY(2, "gray");

        final int id;
        final String type;

        private Type(int id, String type) {
            this.id = id;
            this.type = type;
        }

        public int getId() {
            return this.id;
        }

        @Nonnull
        public String m_7912_() {
            return this.type;
        }

        public static Type byId(int id) {
            return (Type)((Object)ByIdMap.m_262839_(Type::getId, (Object[])Type.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO).apply(id));
        }

        public static Type byName(String name) {
            return (Type)StringRepresentable.m_216439_(Type::values).m_262792_(name, (Enum)BROWN);
        }

        private static Type getRandomVariant(RandomSource random) {
            Type[] types = (Type[])Arrays.stream(Type.values()).toArray(Type[]::new);
            return (Type)((Object)Util.m_214670_((Object[])types, (RandomSource)random));
        }
    }

    private class SeaOtterPathNavigation
    extends WaterBoundPathNavigation {
        public SeaOtterPathNavigation(Mob mob, Level level) {
            super(mob, level);
        }

        protected PathFinder m_5532_(int nodes) {
            this.f_26508_ = new AmphibiousNodeEvaluator(true);
            return new PathFinder(this.f_26508_, nodes);
        }

        protected boolean m_7632_() {
            return true;
        }

        public boolean m_6342_(BlockPos pos) {
            BlockState belowState = this.f_26495_.m_8055_(pos.m_7495_());
            if (SeaOtter.this.m_20069_()) {
                return !belowState.m_60795_() && !belowState.m_60819_().m_205070_(FluidTags.f_13131_);
            }
            return !belowState.m_60795_();
        }
    }

    private class SeaOtterBodyRotationControl
    extends BodyRotationControl {
        public SeaOtterBodyRotationControl(Mob mob) {
            super(mob);
        }

        public void m_8121_() {
            if (!SeaOtter.this.isFloating()) {
                super.m_8121_();
            }
        }
    }
}

