/*
 * Decompiled with CFR 0.152.
 */
package com.mysticsbiomes.common.item;

import com.mysticsbiomes.common.entity.animal.Butterfly;
import com.mysticsbiomes.init.MysticEntities;
import com.mysticsbiomes.init.MysticItems;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ButterflyJarItem
extends Item {
    private final Butterfly.Type type;

    public ButterflyJarItem(Butterfly.Type type) {
        super(new Item.Properties().m_41487_(1));
        this.type = type;
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity entity, InteractionHand hand) {
        if (this.type == null && !player.m_9236_().f_46443_ && entity instanceof Butterfly) {
            Butterfly butterfly = (Butterfly)entity;
            ItemStack butterflyJar = this.getItemByType(butterfly.getVariant()).m_7968_();
            CompoundTag tag = new CompoundTag();
            tag.m_128365_("EntityData", (Tag)butterfly.serializeNBT());
            butterflyJar.m_41784_().m_128365_("Butterfly", (Tag)tag);
            entity.m_146870_();
            if (!player.m_7500_()) {
                if (stack.m_41613_() > 1) {
                    stack.m_41774_(1);
                    player.m_36356_(butterflyJar);
                } else {
                    player.m_21008_(hand, butterflyJar);
                }
            } else {
                player.m_36356_(butterflyJar);
            }
            player.f_36095_.m_38946_();
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        Level level = context.m_43725_();
        ItemStack stack = context.m_43722_();
        BlockPos pos = context.m_8083_().m_7918_(context.m_43719_().m_122429_(), context.m_43719_().m_122430_(), context.m_43719_().m_122431_());
        if (this.type != null && stack.m_41720_() == this.getItemByType(this.type) && !level.f_46443_ && player != null) {
            Vec3 vec3 = new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
            if (stack.m_41783_() != null) {
                CompoundTag tag = stack.m_41783_().m_128469_("Butterfly").m_128469_("EntityData");
                Entity entity = EntityType.m_20645_((CompoundTag)tag, (Level)level, mob -> mob);
                if (entity != null) {
                    entity.m_146884_(vec3);
                    level.m_7967_(entity);
                }
            } else {
                Butterfly butterfly = new Butterfly((EntityType<? extends Butterfly>)((EntityType)MysticEntities.BUTTERFLY.get()), level);
                butterfly.m_146884_(vec3);
                butterfly.setVariant(this.type);
                level.m_7967_((Entity)butterfly);
            }
            if (!player.m_7500_()) {
                player.m_21008_(context.m_43724_(), new ItemStack((ItemLike)MysticItems.GLASS_JAR.get()));
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6225_(context);
    }

    public Component m_7626_(ItemStack stack) {
        return this.type != null ? Component.m_237115_((String)"item.mysticsbiomes.butterfly_jar").m_130940_(ChatFormatting.AQUA) : super.m_7626_(stack);
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> components, TooltipFlag flag) {
        if (this.type != null) {
            components.add((Component)Component.m_237115_((String)("entity.mysticsbiomes.butterfly.type." + this.type.m_7912_())).m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        }
    }

    public Item getItemByType(Butterfly.Type type) {
        if (type == Butterfly.Type.TANGERINE) {
            return (Item)MysticItems.ORANGE_BUTTERFLY_IN_JAR.get();
        }
        if (type == Butterfly.Type.JELLY) {
            return (Item)MysticItems.BLUE_BUTTERFLY_IN_JAR.get();
        }
        if (type == Butterfly.Type.JULY) {
            return (Item)MysticItems.CYAN_BUTTERFLY_IN_JAR.get();
        }
        if (type == Butterfly.Type.CANDY) {
            return (Item)MysticItems.LILAC_BUTTERFLY_IN_JAR.get();
        }
        if (type == Butterfly.Type.VALENTINE) {
            return (Item)MysticItems.PINK_BUTTERFLY_IN_JAR.get();
        }
        if (type == Butterfly.Type.MYSTIC) {
            return (Item)MysticItems.PURPLE_BUTTERFLY_IN_JAR.get();
        }
        return null;
    }
}

