/*
 * Decompiled with CFR 0.152.
 */
package com.mysticsbiomes.common.world;

import com.mojang.serialization.Codec;
import com.mysticsbiomes.MysticsBiomes;
import com.mysticsbiomes.init.MysticConfig;
import com.mysticsbiomes.init.MysticEntities;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class AnimalSpawnsBuilder
implements BiomeModifier {
    private static final RegistryObject<Codec<? extends BiomeModifier>> SERIALIZER = RegistryObject.create((ResourceLocation)MysticsBiomes.modLoc("animal_spawns"), (ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"mysticsbiomes");

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.ADD) {
            AnimalSpawnsBuilder.addAnimalSpawns(biome, builder);
        }
    }

    public Codec<? extends BiomeModifier> codec() {
        return (Codec)SERIALIZER.get();
    }

    public static Codec<AnimalSpawnsBuilder> makeCodec() {
        return Codec.unit(AnimalSpawnsBuilder::new);
    }

    public static void addAnimalSpawns(Holder<Biome> biome, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        for (String biomeIdentifier : (List)MysticConfig.COMMON.rainbowChickenBiomeSpawns.get()) {
            ResourceLocation biomeLocation = ResourceLocation.m_135820_((String)biomeIdentifier);
            if (!biome.m_203373_(biomeLocation) && !AnimalSpawnsBuilder.isBiomeTag(biomeLocation)) continue;
            builder.getMobSpawnSettings().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)MysticEntities.RAINBOW_CHICKEN.get(), ((Integer)MysticConfig.COMMON.rainbowChickenSpawnChance.get()).intValue(), 2, 3));
        }
    }

    private static boolean isBiomeTag(ResourceLocation location) {
        return location != null && location.m_135815_().startsWith("tag/biomes");
    }
}

